/*
 * Decompiled with CFR 0.152.
 */
package net.elvum.hpgen;

import com.twmacinta.util.MD5;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreException;
import net.elvum.hpgen.Conversions;
import net.elvum.hpgen.HPGenPrefs;
import net.intertwingly.SHA1;

public class HashPasswordGenerator
extends MIDlet
implements CommandListener {
    private boolean midletPaused = false;
    private MD5 md5 = new MD5();
    private HPGenPrefs prefs = HPGenPrefs.getInstance();
    private Hashtable __previousDisplayables = new Hashtable();
    private Command exitCommand;
    private Command generateCommand;
    private Command okCommand;
    private Command preferencesCommand;
    private Command cancelCommand;
    private Command chooseDomainCommand;
    private Command okChooseDomainCommand;
    private Command cancelChooseDomainCommand;
    private Command manageDomainsCommand;
    private Command aboutCommand;
    private Command deleteCommand;
    private Command selectAllCommand;
    private Command backCommand;
    private Command selectNoneCommand;
    private Command okCommand1;
    private Form mainForm;
    private TextField passwordField;
    private StringItem generatedPassword;
    private TextField domainField;
    private Form preferencesForm;
    private ChoiceGroup choiceHashFunction;
    private ChoiceGroup choicePresentation;
    private TextField lengthField;
    private ChoiceGroup choiceStoreDomains;
    private Form chooseDomainForm;
    private ChoiceGroup choiceDomain;
    private Form manageDomainsForm;
    private ChoiceGroup manageDomainsChoiceGroup;
    private Form aboutForm;
    private StringItem stringItem1;

    private void deleteDomains() {
        boolean[] selected = new boolean[this.manageDomainsChoiceGroup.size()];
        this.manageDomainsChoiceGroup.getSelectedFlags(selected);
        for (int i = 0; i < selected.length; ++i) {
            if (!selected[i]) continue;
            try {
                this.prefs.deleteDomain(this.manageDomainsChoiceGroup.getString(i));
                continue;
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        this.refreshManageDomainsForm(this.prefs.getDomainList());
    }

    private void refreshManageDomainsForm(String[] domains) {
        while (this.manageDomainsChoiceGroup.size() > 0) {
            this.manageDomainsChoiceGroup.delete(0);
        }
        for (int i = domains.length - 1; i >= 0; --i) {
            this.manageDomainsChoiceGroup.append(domains[i], null);
        }
    }

    private void selectAllDomains() {
        boolean[] selected = new boolean[this.manageDomainsChoiceGroup.size()];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = true;
        }
        this.manageDomainsChoiceGroup.setSelectedFlags(selected);
    }

    private void selectNoDomains() {
        boolean[] selected = new boolean[this.manageDomainsChoiceGroup.size()];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = false;
        }
        this.manageDomainsChoiceGroup.setSelectedFlags(selected);
    }

    private void switchToPreviousDisplayable() {
        Displayable __nextDisplayable;
        Displayable __currentDisplayable = this.getDisplay().getCurrent();
        if (__currentDisplayable != null && (__nextDisplayable = (Displayable)this.__previousDisplayables.get(__currentDisplayable)) != null) {
            this.switchDisplayable(null, __nextDisplayable);
        }
    }

    private void initialize() {
    }

    public void startMIDlet() {
        this.switchDisplayable(null, (Displayable)this.getMainForm());
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display;
        Displayable __currentDisplayable;
        String[] domains;
        if (nextDisplayable.equals(this.getChooseDomainForm())) {
            domains = this.prefs.getDomainList();
            if (domains.length == 0) {
                nextDisplayable = this.mainForm;
                alert = new Alert("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0435 \u0438\u043c\u044f", "\u0414\u043e\u043c\u0435\u043d\u043d\u043e\u0435 \u0438\u043c\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", null, null);
            } else {
                while (this.choiceDomain.size() > 0) {
                    this.choiceDomain.delete(0);
                }
                for (int i = domains.length - 1; i >= 0; --i) {
                    this.choiceDomain.append(domains[i], null);
                }
            }
        } else if (nextDisplayable.equals(this.getManageDomainsForm())) {
            domains = this.prefs.getDomainList();
            if (domains.length == 0) {
                nextDisplayable = this.mainForm;
                alert = new Alert("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0435 \u0438\u043c\u044f", "\u0414\u043e\u043c\u0435\u043d\u043d\u043e\u0435 \u0438\u043c\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", null, null);
            } else {
                this.refreshManageDomainsForm(domains);
            }
        }
        if ((__currentDisplayable = (display = this.getDisplay()).getCurrent()) != null && nextDisplayable != null) {
            this.__previousDisplayables.put(nextDisplayable, __currentDisplayable);
        }
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.aboutForm) {
            if (command == this.okCommand1) {
                this.switchToPreviousDisplayable();
            }
        } else if (displayable == this.chooseDomainForm) {
            if (command == this.cancelChooseDomainCommand) {
                this.switchDisplayable(null, (Displayable)this.getMainForm());
            } else if (command == this.okChooseDomainCommand) {
                this.selectDomain();
                this.switchDisplayable(null, (Displayable)this.getMainForm());
            }
        } else if (displayable == this.mainForm) {
            if (command == this.aboutCommand) {
                this.switchDisplayable(null, (Displayable)this.getAboutForm());
            } else if (command == this.chooseDomainCommand) {
                this.switchDisplayable(null, (Displayable)this.getChooseDomainForm());
            } else if (command == this.exitCommand) {
                this.exitMIDlet();
            } else if (command == this.generateCommand) {
                this.generate();
            } else if (command == this.manageDomainsCommand) {
                this.switchDisplayable(null, (Displayable)this.getManageDomainsForm());
            } else if (command == this.preferencesCommand) {
                this.switchDisplayable(null, (Displayable)this.getPreferencesForm());
            }
        } else if (displayable == this.manageDomainsForm) {
            if (command == this.backCommand) {
                this.switchToPreviousDisplayable();
            } else if (command == this.deleteCommand) {
                this.deleteDomains();
            } else if (command == this.selectAllCommand) {
                this.selectAllDomains();
            } else if (command == this.selectNoneCommand) {
                this.selectNoDomains();
            }
        } else if (displayable == this.preferencesForm) {
            if (command == this.cancelCommand) {
                this.switchToPreviousDisplayable();
            } else if (command == this.okCommand) {
                this.savePreferences();
                this.switchDisplayable(null, (Displayable)this.getMainForm());
            }
        }
    }

    public Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 5);
        }
        return this.exitCommand;
    }

    public Form getMainForm() {
        if (this.mainForm == null) {
            this.mainForm = new Form("\u0413\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440 \u043f\u0430\u0440\u043e\u043b\u0435\u0439", new Item[]{this.getPasswordField(), this.getDomainField(), this.getGeneratedPassword()});
            this.mainForm.addCommand(this.getGenerateCommand());
            this.mainForm.addCommand(this.getChooseDomainCommand());
            this.mainForm.addCommand(this.getManageDomainsCommand());
            this.mainForm.addCommand(this.getPreferencesCommand());
            this.mainForm.addCommand(this.getAboutCommand());
            this.mainForm.addCommand(this.getExitCommand());
            this.mainForm.setCommandListener((CommandListener)this);
        }
        return this.mainForm;
    }

    public Command getGenerateCommand() {
        if (this.generateCommand == null) {
            this.generateCommand = new Command("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f", 1, 0);
        }
        return this.generateCommand;
    }

    public TextField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new TextField("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c:", null, 32, 65536);
        }
        return this.passwordField;
    }

    public StringItem getGeneratedPassword() {
        if (this.generatedPassword == null) {
            this.generatedPassword = new StringItem("\u041f\u0430\u0440\u043e\u043b\u044c:", null);
        }
        return this.generatedPassword;
    }

    public Command getPreferencesCommand() {
        if (this.preferencesCommand == null) {
            this.preferencesCommand = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 1, 3);
        }
        return this.preferencesCommand;
    }

    public Command getOkCommand() {
        if (this.okCommand == null) {
            this.okCommand = new Command("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c", 4, 0);
        }
        return this.okCommand;
    }

    public Command getCancelCommand() {
        if (this.cancelCommand == null) {
            this.cancelCommand = new Command("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e", 3, 1);
        }
        return this.cancelCommand;
    }

    public Form getPreferencesForm() {
        if (this.preferencesForm == null) {
            this.preferencesForm = new Form("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430", new Item[]{this.getChoiceHashFunction(), this.getChoicePresentation(), this.getLengthField(), this.getChoiceStoreDomains()});
            this.preferencesForm.addCommand(this.getOkCommand());
            this.preferencesForm.addCommand(this.getCancelCommand());
            this.preferencesForm.setCommandListener((CommandListener)this);
            switch (this.prefs.getHashFunction()) {
                case 0: {
                    this.choiceHashFunction.setSelectedIndex(0, true);
                    break;
                }
                case 1: {
                    this.choiceHashFunction.setSelectedIndex(1, true);
                }
            }
            switch (this.prefs.getDisplayMode()) {
                case 0: {
                    this.choicePresentation.setSelectedIndex(0, true);
                    break;
                }
                case 1: {
                    this.choicePresentation.setSelectedIndex(1, true);
                    break;
                }
                case 2: {
                    this.choicePresentation.setSelectedIndex(2, true);
                    break;
                }
                case 3: {
                    this.choicePresentation.setSelectedIndex(3, true);
                }
            }
            this.lengthField.setString(new Byte(this.prefs.getLength()).toString());
            boolean[] storeDomainsSelections = new boolean[this.choiceStoreDomains.size()];
            if (storeDomainsSelections.length > 0) {
                storeDomainsSelections[0] = this.prefs.getStoreDomains();
                this.choiceStoreDomains.setSelectedFlags(storeDomainsSelections);
            }
        }
        return this.preferencesForm;
    }

    public ChoiceGroup getChoiceHashFunction() {
        if (this.choiceHashFunction == null) {
            this.choiceHashFunction = new ChoiceGroup("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430", 1);
            this.choiceHashFunction.append("MD5", null);
            this.choiceHashFunction.append("SHA1", null);
            this.choiceHashFunction.setSelectedFlags(new boolean[]{false, true});
        }
        return this.choiceHashFunction;
    }

    public ChoiceGroup getChoicePresentation() {
        if (this.choicePresentation == null) {
            this.choicePresentation = new ChoiceGroup("\u0422\u0438\u043f", 1);
            this.choicePresentation.append("Lower-case hex", null);
            this.choicePresentation.append("Upper-case hex", null);
            this.choicePresentation.append("BASE64", null);
            this.choicePresentation.append("BASE64 (\u0431\u0435\u0437 \u0441\u0443\u0444\u0444\u0438\u043a\u0441\u0430)", null);
            this.choicePresentation.setSelectedFlags(new boolean[]{false, false, true, false});
        }
        return this.choicePresentation;
    }

    public TextField getLengthField() {
        if (this.lengthField == null) {
            this.lengthField = new TextField("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 8)", "8", 2, 2);
        }
        return this.lengthField;
    }

    public Command getChooseDomainCommand() {
        if (this.chooseDomainCommand == null) {
            this.chooseDomainCommand = new Command("\u0414\u043e\u043c\u0435\u043d\u043d\u043e\u0435 \u0418\u043c\u044f", 1, 1);
        }
        return this.chooseDomainCommand;
    }

    public TextField getDomainField() {
        if (this.domainField == null) {
            this.domainField = new TextField("\u0418\u043c\u044f \u0434\u043e\u043c\u0435\u043d\u0430:", null, 32, 0);
        }
        return this.domainField;
    }

    public Command getOkChooseDomainCommand() {
        if (this.okChooseDomainCommand == null) {
            this.okChooseDomainCommand = new Command("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c", 4, 0);
        }
        return this.okChooseDomainCommand;
    }

    public Command getCancelChooseDomainCommand() {
        if (this.cancelChooseDomainCommand == null) {
            this.cancelChooseDomainCommand = new Command("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e", 3, 1);
        }
        return this.cancelChooseDomainCommand;
    }

    public Form getChooseDomainForm() {
        if (this.chooseDomainForm == null) {
            this.chooseDomainForm = new Form("\u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438:", new Item[]{this.getChoiceDomain()});
            this.chooseDomainForm.addCommand(this.getOkChooseDomainCommand());
            this.chooseDomainForm.addCommand(this.getCancelChooseDomainCommand());
            this.chooseDomainForm.setCommandListener((CommandListener)this);
        }
        return this.chooseDomainForm;
    }

    public ChoiceGroup getChoiceDomain() {
        if (this.choiceDomain == null) {
            this.choiceDomain = new ChoiceGroup("", 1);
        }
        return this.choiceDomain;
    }

    public Command getAboutCommand() {
        if (this.aboutCommand == null) {
            this.aboutCommand = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 1, 4);
        }
        return this.aboutCommand;
    }

    public Command getManageDomainsCommand() {
        if (this.manageDomainsCommand == null) {
            this.manageDomainsCommand = new Command("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u043c\u0435\u043d\u043d\u044b\u043c\u0438 \u0438\u043c\u0435\u043d\u0430\u043c\u0438", 1, 2);
        }
        return this.manageDomainsCommand;
    }

    public Command getBackCommand() {
        if (this.backCommand == null) {
            this.backCommand = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        }
        return this.backCommand;
    }

    public Command getDeleteCommand() {
        if (this.deleteCommand == null) {
            this.deleteCommand = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 1, 0);
        }
        return this.deleteCommand;
    }

    public Command getSelectAllCommand() {
        if (this.selectAllCommand == null) {
            this.selectAllCommand = new Command("\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435", 1, 0);
        }
        return this.selectAllCommand;
    }

    public Command getSelectNoneCommand() {
        if (this.selectNoneCommand == null) {
            this.selectNoneCommand = new Command("\u0421\u043d\u044f\u0442\u044c", 1, 0);
        }
        return this.selectNoneCommand;
    }

    public Form getManageDomainsForm() {
        if (this.manageDomainsForm == null) {
            this.manageDomainsForm = new Form("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u043c\u0435\u043d\u043d\u044b\u043c\u0438 \u0438\u043c\u0435\u043d\u0430\u043c\u0438", new Item[]{this.getManageDomainsChoiceGroup()});
            this.manageDomainsForm.addCommand(this.getBackCommand());
            this.manageDomainsForm.addCommand(this.getDeleteCommand());
            this.manageDomainsForm.addCommand(this.getSelectAllCommand());
            this.manageDomainsForm.addCommand(this.getSelectNoneCommand());
            this.manageDomainsForm.setCommandListener((CommandListener)this);
        }
        return this.manageDomainsForm;
    }

    public ChoiceGroup getManageDomainsChoiceGroup() {
        if (this.manageDomainsChoiceGroup == null) {
            this.manageDomainsChoiceGroup = new ChoiceGroup("", 2);
        }
        return this.manageDomainsChoiceGroup;
    }

    public Command getOkCommand1() {
        if (this.okCommand1 == null) {
            this.okCommand1 = new Command("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c", 4, 0);
        }
        return this.okCommand1;
    }

    public Form getAboutForm() {
        if (this.aboutForm == null) {
            this.aboutForm = new Form("HPGen", new Item[]{this.getStringItem1()});
            this.aboutForm.addCommand(this.getOkCommand1());
            this.aboutForm.setCommandListener((CommandListener)this);
        }
        return this.aboutForm;
    }

    public StringItem getStringItem1() {
        if (this.stringItem1 == null) {
            this.stringItem1 = new StringItem(null, "HPGen \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440 \u043f\u0430\u0440\u043e\u043b\u0435\u0439\n\u0412\u0435\u0440\u0441\u0438\u044f v1.0.6\n\n\u041f\u0435\u0440\u0435\u0432\u043e\u0434: [M.A.X]\n\n\u2192\n(c) S Jolly 2009. Released under the GPL v2.  Uses Tim Macinta's MD5 implementation and Sam Ruby's SHA1 implementation.  Hash password concept by Nic Wolff.\n\u0421\u0430\u0439\u0442 http://elvum.net/hpgen");
        }
        return this.stringItem1;
    }

    public ChoiceGroup getChoiceStoreDomains() {
        if (this.choiceStoreDomains == null) {
            this.choiceStoreDomains = new ChoiceGroup("", 2);
            this.choiceStoreDomains.append("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0435 \u0438\u043c\u044f?", null);
            this.choiceStoreDomains.setSelectedFlags(new boolean[]{true});
        }
        return this.choiceStoreDomains;
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            this.initialize();
            this.startMIDlet();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }

    public void generate() {
        String generated;
        byte[] hash;
        String concat = this.passwordField.getString() + ":" + this.domainField.getString();
        switch (this.prefs.getHashFunction()) {
            case 0: {
                this.md5.Init();
                try {
                    this.md5.Update(concat, "US-ASCII");
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                    this.generatedPassword.setText("Internal error.");
                }
                hash = this.md5.Final();
                break;
            }
            default: {
                hash = SHA1.encode(concat);
            }
        }
        switch (this.prefs.getDisplayMode()) {
            case 0: {
                generated = MD5.asHex(hash).substring(0, this.prefs.getLength());
                break;
            }
            case 1: {
                generated = MD5.asHex(hash).toUpperCase().substring(0, this.prefs.getLength());
                break;
            }
            case 3: {
                generated = Conversions.toBase64(hash).substring(0, this.prefs.getLength());
                break;
            }
            default: {
                generated = Conversions.toBase64(hash).substring(0, this.prefs.getLength()) + "1a";
            }
        }
        this.generatedPassword.setText(generated);
        if (this.prefs.getStoreDomains()) {
            try {
                this.prefs.exclusiveAddDomain(this.domainField.getString());
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void savePreferences() {
        switch (this.choiceHashFunction.getSelectedIndex()) {
            case 0: {
                this.prefs.setHashFunction((byte)0);
                break;
            }
            case 1: {
                this.prefs.setHashFunction((byte)1);
            }
        }
        switch (this.choicePresentation.getSelectedIndex()) {
            case 0: {
                this.prefs.setDisplayMode((byte)0);
                break;
            }
            case 1: {
                this.prefs.setDisplayMode((byte)1);
                break;
            }
            case 2: {
                this.prefs.setDisplayMode((byte)2);
                break;
            }
            case 3: {
                this.prefs.setDisplayMode((byte)3);
            }
        }
        byte length = this.prefs.getLength();
        try {
            length = Byte.parseByte(this.lengthField.getString());
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        if (length <= 0) {
            length = 8;
            this.lengthField.setString("8");
        }
        this.prefs.setLength(length);
        boolean[] storeDomainsSelections = new boolean[this.choiceStoreDomains.size()];
        if (storeDomainsSelections.length > 0) {
            this.choiceStoreDomains.getSelectedFlags(storeDomainsSelections);
            this.prefs.setStoreDomains(storeDomainsSelections[0]);
        }
    }

    public void selectDomain() {
        int selectedDomain = this.choiceDomain.getSelectedIndex();
        if (selectedDomain != -1) {
            String domainString = this.choiceDomain.getString(selectedDomain);
            this.domainField.setString(domainString);
            this.generatedPassword.setText("");
            try {
                this.prefs.exclusiveAddDomain(domainString);
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }
}

