/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import multime.FakeDisplay;
import multime.MultiME;
import multime.misc.PublicKeys;
import org.netbeans.microedition.lcdui.laf.ColorSchema;
import org.netbeans.microedition.lcdui.laf.SystemColorSchema;

public abstract class AbstractInfoScreen
extends Canvas
implements PublicKeys {
    private FakeDisplay display;
    private Image image;
    private String text;
    private static Font DEFAULT_TEXT_FONT;
    private Font textFont = DEFAULT_TEXT_FONT;
    private Displayable nextDisplayable;
    private Alert nextAlert;
    private Displayable previousDisplayable;
    private CommandListener commandListener;
    private ColorSchema colorSchema;

    public AbstractInfoScreen(FakeDisplay display) throws IllegalArgumentException {
        this(display, null);
    }

    public AbstractInfoScreen(FakeDisplay display, ColorSchema colorSchema) {
        if (display == null) {
            throw new IllegalArgumentException("Display parameter cannot be null.");
        }
        this.display = display;
        this.setColorSchemaImpl(display, colorSchema);
    }

    public ColorSchema getColorSchema() {
        return this.colorSchema;
    }

    public void setColorSchema(ColorSchema colorSchema) {
        this.setColorSchemaImpl(this.getDisplay(), colorSchema);
        this.repaint();
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setTextFont(Font font) {
        this.textFont = font != null ? font : DEFAULT_TEXT_FONT;
        this.repaint();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    protected final CommandListener getCommandListener() {
        return this.commandListener;
    }

    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        this.commandListener = commandListener;
    }

    public void setNextDisplayable(Displayable nextDisplayable) {
        this.nextDisplayable = nextDisplayable;
    }

    public void setNextDisplayable(Alert nextAlert, Displayable nextDisplayable) throws IllegalArgumentException {
        if (nextAlert != null && nextDisplayable == null) {
            throw new IllegalArgumentException("A nextDisplayable parameter cannot be null if the nextAlert parameter is not null.");
        }
        if (nextDisplayable instanceof Alert) {
            throw new IllegalArgumentException("nextDisplayable paremter cannot be Alert.");
        }
        this.nextAlert = nextAlert;
        this.nextDisplayable = nextDisplayable;
    }

    protected void paint(Graphics g2) {
        this.getColorSchema().paintBackground(g2, true);
        g2.setColor(this.getColorSchema().getColor(1));
        g2.setFont(this.getTextFont());
        int centerX = g2.getClipWidth() / 2 + g2.getClipX();
        int centerY = g2.getClipHeight() / 2 + g2.getClipY();
        if (this.image != null) {
            g2.drawImage(this.image, centerX, centerY, 3);
        }
        if (this.image == null && this.text != null) {
            g2.drawString(this.text, centerX, centerY, 65);
        } else if (this.image != null && this.text != null) {
            int textPositionY = centerY + this.image.getHeight() + 5;
            if (textPositionY > g2.getClipHeight()) {
                textPositionY = g2.getClipHeight() - 5;
            }
            g2.drawString(this.text, centerX, textPositionY, 65);
        }
    }

    protected void sizeChanged(int w, int h2) {
        this.repaint();
    }

    protected FakeDisplay getDisplay() {
        return this.display;
    }

    protected Displayable getNextDisplayable() {
        return this.nextDisplayable;
    }

    protected Alert getNextAlert() {
        return this.nextAlert;
    }

    protected void switchToNextDisplayable() {
        if (this.nextDisplayable != null) {
            AbstractInfoScreen.switchToDisplayable(this.display, this.nextAlert, this.nextDisplayable);
        } else if (this.previousDisplayable != null) {
            this.display.setCurrent(this.previousDisplayable);
        }
    }

    protected static void switchToDisplayable(FakeDisplay display, Alert alert, Displayable displayable) {
        if (displayable != null) {
            if (alert != null) {
                display.setCurrent(alert, displayable);
            } else {
                display.setCurrent(displayable);
            }
        }
    }

    protected void showNotify() {
        this.previousDisplayable = this.getDisplay().getCurrent();
        super.showNotify();
    }

    private void setColorSchemaImpl(FakeDisplay display, ColorSchema colorSchema) {
        this.colorSchema = colorSchema != null ? colorSchema : SystemColorSchema.getForDisplay(display);
    }

    static {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.AbstractInfoScreen");
        DEFAULT_TEXT_FONT = Font.getFont((int)0);
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.AbstractInfoScreen");
        DEFAULT_TEXT_FONT = Font.getFont((int)0);
    }

    public void keyPressed(int keyCode) {
        MultiME.globalKeyPressed(this, keyCode);
    }

    public void __keyPressed(int k2) {
    }

    public void keyRepeated(int keyCode) {
        MultiME.globalKeyRepeated(this, keyCode);
    }

    public void __keyRepeated(int k2) {
    }

    public void keyReleased(int keyCode) {
        MultiME.globalKeyReleased(this, keyCode);
    }

    public void __keyReleased(int k2) {
    }

    public static void staticSuperCleaningRoutine() {
        DEFAULT_TEXT_FONT = null;
    }
}

