/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import multime.FakeDisplay;
import multime.MultiME;
import multime.misc.PublicKeys;
import org.netbeans.microedition.lcdui.AbstractInfoScreen;

public class SplashScreen
extends AbstractInfoScreen
implements PublicKeys {
    public static final Command DISMISS_COMMAND;
    public static final int FOREVER = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private int timeout = 5000;
    private boolean allowTimeoutInterrupt = true;
    private long currentDisplayTimestamp;

    public SplashScreen(FakeDisplay display) throws IllegalArgumentException {
        super(display);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAllowTimeoutInterrupt(boolean allow) {
        this.allowTimeoutInterrupt = allow;
    }

    public boolean isAllowTimeoutInterrupt() {
        return this.allowTimeoutInterrupt;
    }

    public void keyPressed(int keyCode) {
        MultiME.globalKeyPressed(this, keyCode);
    }

    protected void pointerPressed(int x, int y) {
        if (this.allowTimeoutInterrupt) {
            this.doDismiss();
        }
    }

    protected void showNotify() {
        super.showNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
        if (this.timeout > 0) {
            Watchdog w = new Watchdog(this.timeout, this.currentDisplayTimestamp);
            w.start();
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
    }

    private void doDismiss() {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener == null) {
            this.switchToNextDisplayable();
        } else {
            commandListener.commandAction(DISMISS_COMMAND, (Displayable)this);
        }
    }

    static {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.SplashScreen");
        DISMISS_COMMAND = new Command("Dismiss", 4, 0);
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.SplashScreen");
        DISMISS_COMMAND = new Command("Dismiss", 4, 0);
    }

    public void __keyPressed(int keyCode) {
        if (this.allowTimeoutInterrupt) {
            this.doDismiss();
        }
    }

    public void keyRepeated(int keyCode) {
        MultiME.globalKeyRepeated(this, keyCode);
    }

    public void __keyRepeated(int k2) {
        super.__keyRepeated(k2);
    }

    public void keyReleased(int keyCode) {
        MultiME.globalKeyReleased(this, keyCode);
    }

    public void __keyReleased(int k2) {
        super.__keyReleased(k2);
    }

    public static void staticSuperCleaningRoutine() {
    }

    private class Watchdog
    extends Thread {
        private int timeout;
        private long currentDisplayTimestamp;

        private Watchdog(int timeout, long currentDisplayTimestamp) {
            this.timeout = timeout;
            this.currentDisplayTimestamp = currentDisplayTimestamp;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.currentDisplayTimestamp == SplashScreen.this.currentDisplayTimestamp) {
                SplashScreen.this.doDismiss();
            }
        }

        static {
            MultiME.classLoaded("org.netbeans.microedition.lcdui.SplashScreen$Watchdog");
        }

        public static void staticClinitSuperClone() {
            MultiME.classLoaded("org.netbeans.microedition.lcdui.SplashScreen$Watchdog");
        }

        public static void staticSuperCleaningRoutine() {
        }
    }
}

