/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;
import multime.FakeDisplay;
import multime.MultiME;
import multime.misc.PublicKeys;
import org.netbeans.microedition.svg.SVGAnimatorWrapper;

public class SVGSplashScreen
extends SVGAnimatorWrapper
implements PublicKeys {
    public static final Command DISMISS_COMMAND;
    public static final int FOREVER = 0;
    private int timeout = 5000;
    private boolean allowTimeoutInterrupt = true;
    private static long currentDisplayTimestamp;

    public SVGSplashScreen(SVGImage svgImage, FakeDisplay display) throws IllegalArgumentException {
        super(svgImage, display);
        this.setFullScreenMode(true);
        this.setSVGEventListener(new SplashScreenSvgEventListener());
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAllowTimeoutInterrupt(boolean allow) {
        this.allowTimeoutInterrupt = allow;
    }

    public boolean isAllowTimeoutInterrupt() {
        return this.allowTimeoutInterrupt;
    }

    private void doDismiss() {
        CommandListener cl = this.getCommandListener();
        if (cl != null) {
            cl.commandAction(DISMISS_COMMAND, (Displayable)this);
        }
    }

    static {
        MultiME.classLoaded("org.netbeans.microedition.svg.SVGSplashScreen");
        DISMISS_COMMAND = new Command("Dismiss", 4, 0);
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("org.netbeans.microedition.svg.SVGSplashScreen");
        DISMISS_COMMAND = new Command("Dismiss", 4, 0);
    }

    public void keyPressed(int keyCode) {
        MultiME.globalKeyPressed(this, keyCode);
    }

    public void __keyPressed(int k2) {
        super.__keyPressed(k2);
    }

    public void keyRepeated(int keyCode) {
        MultiME.globalKeyRepeated(this, keyCode);
    }

    public void __keyRepeated(int k2) {
        super.__keyRepeated(k2);
    }

    public void keyReleased(int keyCode) {
        MultiME.globalKeyReleased(this, keyCode);
    }

    public void __keyReleased(int k2) {
        super.__keyReleased(k2);
    }

    public static void staticSuperCleaningRoutine() {
        currentDisplayTimestamp = 0L;
    }

    private class SplashScreenSvgEventListener
    implements SVGEventListener {
        private SplashScreenSvgEventListener() {
        }

        public void keyPressed(int i2) {
            if (SVGSplashScreen.this.allowTimeoutInterrupt) {
                SVGSplashScreen.this.doDismiss();
            }
        }

        public void keyReleased(int i2) {
        }

        public void pointerPressed(int i2, int i0) {
            if (SVGSplashScreen.this.allowTimeoutInterrupt) {
                SVGSplashScreen.this.doDismiss();
            }
        }

        public void pointerReleased(int i2, int i0) {
        }

        public void hideNotify() {
            currentDisplayTimestamp = System.currentTimeMillis();
        }

        public void showNotify() {
            currentDisplayTimestamp = System.currentTimeMillis();
            if (SVGSplashScreen.this.timeout > 0) {
                Watchdog w = new Watchdog(SVGSplashScreen.this.timeout, currentDisplayTimestamp);
                w.start();
            }
        }

        public void sizeChanged(int i2, int i0) {
        }

        static {
            MultiME.classLoaded("org.netbeans.microedition.svg.SVGSplashScreen$SplashScreenSvgEventListener");
        }

        public static void staticClinitSuperClone() {
            MultiME.classLoaded("org.netbeans.microedition.svg.SVGSplashScreen$SplashScreenSvgEventListener");
        }

        public static void staticSuperCleaningRoutine() {
        }
    }

    private class Watchdog
    extends Thread {
        private int timeout;
        private long currentDisplayTimestamp;

        private Watchdog(int timeout, long currentDisplayTimestamp) {
            this.timeout = timeout;
            this.currentDisplayTimestamp = currentDisplayTimestamp;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Watchdog watchdog = this;
            if (this.currentDisplayTimestamp == currentDisplayTimestamp) {
                SVGSplashScreen.this.doDismiss();
            }
        }

        static {
            MultiME.classLoaded("org.netbeans.microedition.svg.SVGSplashScreen$Watchdog");
        }

        public static void staticClinitSuperClone() {
            MultiME.classLoaded("org.netbeans.microedition.svg.SVGSplashScreen$Watchdog");
        }

        public static void staticSuperCleaningRoutine() {
        }
    }
}

