/*
 * Decompiled with CFR 0.152.
 */
package sudokusolver;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import sudokusolver.MainCanvas;

class Cell {
    public static final byte CELL_TYPE_UNKNOWN = 0;
    public static final byte CELL_TYPE_ENTERED = 1;
    public static final byte CELL_TYPE_DETERMINED = 2;
    public static final byte CELL_TYPE_SOLVED = 3;
    public static final byte CELL_TYPE_SOLVING = 4;
    public static Font cellFont = null;
    public static int fontMargin = 3;
    public byte type = 0;
    public short x;
    public short y;
    public static short size;
    public int originalBackgroundColor1;
    int currentBackgroundColor1;
    public int originalBackgroundColor2;
    public int currentBackgroundColor2;
    public int originalForegroundColor;
    public int currentForegroundColor;
    public Vector possibleValues = null;
    public int currentPossibleValueIndex = 0;
    public byte value;
    public byte index;
    public MainCanvas owner = null;

    public Cell(byte by, MainCanvas mainCanvas, int n, int n2) {
        this.index = by;
        this.owner = mainCanvas;
        this.initialize();
    }

    private static void findLargestPossibleFontSize() {
        Font[] fontArray = new Font[]{Font.getFont((int)64, (int)2, (int)16), Font.getFont((int)64, (int)2, (int)0), Font.getFont((int)64, (int)2, (int)8)};
        int n = size - fontMargin;
        for (int i = 0; i < fontArray.length; ++i) {
            if (fontArray[i].getBaselinePosition() > n) continue;
            cellFont = fontArray[i];
            break;
        }
    }

    public static short getSize() {
        return size;
    }

    public static void setSize(short s) {
        size = s;
        Cell.findLargestPossibleFontSize();
    }

    void initialize() {
        this.value = 0;
        this.possibleValues = new Vector();
        for (byte by = 1; by <= 9; by = (byte)(by + 1)) {
            this.possibleValues.addElement(new Byte(by));
        }
        this.currentBackgroundColor1 = this.originalBackgroundColor1;
        this.currentForegroundColor = this.originalForegroundColor;
        this.type = 0;
    }

    public void paintBackground(Graphics graphics) {
        graphics.setColor(this.currentBackgroundColor1);
        graphics.fillRect((int)this.x, (int)this.y, (int)size, size / 2);
        graphics.setColor(this.currentBackgroundColor2);
        graphics.fillRect((int)this.x, this.y + size / 2, (int)size, size - size / 2);
    }

    public void paintForeground(Graphics graphics) {
        if (this.value > 0) {
            int n = size / 2;
            int n2 = (size - cellFont.getBaselinePosition()) / 2;
            graphics.setFont(cellFont);
            graphics.setColor(this.currentForegroundColor);
            graphics.drawString(String.valueOf(this.value), this.x + n, this.y + n2, 17);
        }
    }

    public void paint(Graphics graphics, boolean bl) {
        short s = this.x;
        short s2 = this.y;
        this.paintBackground(graphics);
        if (bl) {
            this.paintForeground(graphics);
        }
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public Vector getPossibleValues() {
        return this.possibleValues;
    }

    public int getPossibleValuesSize() {
        return this.possibleValues.size();
    }

    public void addPossibleValue(byte by) {
        this.possibleValues.addElement(new Byte(by));
    }

    public void calculatePossibleValues() {
        this.possibleValues.removeAllElements();
        if (this.value == 0) {
            for (byte by = 1; by <= 9; by = (byte)(by + 1)) {
                if (!this.owner.isAValidNumber(this.owner.getCellRowIndex(this.index), this.owner.getCellColumnIndex(this.index), by)) continue;
                this.addPossibleValue(by);
            }
        } else {
            this.addPossibleValue(this.value);
        }
    }

    public void removePossibleValue(byte by) {
        int n = this.possibleValues.size();
        for (int i = 0; i < n; ++i) {
            if ((Byte)this.possibleValues.elementAt(i) != by) continue;
            this.possibleValues.removeElementAt(i);
            return;
        }
    }

    public void setPossibleValues(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.addPossibleValue(byArray[i]);
        }
    }

    public void setPossibleValue(byte by) {
        this.possibleValues.removeAllElements();
        this.addPossibleValue(by);
    }
}

