/*
 * Decompiled with CFR 0.152.
 */
package sudokusolver;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import sudokusolver.SSCanvas;

class Cell {
    static final byte CELL_TYPE_UNKNOWN = 0;
    static final byte CELL_TYPE_ENTERED = 1;
    static final byte CELL_TYPE_DETERMINED = 2;
    static final byte CELL_TYPE_SOLVED = 3;
    static final Font cellFont = Font.getFont((int)0, (int)2, (int)8);
    byte type = 0;
    short x;
    short y;
    static short size;
    int originalBackgroundColor1;
    int currentBackgroundColor1;
    int originalBackgroundColor2;
    int currentBackgroundColor2;
    int originalForegroundColor;
    int currentForegroundColor;
    byte value;
    Vector possibleValues = null;
    byte index;
    SSCanvas owner = null;

    public Cell(byte index, SSCanvas owner, int growSize, int arcSize) {
        this.index = index;
        this.owner = owner;
        this.initialize();
    }

    void initialize() {
        this.value = 0;
        this.possibleValues = new Vector();
        for (byte i = 1; i <= 9; i = (byte)(i + 1)) {
            this.possibleValues.addElement(new Byte(i));
        }
        this.currentBackgroundColor1 = this.originalBackgroundColor1;
        this.currentForegroundColor = this.originalForegroundColor;
        this.type = 0;
    }

    public void paintBackground(Graphics g, int newSize, int arcSize) {
        g.setColor(this.currentBackgroundColor1);
        g.fillRect((int)this.x, (int)this.y, newSize, newSize / 2);
        g.setColor(this.currentBackgroundColor2);
        g.fillRect((int)this.x, this.y + newSize / 2, newSize, size - newSize / 2);
    }

    public void paintForeground(Graphics g) {
        if (this.value > 0) {
            int valueXPosInCell = size / 2;
            int valueYPosInCell = (size - cellFont.getBaselinePosition()) / 2;
            g.setFont(cellFont);
            g.setColor(this.currentForegroundColor);
            g.drawString(String.valueOf(this.value), this.x + valueXPosInCell, this.y + valueYPosInCell, 17);
        }
    }

    public void paint(Graphics g, int growSize, int arcSize) {
        int x = this.x - growSize / 2;
        int y = this.y - growSize / 2;
        int newSize = size + growSize;
        this.paintBackground(g, newSize, arcSize);
        this.paintForeground(g);
    }

    public boolean isShowSolvingProgress() {
        return this.owner.isShowSolvingProgress();
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    public Vector getPossibleValues() {
        return this.possibleValues;
    }

    public int getPossibleValuesSize() {
        return this.possibleValues.size();
    }

    public void addPossibleValue(byte value) {
        this.possibleValues.addElement(new Byte(value));
    }

    public void calculatePossibleValues() {
        this.possibleValues.removeAllElements();
        if (this.value == 0) {
            for (byte k = 1; k <= 9; k = (byte)(k + 1)) {
                if (!this.owner.isAValidNumber(this.owner.getCellRowIndex(this.index), this.owner.getCellColumnIndex(this.index), k)) continue;
                this.addPossibleValue(k);
            }
        } else {
            this.addPossibleValue(this.value);
        }
    }

    public void removePossibleValue(byte value) {
        int len = this.possibleValues.size();
        for (int i = 0; i < len; ++i) {
            if ((Byte)this.possibleValues.elementAt(i) != value) continue;
            this.possibleValues.removeElementAt(i);
            return;
        }
    }

    public void setPossibleValues(byte[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addPossibleValue(values[i]);
        }
    }

    public void setPossibleValue(byte value) {
        this.possibleValues.removeAllElements();
        this.addPossibleValue(value);
    }
}

