/*
 * Decompiled with CFR 0.152.
 */
package hideme;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class HideMeBrowser
extends List
implements CommandListener {
    private static final String ROOT = "/";
    private static final char SEPARATOR = '/';
    private static final String FOLDER_UP = "../";
    private Image dirIcon = null;
    private Image fileIcon = null;
    public static final Command SELECT_FILE_COMMAND = new Command("\u0412\u044b\u0431\u043e\u0440", 4, 1);
    public static final Command SELECT_FOLDER_COMMAND = new Command("\u041f\u0430\u043f\u043a\u0430", 4, 2);
    private final Vector path = new Vector();
    private CommandListener commandListener = null;

    public HideMeBrowser() {
        super("", 3);
        super.setCommandListener((CommandListener)this);
        this.setSelectCommand(SELECT_FILE_COMMAND);
        try {
            this.dirIcon = Image.createImage((String)"/org/netbeans/microedition/resources/dir.png");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fileIcon = Image.createImage((String)"/org/netbeans/microedition/resources/file.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fillList();
    }

    public String getCurrentFolder() {
        String ret = ROOT;
        for (int i = 0; i < this.path.size(); ++i) {
            ret = ret + this.path.elementAt(i);
        }
        return ret;
    }

    public String getCurrentFile() {
        return this.getString(this.getSelectedIndex());
    }

    private void fillList() {
        new Thread(new Runnable(){

            public void run() {
                String folder = HideMeBrowser.this.getCurrentFolder();
                if (folder.equals(HideMeBrowser.ROOT)) {
                    HideMeBrowser.this.removeCommand(SELECT_FOLDER_COMMAND);
                } else {
                    HideMeBrowser.this.addCommand(SELECT_FOLDER_COMMAND);
                }
                HideMeBrowser.this.setTitle(folder);
                HideMeBrowser.this.deleteAll();
                Enumeration e = null;
                FileConnection currDir = null;
                try {
                    if (folder.equals(HideMeBrowser.ROOT)) {
                        e = FileSystemRegistry.listRoots();
                    } else {
                        HideMeBrowser.this.append(HideMeBrowser.FOLDER_UP, HideMeBrowser.this.dirIcon);
                        currDir = (FileConnection)Connector.open((String)("file://" + folder));
                        e = currDir.list();
                    }
                    while (e.hasMoreElements()) {
                        String fileName = (String)e.nextElement();
                        if (HideMeBrowser.this.isFolder(fileName)) {
                            HideMeBrowser.this.append(fileName, HideMeBrowser.this.dirIcon);
                            continue;
                        }
                        HideMeBrowser.this.append(fileName, HideMeBrowser.this.fileIcon);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                finally {
                    if (currDir != null) {
                        try {
                            currDir.close();
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex.getMessage());
                        }
                    }
                }
            }
        }).start();
    }

    private boolean isFolder(String name) {
        return name.charAt(name.length() - 1) == '/';
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public CommandListener getCommandListener() {
        return this.commandListener;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == SELECT_FILE_COMMAND) {
            String selection = this.getString(this.getSelectedIndex());
            if (FOLDER_UP.equals(selection)) {
                this.path.removeElementAt(this.path.size() - 1);
                this.fillList();
            } else if (this.isFolder(selection)) {
                this.path.addElement(selection);
                this.fillList();
            } else {
                this.commandListener.commandAction(c, d);
            }
        } else if (this.commandListener != null) {
            this.commandListener.commandAction(c, d);
            this.fillList();
        }
    }
}

