/*
 * Decompiled with CFR 0.152.
 */
package hideme;

import hideme.FileList;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import org.netbeans.microedition.util.CancellableTask;

public class Hider
implements CancellableTask {
    private final boolean hide;
    private static final String EXT = ".zip";
    private static final int EXTL = ".zip".length();
    private String failureMessage = "";
    private boolean hasFailed = false;
    private boolean cancel = false;

    public Hider(boolean hide) {
        this.hide = hide;
    }

    public void run() {
        try {
            FileList f = new FileList();
            Enumeration e = f.elements();
            if (this.hide) {
                while (e.hasMoreElements() && !this.cancel) {
                    this.hide("file://" + (String)e.nextElement());
                }
            } else {
                while (e.hasMoreElements() && !this.cancel) {
                    this.unhide("file://" + (String)e.nextElement());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failureMessage = e.getMessage();
            this.hasFailed = true;
        }
    }

    private void hide(String fileURL) throws Exception {
        Enumeration e = null;
        FileConnection fc = (FileConnection)Connector.open((String)fileURL);
        if (!fc.exists()) {
            fc.close();
            return;
        }
        fc.setHidden(true);
        if (this.isDir(fileURL)) {
            e = fc.list();
        } else {
            fc.rename(fc.getName() + EXT);
        }
        fc.close();
        if (e != null) {
            while (e.hasMoreElements() && !this.cancel) {
                this.hide(fileURL + (String)e.nextElement());
            }
        }
    }

    private void unhide(String fileURL) throws Exception {
        FileConnection fc;
        Enumeration e = null;
        if (!this.isDir(fileURL) && !fileURL.endsWith(EXT)) {
            fileURL = fileURL + EXT;
        }
        if (!(fc = (FileConnection)Connector.open((String)fileURL)).exists()) {
            fc.close();
            return;
        }
        fc.setHidden(false);
        if (this.isDir(fileURL)) {
            e = fc.list("*", true);
        } else {
            fc.rename(fc.getName().substring(0, fc.getName().length() - EXTL));
        }
        fc.close();
        if (e != null) {
            while (e.hasMoreElements() && !this.cancel) {
                this.unhide(fileURL + (String)e.nextElement());
            }
        }
    }

    private boolean isDir(String fileName) {
        return fileName.endsWith("/");
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }
}

