/*
 * Decompiled with CFR 0.152.
 */
package mquest.io;

import com.siemens.mp.io.file.FileConnection;
import com.siemens.mp.io.file.FileSystemRegistry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class File {
    private static int platform = File.getPlatform();
    StreamConnection connection;

    public static Enumeration listRoots() throws IOException {
        switch (platform) {
            case 1: {
                return javax.microedition.io.file.FileSystemRegistry.listRoots();
            }
            case 2: {
                return FileSystemRegistry.listRoots();
            }
            case 3: {
                Vector<String> vector = new Vector<String>();
                vector.addElement("A:/");
                vector.addElement("B:/");
                return vector.elements();
            }
        }
        return new Vector().elements();
    }

    public static Enumeration listDirectory(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists() || !fileConnection.isDirectory()) {
                    return new Vector().elements();
                }
                Enumeration enumeration = fileConnection.list();
                fileConnection.close();
                return enumeration;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists() || !fileConnection.isDirectory()) {
                    return new Vector().elements();
                }
                Enumeration enumeration = fileConnection.list();
                fileConnection.close();
                return enumeration;
            }
            case 3: {
                String[] stringArray = com.siemens.mp.io.File.list((String)string);
                Vector<String> vector = new Vector<String>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.addElement(stringArray[i]);
                }
                return vector.elements();
            }
        }
        return new Vector().elements();
    }

    public static Enumeration listDirectory(String string, String string2, boolean bl) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists() || !fileConnection.isDirectory()) {
                    return new Vector().elements();
                }
                Enumeration enumeration = fileConnection.list(string2, bl);
                fileConnection.close();
                return enumeration;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists() || !fileConnection.isDirectory()) {
                    return new Vector().elements();
                }
                Enumeration enumeration = fileConnection.list(string2, bl);
                fileConnection.close();
                return enumeration;
            }
            case 3: {
                String[] stringArray = com.siemens.mp.io.File.list((String)string);
                Vector<String> vector = new Vector<String>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.addElement(stringArray[i]);
                }
                return vector.elements();
            }
        }
        return new Vector().elements();
    }

    public static void createFile(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (fileConnection.exists()) {
                    return;
                }
                fileConnection.create();
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (fileConnection.exists()) {
                    return;
                }
                fileConnection.create();
                fileConnection.close();
                break;
            }
            case 3: {
                com.siemens.mp.io.File file = new com.siemens.mp.io.File();
                file.close(file.open(string));
            }
        }
    }

    public static void createFolder(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (fileConnection.exists()) {
                    return;
                }
                fileConnection.mkdir();
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (fileConnection.exists()) {
                    return;
                }
                fileConnection.mkdir();
                fileConnection.close();
                break;
            }
            case 3: {
                com.siemens.mp.io.File file = new com.siemens.mp.io.File();
                file.close(file.open(string + (string.endsWith("/") ? "" : "/")));
            }
        }
    }

    public static void delete(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return;
                }
                fileConnection.delete();
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return;
                }
                fileConnection.delete();
                fileConnection.close();
                break;
            }
        }
    }

    public static void truncate(String string, long l) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists() || fileConnection.isDirectory()) {
                    return;
                }
                fileConnection.truncate(l);
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists() || fileConnection.isDirectory()) {
                    return;
                }
                fileConnection.truncate(l);
                fileConnection.close();
                break;
            }
            case 3: {
                com.siemens.mp.io.File file = new com.siemens.mp.io.File();
                int n = file.open(string);
                com.siemens.mp.io.File.truncate((int)n, (int)((int)l));
                file.close(n);
            }
        }
    }

    public static long length(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.isDirectory() ? fileConnection.directorySize(true) : fileConnection.fileSize();
                fileConnection.close();
                return l;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.isDirectory() ? fileConnection.directorySize(true) : fileConnection.fileSize();
                fileConnection.close();
                return l;
            }
            case 3: {
                if (File.isDirectory(string)) {
                    if (!string.endsWith("/")) {
                        string = string + "/";
                    }
                    String[] stringArray = com.siemens.mp.io.File.list((String)string);
                    long l = 0L;
                    for (int i = 0; i < stringArray.length; ++i) {
                        l += File.length(string + stringArray[i]);
                    }
                    return l;
                }
                com.siemens.mp.io.File file = new com.siemens.mp.io.File();
                int n = file.open(string);
                long l = file.length(n);
                file.close(n);
                return l;
            }
        }
        return -1L;
    }

    public static void rename(String string, String string2) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.rename(string2);
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.rename(string2);
                fileConnection.close();
                break;
            }
            case 3: {
                com.siemens.mp.io.File.rename((String)string, (String)(string.substring(0, string.lastIndexOf(47) + 1) + string2));
            }
        }
    }

    public static boolean isExists(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                boolean bl = fileConnection.exists();
                fileConnection.close();
                return bl;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                boolean bl = fileConnection.exists();
                fileConnection.close();
                return bl;
            }
            case 3: {
                return com.siemens.mp.io.File.exists((String)string) == 1;
            }
        }
        return false;
    }

    public static boolean isDirectory(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    throw new IOException();
                }
                boolean bl = fileConnection.isDirectory();
                fileConnection.close();
                return bl;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    throw new IOException();
                }
                boolean bl = fileConnection.isDirectory();
                fileConnection.close();
                return bl;
            }
            case 3: {
                com.siemens.mp.io.File.isDirectory((String)string);
            }
        }
        throw new IOException();
    }

    public static boolean isHidden(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return false;
                }
                boolean bl = fileConnection.isHidden();
                fileConnection.close();
                return bl;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return false;
                }
                boolean bl = fileConnection.isHidden();
                fileConnection.close();
                return bl;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static boolean isReadable(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return false;
                }
                boolean bl = fileConnection.canRead();
                fileConnection.close();
                return bl;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return false;
                }
                boolean bl = fileConnection.canRead();
                fileConnection.close();
                return bl;
            }
            case 3: {
                return com.siemens.mp.io.File.exists((String)string) == 1;
            }
        }
        return false;
    }

    public static boolean isWritable(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return false;
                }
                boolean bl = fileConnection.canWrite();
                fileConnection.close();
                return bl;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return false;
                }
                boolean bl = fileConnection.canWrite();
                fileConnection.close();
                return bl;
            }
            case 3: {
                return com.siemens.mp.io.File.exists((String)string) == 1;
            }
        }
        return false;
    }

    public static void setHidden(String string, boolean bl) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.setHidden(bl);
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.setHidden(bl);
                fileConnection.close();
                break;
            }
        }
    }

    public static void setReadable(String string, boolean bl) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.setReadable(bl);
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.setReadable(bl);
                fileConnection.close();
                break;
            }
        }
    }

    public static void setWritable(String string, boolean bl) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.setWritable(bl);
                fileConnection.close();
                break;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) break;
                fileConnection.setWritable(bl);
                fileConnection.close();
                break;
            }
        }
    }

    public static long spaceUsed(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.usedSize();
                fileConnection.close();
                return l;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.usedSize();
                fileConnection.close();
                return l;
            }
            case 3: {
                return 0L;
            }
        }
        return -1L;
    }

    public static long spaceFree(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.availableSize();
                fileConnection.close();
                return l;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.availableSize();
                fileConnection.close();
                return l;
            }
            case 3: {
                if (string.equals("A:/") || string.equals("a:/")) {
                    return com.siemens.mp.io.File.spaceAvailable();
                }
                return 0L;
            }
        }
        return -1L;
    }

    public static long spaceTotal(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.totalSize();
                fileConnection.close();
                return l;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.totalSize();
                fileConnection.close();
                return l;
            }
            case 3: {
                if (string.equals("A:/") || string.equals("a:/")) {
                    return com.siemens.mp.io.File.spaceAvailable();
                }
                return 0L;
            }
        }
        return -1L;
    }

    public static long lastModified(String string) throws IOException {
        switch (platform) {
            case 1: {
                javax.microedition.io.file.FileConnection fileConnection = (javax.microedition.io.file.FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.lastModified();
                fileConnection.close();
                return l;
            }
            case 2: {
                FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + string));
                if (!fileConnection.exists()) {
                    return -1L;
                }
                long l = fileConnection.lastModified();
                fileConnection.close();
                return l;
            }
            case 3: {
                return System.currentTimeMillis();
            }
        }
        return -1L;
    }

    public static String subDirectory(String string) {
        int n = string.lastIndexOf(47, string.length() - 2);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n + 1);
    }

    private static int getPlatform() {
        try {
            Class.forName("javax.microedition.io.file.FileConnection");
            return 1;
        }
        catch (Throwable throwable) {
            try {
                Class.forName("com.siemens.mp.io.file.FileConnection");
                return 2;
            }
            catch (Throwable throwable2) {
                try {
                    Class.forName("com.siemens.mp.io.File");
                    return 3;
                }
                catch (Throwable throwable3) {
                    return 0;
                }
            }
        }
    }

    public static StreamConnection openConnection(String string, int n) throws IOException {
        switch (platform) {
            case 1: {
                return (StreamConnection)Connector.open((String)("file:///" + string), (int)n);
            }
            case 2: {
                return (StreamConnection)Connector.open((String)("file:///" + string), (int)n);
            }
            case 3: {
                return (StreamConnection)Connector.open((String)("file://" + string), (int)n);
            }
        }
        return null;
    }
}

