/*
 * Decompiled with CFR 0.152.
 */
package voxtr.controller;

import voxtr.data.Recording;
import voxtr.service.MMAPIService;
import voxtr.service.RecordingService;
import voxtr.util.Logger;

public class AudioController {
    protected MMAPIService mMMAPIService = new MMAPIService();
    protected long mStartTimeMillis;

    public void playSound(String pContentType, byte[] pAudioData) {
        this.mMMAPIService.setContentType(pContentType);
        this.mMMAPIService.setAudioData(pAudioData);
        this.mMMAPIService.startAudioPlaying();
    }

    public void startCapture() {
        this.mMMAPIService.startAudioCapture();
        this.mStartTimeMillis = System.currentTimeMillis();
    }

    public void stopCapture() {
        long stopTimeMillis = System.currentTimeMillis();
        this.mMMAPIService.stopAudioCapture();
        String contentType = this.mMMAPIService.getContentType();
        byte[] audioData = this.mMMAPIService.getAudioData();
        if (audioData != null) {
            if (audioData.length > 0) {
                String name = RecordingService.createName(this.mStartTimeMillis, stopTimeMillis);
                Recording recording = new Recording(this.mStartTimeMillis, stopTimeMillis, name, contentType, audioData);
                RecordingService.addRecording(recording);
            } else {
                this.log("ERROR! AudioData length is 0.");
            }
        } else {
            this.log("ERROR! AudioData is null.");
        }
    }

    protected void log(String pMessage) {
        Logger.log(this, pMessage);
    }
}

