/*
 * Decompiled with CFR 0.152.
 */
package voxtr.persist;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import voxtr.data.Recording;

public class RecordingDB {
    protected static final String RECORDSTORE_NAME = "VOXTR_RECORDING_DB";
    protected static RecordStore mRecordStore;
    protected static boolean mIsRecordStoreOpen;

    protected RecordingDB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Recording select(long pTimestamp) {
        RecordingDB.openRecordStore();
        try {
            final long filter = pTimestamp;
            RecordEnumeration records = mRecordStore.enumerateRecords(new RecordFilter(){

                public boolean matches(byte[] pCandidate) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(pCandidate);
                    DataInputStream dis = new DataInputStream(bais);
                    try {
                        long timestamp = dis.readLong();
                        return timestamp == filter;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
            }, null, false);
            if (records.hasNextElement()) {
                Recording recording;
                byte[] data = records.nextRecord();
                Recording recording2 = recording = new Recording(data, true);
                return recording2;
            }
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        finally {
            RecordingDB.closeRecordStore();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Recording[] selectAll(boolean pReadFully) {
        RecordingDB.openRecordStore();
        try {
            int numRecords = mRecordStore.getNumRecords();
            Recording[] recordings = new Recording[numRecords];
            RecordEnumeration recordEnum = mRecordStore.enumerateRecords(null, null, false);
            int r = 0;
            while (recordEnum.hasNextElement()) {
                Recording recording;
                byte[] data = recordEnum.nextRecord();
                recordings[r] = recording = new Recording(data, pReadFully);
                ++r;
            }
            Recording[] recordingArray = recordings;
            return recordingArray;
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        finally {
            RecordingDB.closeRecordStore();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(Recording pRecording) {
        RecordingDB.openRecordStore();
        try {
            byte[] data = pRecording.serialize();
            mRecordStore.addRecord(data, 0, data.length);
            boolean bl = true;
            return bl;
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        finally {
            RecordingDB.closeRecordStore();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Recording pRecording) {
        RecordingDB.openRecordStore();
        try {
            final long filter = pRecording.getStartTimeMillis();
            RecordEnumeration records = mRecordStore.enumerateRecords(new RecordFilter(){

                public boolean matches(byte[] pCandidate) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(pCandidate);
                    DataInputStream dis = new DataInputStream(bais);
                    try {
                        long timestamp = dis.readLong();
                        return timestamp == filter;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
            }, null, false);
            while (records.hasNextElement()) {
                int id = records.nextRecordId();
                byte[] data = pRecording.serialize();
                mRecordStore.setRecord(id, data, 0, data.length);
            }
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        finally {
            RecordingDB.closeRecordStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Recording pRecording) {
        RecordingDB.openRecordStore();
        try {
            final long filter = pRecording.getStartTimeMillis();
            RecordEnumeration records = mRecordStore.enumerateRecords(new RecordFilter(){

                public boolean matches(byte[] pCandidate) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(pCandidate);
                    DataInputStream dis = new DataInputStream(bais);
                    try {
                        long timestamp = dis.readLong();
                        return timestamp == filter;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
            }, null, false);
            while (records.hasNextElement()) {
                int id = records.nextRecordId();
                mRecordStore.deleteRecord(id);
            }
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        finally {
            RecordingDB.closeRecordStore();
        }
    }

    public static void removeAll() {
        try {
            RecordStore.deleteRecordStore((String)RECORDSTORE_NAME);
        }
        catch (RecordStoreNotFoundException ex) {
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    protected static void openRecordStore() {
        if (!mIsRecordStoreOpen) {
            try {
                mRecordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
                mIsRecordStoreOpen = true;
            }
            catch (RecordStoreNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreFullException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected static void closeRecordStore() {
        try {
            mRecordStore.closeRecordStore();
        }
        catch (RecordStoreNotOpenException ex) {
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        mIsRecordStoreOpen = false;
    }

    static {
        mIsRecordStoreOpen = false;
    }
}

