/*
 * Decompiled with CFR 0.152.
 */
package voxtr.service;

import java.util.Calendar;
import java.util.Date;
import voxtr.data.Recording;
import voxtr.persist.RecordingDB;

public class RecordingService {
    protected static final String SECONDS_STRING = "s";

    public static Recording getRecording(long pTimestamp) {
        return RecordingDB.select(pTimestamp);
    }

    public static Recording[] getAllRecordingsMeta() {
        return RecordingDB.selectAll(false);
    }

    public static void addRecording(Recording pRecording) {
        RecordingDB.insert(pRecording);
    }

    public static void editRecording(Recording pRecording) {
        RecordingDB.update(pRecording);
    }

    public static void deleteRecording(Recording pRecording) {
        RecordingDB.remove(pRecording);
    }

    public static long getLengthTimeMillis(Recording pRecording) {
        return pRecording.getStopTimeMillis() - pRecording.getStartTimeMillis();
    }

    public static String getSecondsString(long pStartTime, long pStopTime) {
        return (pStopTime - pStartTime) / 1000L + SECONDS_STRING;
    }

    public static String createName(long pStartTime, long pStopTime) {
        String monthString;
        Date time = new Date(pStopTime);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int day = calendar.get(5);
        int month = calendar.get(2);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        switch (month) {
            case 0: {
                monthString = "Jan";
                break;
            }
            case 1: {
                monthString = "Feb";
                break;
            }
            case 2: {
                monthString = "Mar";
                break;
            }
            case 3: {
                monthString = "Apr";
                break;
            }
            case 4: {
                monthString = "May";
                break;
            }
            case 5: {
                monthString = "Jun";
                break;
            }
            case 6: {
                monthString = "Jul";
                break;
            }
            case 7: {
                monthString = "Aug";
                break;
            }
            case 8: {
                monthString = "Sep";
                break;
            }
            case 9: {
                monthString = "Oct";
                break;
            }
            case 10: {
                monthString = "Nov";
                break;
            }
            case 11: {
                monthString = "Dec";
                break;
            }
            default: {
                monthString = "???";
            }
        }
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        String length = RecordingService.getSecondsString(pStartTime, pStopTime);
        return day + "-" + monthString + " " + hourString + ":" + minuteString + " " + length;
    }
}

