/*
 * Decompiled with CFR 0.152.
 */
package net.sf.microinstall;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import net.sf.microinstall.InstallListener;

public class SmsInstaller {
    private static final int SMS_LENGTH = 158;
    private InstallListener installListener;
    private MessageConnection messageConnection;

    public void setInstallListener(InstallListener listener) {
        this.installListener = listener;
    }

    public void install(final String telephoneNo, String installationText, String installationURL) throws IllegalArgumentException {
        if (installationURL == null) {
            throw new IllegalArgumentException("The installationURL must not be null.");
        }
        int installationTextLength = 0;
        if (installationText != null) {
            installationText.length();
        }
        if (installationTextLength + installationURL.length() > 158) {
            throw new IllegalArgumentException("SMS content exceeds 158 characters.");
        }
        StringBuffer messageBuffer = new StringBuffer(200);
        if (installationText != null) {
            messageBuffer.append(installationText);
        } else {
            messageBuffer.append("Please select the following link.");
        }
        messageBuffer.append(new char[]{'\n'});
        messageBuffer.append(installationURL);
        messageBuffer.append(new char[]{'\n'});
        final String messageString = messageBuffer.toString();
        new Thread(new Runnable(){

            public void run() {
                SmsInstaller.this.sendMessage(telephoneNo, messageString);
            }
        }).start();
    }

    private void sendMessage(String phoneNo, String messageString) {
        block3: {
            try {
                this.messageConnection = (MessageConnection)Connector.open((String)("sms://" + phoneNo));
                TextMessage textMessage = (TextMessage)this.messageConnection.newMessage("text");
                textMessage.setPayloadText(messageString);
                this.messageConnection.send((Message)textMessage);
                if (this.installListener != null) {
                    this.installListener.installationFinished();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.installListener == null) break block3;
                this.installListener.installationFailed("Failed to send the installation SMS", e);
            }
        }
    }
}

