/*
 * Decompiled with CFR 0.152.
 */
package voxtr.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.RecordControl;
import voxtr.util.Logger;

public class MMAPIService {
    protected Player mRecordingPlayer;
    protected Player mPlayingPlayer;
    protected RecordControl mRecordControl;
    protected ByteArrayOutputStream mRecordingOutput;
    protected String mContentType;
    protected byte[] mAudioData;

    public String getContentType() {
        return this.mContentType;
    }

    public void setContentType(String pContentType) {
        this.mContentType = pContentType;
    }

    public byte[] getAudioData() {
        return this.mAudioData;
    }

    public void setAudioData(byte[] pAudioData) {
        this.mAudioData = pAudioData;
    }

    public void startAudioPlaying() {
        this.log("startAudioPlaying() BEGIN");
        try {
            if (this.mPlayingPlayer != null && this.mPlayingPlayer.getState() == 400) {
                this.mPlayingPlayer.stop();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.mAudioData);
            this.mPlayingPlayer = Manager.createPlayer((InputStream)is, (String)this.mContentType);
            this.mPlayingPlayer.realize();
            this.mPlayingPlayer.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.log("startAudioPlaying() END");
    }

    public void startAudioCapture() {
        this.mAudioData = null;
        this.mContentType = null;
        new Thread(){

            public void run() {
                MMAPIService.this.log("startAudioCapture()->Thread.run() BEGIN");
                try {
                    MMAPIService.this.mRecordingPlayer = Manager.createPlayer((String)"capture://audio");
                    MMAPIService.this.mRecordingPlayer.realize();
                    MMAPIService.this.mRecordControl = (RecordControl)MMAPIService.this.mRecordingPlayer.getControl("RecordControl");
                    MMAPIService.this.mRecordingOutput = new ByteArrayOutputStream();
                    MMAPIService.this.mRecordControl.setRecordStream((OutputStream)MMAPIService.this.mRecordingOutput);
                    MMAPIService.this.mRecordControl.startRecord();
                    MMAPIService.this.mRecordingPlayer.start();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
                MMAPIService.this.log("startAudioCapture()->Thread.run() END");
            }
        }.start();
    }

    public void stopAudioCapture() {
        this.log("stopAudioCapture() BEGIN");
        if (this.mRecordControl != null) {
            try {
                this.mRecordControl.stopRecord();
                this.mRecordControl.commit();
                this.mRecordingPlayer.stop();
                this.mContentType = this.mRecordControl.getContentType();
                this.mRecordingOutput.close();
                this.mRecordingPlayer.close();
                this.mAudioData = this.mRecordingOutput.toByteArray();
                this.mRecordingOutput = null;
                this.mRecordingPlayer = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
        } else {
            this.log("ERROR! RecordControl is null.");
        }
        this.log("stopAudioCapture() END");
    }

    protected void log(String pMessage) {
        Logger.log(this, pMessage);
    }
}

