/*
 * Decompiled with CFR 0.152.
 */
package voxtr.ui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import voxtr.data.Recording;
import voxtr.midlet.VoxtrMidlet;
import voxtr.service.RecordingService;
import voxtr.ui.SendUI;
import voxtr.ui.Showable;
import voxtr.util.Logger;

public class MoreUI
implements CommandListener,
Showable {
    protected MIDlet mMidlet;
    protected Showable mBackUI;
    protected Showable mSendUI;
    protected Command mSelectCommand;
    protected Command mBackCommand;
    protected List mList;
    protected Recording mRecording;
    protected int mDelete;
    protected int mHelp;
    protected int mAbout;
    protected int mSend;
    protected int mExit;

    public MoreUI(MIDlet pMidlet, Showable pBackUI) {
        this.mMidlet = pMidlet;
        this.mBackUI = pBackUI;
        this.mSelectCommand = new Command("Select", 4, 10);
        this.mBackCommand = new Command("Back", 2, 10);
        this.mList = new List("More", 3);
        this.mList.setSelectCommand(this.mSelectCommand);
        this.mList.addCommand(this.mBackCommand);
        this.mList.setCommandListener((CommandListener)this);
        this.mSendUI = new SendUI(this.mMidlet, this);
    }

    public void setRecording(Recording pRecording) {
        this.mRecording = pRecording;
    }

    public void show() {
        Displayable ui = this.updateUI();
        Display.getDisplay((MIDlet)this.mMidlet).setCurrent(ui);
    }

    public void commandAction(Command pCommand, Displayable pDisplayable) {
        if (pCommand == this.mSelectCommand) {
            int selected = this.mList.getSelectedIndex();
            if (selected == this.mDelete) {
                if (this.mRecording != null) {
                    this.log("DELETE pressed");
                    RecordingService.deleteRecording(this.mRecording);
                } else {
                    this.log("SYSTEM ERROR! mRecording is null.");
                }
                this.mBackUI.show();
            } else if (selected == this.mHelp) {
                this.info("Help", "\n\nHelp text not implemented yet.\n\n");
            } else if (selected == this.mAbout) {
                this.info("About", "\n\nVoxtr\n\nThe Voice Recorder\n\n\n\nVersion: 0.4.0\n\nDeveloped by the Voxtr team:\nDarius Katz\nJohan Karlsson\n\n\nVoxtr is subject to the terms and conditions of Apache License v2.0\nMore info:\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nThe Voxtr homepage is:\nhttp://code.google.com/p/voxtr\n\nThanks to:\nOur families for their patience and understanding.\n\n\n");
            } else if (selected == this.mSend) {
                this.mSendUI.show();
            } else if (selected == this.mExit) {
                ((VoxtrMidlet)this.mMidlet).destroyApp(true);
                this.mMidlet.notifyDestroyed();
            } else {
                this.log("WARNING! Unknown index was selected.");
            }
        } else if (pCommand == this.mBackCommand) {
            this.mRecording = null;
            this.mBackUI.show();
        } else {
            this.log("WARNING! Unknown command was executed.");
        }
    }

    protected Displayable updateUI() {
        this.mList.deleteAll();
        int index = 0;
        if (this.mRecording != null) {
            this.mList.append("Delete", null);
            this.mDelete = index++;
        } else {
            this.mDelete = -1;
        }
        this.mList.append("Help", null);
        this.mHelp = index++;
        this.mList.append("About Voxtr", null);
        this.mAbout = index++;
        this.mList.append("Share Voxtr", null);
        this.mSend = index++;
        this.mList.append("Exit", null);
        this.mExit = index++;
        return this.mList;
    }

    protected void info(String pTitle, String pMessage) {
        Alert info = new Alert(pTitle, pMessage, null, AlertType.INFO);
        info.setTimeout(-2);
        Display.getDisplay((MIDlet)this.mMidlet).setCurrent((Displayable)info);
    }

    protected void log(String pMessage) {
        Logger.log(this, pMessage);
    }
}

