/*
 * Decompiled with CFR 0.152.
 */
package zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import zip.IntShortHashMap;
import zip.ZipEntry;
import zip.ZipFile;

public final class ZipOutputStream {
    private static final int TYPE_GZIP = 1;
    private byte[] outputWindow;
    private byte[] plainDataWindow;
    private int outProcessed;
    private int plainPointer;
    private static final int HASHMAP_COUNT = 4;
    IntShortHashMap[] HM;
    private byte[] inputBuffer;
    private int inEnd;
    private int inStart;
    private int[] smallCodeBuffer;
    int[] huffmanCode;
    byte[] huffmanCodeLength;
    int[] distHuffCode;
    byte[] distHuffCodeLength;
    private int[] litCount;
    private int[] distCount;
    private int status;
    private static final int STREAM_INIT = 0;
    private static final int STREAMING = 4;
    private boolean lastBlock;
    private boolean lz77active;
    private int BTYPE;
    private static final boolean debug = false;
    private static final boolean GZIP = false;
    private static final int[] crctable;
    private boolean zipFile;
    private FileConnection fc;
    static final int[] LENGTH_CODE;
    static final int[] DISTANCE_CODE;
    private Vector entries;
    private int crc;
    private ZipEntry curEntry;
    private int curMethod;
    private int size;
    private int entryoffset;
    OutputStream outbuf;
    byte[] bytes;
    private int bufoff;
    private int offset;

    static {
        int[] ctab = crctable = new int[256];
        int n = 0;
        while (n < 256) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            ctab[n] = c;
            ++n;
        }
        int[] nArray = new int[58];
        nArray[1] = 3;
        nArray[3] = 4;
        nArray[5] = 5;
        nArray[7] = 6;
        nArray[9] = 7;
        nArray[11] = 8;
        nArray[13] = 9;
        nArray[15] = 10;
        nArray[16] = 1;
        nArray[17] = 11;
        nArray[18] = 1;
        nArray[19] = 13;
        nArray[20] = 1;
        nArray[21] = 15;
        nArray[22] = 1;
        nArray[23] = 17;
        nArray[24] = 2;
        nArray[25] = 19;
        nArray[26] = 2;
        nArray[27] = 23;
        nArray[28] = 2;
        nArray[29] = 27;
        nArray[30] = 2;
        nArray[31] = 31;
        nArray[32] = 3;
        nArray[33] = 35;
        nArray[34] = 3;
        nArray[35] = 43;
        nArray[36] = 3;
        nArray[37] = 51;
        nArray[38] = 3;
        nArray[39] = 59;
        nArray[40] = 4;
        nArray[41] = 67;
        nArray[42] = 4;
        nArray[43] = 83;
        nArray[44] = 4;
        nArray[45] = 99;
        nArray[46] = 4;
        nArray[47] = 115;
        nArray[48] = 5;
        nArray[49] = 131;
        nArray[50] = 5;
        nArray[51] = 163;
        nArray[52] = 5;
        nArray[53] = 195;
        nArray[54] = 5;
        nArray[55] = 227;
        nArray[57] = 258;
        LENGTH_CODE = nArray;
        int[] nArray2 = new int[60];
        nArray2[1] = 1;
        nArray2[3] = 2;
        nArray2[5] = 3;
        nArray2[7] = 4;
        nArray2[8] = 1;
        nArray2[9] = 5;
        nArray2[10] = 1;
        nArray2[11] = 7;
        nArray2[12] = 2;
        nArray2[13] = 9;
        nArray2[14] = 2;
        nArray2[15] = 13;
        nArray2[16] = 3;
        nArray2[17] = 17;
        nArray2[18] = 3;
        nArray2[19] = 25;
        nArray2[20] = 4;
        nArray2[21] = 33;
        nArray2[22] = 4;
        nArray2[23] = 49;
        nArray2[24] = 5;
        nArray2[25] = 65;
        nArray2[26] = 5;
        nArray2[27] = 97;
        nArray2[28] = 6;
        nArray2[29] = 129;
        nArray2[30] = 6;
        nArray2[31] = 193;
        nArray2[32] = 7;
        nArray2[33] = 257;
        nArray2[34] = 7;
        nArray2[35] = 385;
        nArray2[36] = 8;
        nArray2[37] = 513;
        nArray2[38] = 8;
        nArray2[39] = 769;
        nArray2[40] = 9;
        nArray2[41] = 1025;
        nArray2[42] = 9;
        nArray2[43] = 1537;
        nArray2[44] = 10;
        nArray2[45] = 2049;
        nArray2[46] = 10;
        nArray2[47] = 3073;
        nArray2[48] = 11;
        nArray2[49] = 4097;
        nArray2[50] = 11;
        nArray2[51] = 6145;
        nArray2[52] = 12;
        nArray2[53] = 8193;
        nArray2[54] = 12;
        nArray2[55] = 12289;
        nArray2[56] = 13;
        nArray2[57] = 16385;
        nArray2[58] = 13;
        nArray2[59] = 24577;
        DISTANCE_CODE = nArray2;
    }

    static int updateCRC(int crc, byte[] buf, int off, int len) {
        int c = ~crc;
        int[] d = crctable;
        while (--len >= 0) {
            c = d[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        return ~c;
    }

    public ZipOutputStream(String url) throws IOException {
        boolean ok;
        block11: {
            this.HM = new IntShortHashMap[5];
            FileConnection c = null;
            ok = false;
            try {
                c = (FileConnection)Connector.open((String)url, (int)2);
                if (c == null) break block11;
                try {
                    c.truncate(0L);
                    ok = true;
                }
                catch (Throwable e) {
                    try {
                        c.create();
                        ok = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (ok) {
                    this.fc = c;
                    this.init(this.fc.openOutputStream(), 1024, 0, 32768, 8192, 32768, true);
                } else {
                    c.close();
                }
            }
            catch (Throwable e) {
                if (c == null) break block11;
                try {
                    c.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (!ok) {
            throw new IOException();
        }
    }

    private void def_reset() throws IOException {
        this.BTYPE = 2;
        this.status = 0;
        int i = 0;
        while (i < 4) {
            this.HM[i] = new IntShortHashMap(2048);
            ++i;
        }
        this.lastBlock = false;
    }

    private void init(OutputStream outputStream, int size, int compressionType, int plainWindowSize, int huffmanWindowSize, int bufsize, boolean ZipFile2) throws IOException {
        this.BufDataOutputStream(outputStream, bufsize);
        this.curMethod = 8;
        this.zipFile = ZipFile2;
        if (this.zipFile) {
            this.entries = new Vector();
        }
        this.curEntry = null;
        this.smallCodeBuffer = new int[2];
        this.inputBuffer = new byte[size + 300];
        this.litCount = new int[286];
        this.distCount = new int[30];
        this.plainDataWindow = new byte[plainWindowSize / 4 * 4];
        this.lz77active = true;
        if (huffmanWindowSize < 1024 && huffmanWindowSize > 0) {
            huffmanWindowSize = 1024;
        }
        this.outputWindow = new byte[huffmanWindowSize];
        this.def_reset();
    }

    public ZipOutputStream(OutputStream outputStream, int size, int compressionType, int plainWindowSize, int huffmanWindowSize, int bufsize, boolean ZipFile2) throws IOException {
        this.HM = new IntShortHashMap[5];
        this.init(outputStream, size, compressionType, plainWindowSize, huffmanWindowSize, bufsize, ZipFile2);
    }

    public void Def_close() throws IOException {
        this.Def_flush();
        if (this.BTYPE == 2) {
            if (this.outProcessed + 8 + (this.inEnd - this.inStart) * 8 / 3 > this.outputWindow.length) {
                this.compileOutput();
            }
            this.LZ77(true);
            this.lastBlock = true;
            this.compileOutput();
        } else {
            this.LZ77(true);
        }
        this.writeFooter();
    }

    public void Def_flush() throws IOException {
        this.LZ77(false);
    }

    public void Def_write(byte[] b) throws IOException {
        this.Def_write(b, 0, b.length);
    }

    public void Def_write(byte[] b, int off, int len) throws IOException {
        int processed = 0;
        this.crc = ZipOutputStream.updateCRC(this.crc, b, off, len);
        while (processed != len) {
            if (this.inputBuffer.length - this.inEnd >= len - processed) {
                System.arraycopy(b, processed + off, this.inputBuffer, this.inEnd, len - processed);
                this.inEnd += len - processed;
                processed = len;
            } else {
                System.arraycopy(b, processed + off, this.inputBuffer, this.inEnd, this.inputBuffer.length - this.inEnd);
                processed += this.inputBuffer.length - this.inEnd;
                this.inEnd = this.inputBuffer.length;
            }
            this.LZ77(false);
        }
    }

    private boolean search4LZ77(int[] bestPointer, int position) {
        IntShortHashMap.Element found = null;
        int[] pointer = new int[2];
        bestPointer[1] = 0;
        int i = 0;
        while (i < 4) {
            found = null;
            found = this.HM[i].get(128 + this.inputBuffer[position] << 16 | 128 + this.inputBuffer[position + 1] << 8 | 128 + this.inputBuffer[position + 2]);
            if (found != null && found.size != 0) {
                this.searchHM4LZ77(found, pointer, position);
                if (pointer[1] > bestPointer[1]) {
                    bestPointer[0] = pointer[0];
                    bestPointer[1] = pointer[1];
                }
            }
            ++i;
        }
        return bestPointer[1] != 0;
    }

    private void searchHM4LZ77(IntShortHashMap.Element found, int[] pointer, int position) {
        int bestK = 0;
        int bestLength = 0;
        int k = found.size - 1;
        while (k >= 0) {
            int length = 3;
            int comparePointer = 100000;
            while (length < 258 && position + length < this.inputBuffer.length) {
                comparePointer = found.values[k] < this.plainPointer ? (found.values[k] + length % (this.plainPointer - found.values[k])) % this.plainDataWindow.length : (found.values[k] + length % (this.plainPointer + this.plainDataWindow.length - found.values[k])) % this.plainDataWindow.length;
                if (this.inputBuffer[position + length] != this.plainDataWindow[comparePointer]) break;
                ++length;
            }
            if (length > bestLength) {
                bestK = k;
                bestLength = length;
                if (length == 258) break;
            }
            --k;
        }
        pointer[0] = (this.plainPointer - found.values[bestK] + this.plainDataWindow.length) % this.plainDataWindow.length;
        pointer[1] = bestLength;
    }

    private void encodePointer(int distance, int length) throws IOException {
        int di = ZipOutputStream.encodeCode(LENGTH_CODE, length);
        int litlen = 257 + di;
        byte litextra = (byte)(length - LENGTH_CODE[di * 2 + 1]);
        di = ZipOutputStream.encodeCode(DISTANCE_CODE, distance);
        int distExtra = distance - DISTANCE_CODE[di * 2 + 1];
        if (this.outputWindow.length != 0) {
            this.outputWindow[this.outProcessed] = -1;
            this.outputWindow[this.outProcessed + 1] = (byte)(litlen - 255);
            this.outputWindow[this.outProcessed + 2] = litextra;
            this.outputWindow[this.outProcessed + 3] = (byte)di;
            this.outputWindow[this.outProcessed + 4] = (byte)(distExtra & 0xFF);
            this.outputWindow[this.outProcessed + 5] = (byte)(distExtra >> 8 & 0xFF);
            this.outputWindow[this.outProcessed + 6] = (byte)(distExtra >> 16 & 0xFF);
            this.outProcessed += 6;
            int n = litlen;
            this.litCount[n] = this.litCount[n] + 1;
            int n2 = di;
            this.distCount[n2] = this.distCount[n2] + 1;
        } else {
            this.pushSmallBuffer(this.huffmanCode[litlen], this.huffmanCodeLength[litlen]);
            this.pushSmallBuffer(litextra, (byte)LENGTH_CODE[2 * (litlen - 257)]);
            this.pushSmallBuffer(this.distHuffCode[di], this.distHuffCodeLength[di]);
            this.pushSmallBuffer(distExtra, (byte)DISTANCE_CODE[di * 2]);
        }
    }

    private void encodeChar(int position) throws IOException {
        int val = this.inputBuffer[position] + 256 & 0xFF;
        if (this.outputWindow.length != 0) {
            int n = val;
            this.litCount[n] = this.litCount[n] + 1;
            this.outputWindow[this.outProcessed] = (byte)val;
            if (val == 255) {
                ++this.outProcessed;
                this.outputWindow[this.outProcessed] = 0;
            }
        } else {
            this.pushSmallBuffer(this.huffmanCode[val], this.huffmanCodeLength[val]);
        }
    }

    private void LZ77(boolean finish) throws IOException {
        if (this.inStart != 0) {
            System.arraycopy(this.inputBuffer, this.inStart, this.inputBuffer, 0, this.inEnd - this.inStart);
            this.inEnd -= this.inStart;
            this.inStart = 0;
        }
        int upTo = finish ? this.inEnd : this.inEnd - 300;
        int[] pointer = new int[2];
        int[] lastpointer = new int[2];
        int i = 0;
        while (i < upTo) {
            int length = 1;
            int distance = 0;
            if (this.lz77active && i < upTo - 2 && this.search4LZ77(pointer, i)) {
                if (pointer[1] > lastpointer[1]) {
                    lastpointer[0] = pointer[0];
                    lastpointer[1] = pointer[1];
                } else {
                    distance = pointer[0];
                    length = pointer[1];
                }
            }
            if (finish && upTo - i < length) {
                length = upTo - i;
            }
            if (length > 2) {
                this.encodePointer(distance, length);
            } else {
                this.encodeChar(i);
            }
            if (this.outputWindow.length != 0) {
                ++this.outProcessed;
                if (this.outProcessed + 8 > this.outputWindow.length) {
                    this.compileOutput();
                }
            }
            if (this.lz77active) {
                int k = 0;
                while (k < length) {
                    this.plainDataWindow[this.plainPointer] = this.inputBuffer[i + k];
                    this.HM[this.plainPointer / (this.plainDataWindow.length / 4)].put(128 + this.inputBuffer[i + k] << 16 | 128 + this.inputBuffer[i + k + 1] << 8 | 128 + this.inputBuffer[i + k + 2], (short)this.plainPointer);
                    if (++this.plainPointer % (this.plainDataWindow.length / 4) == 0) {
                        if (this.plainPointer == this.plainDataWindow.length) {
                            this.plainPointer = 0;
                        }
                        this.HM[this.plainPointer / (this.plainDataWindow.length / 4) % 4].clear();
                    }
                    ++k;
                }
            }
            i += length;
        }
        this.inStart = i;
    }

    private void newBlock() throws IOException {
        if (this.status == 0) {
            this.status = 4;
        } else {
            this.pushSmallBuffer(this.huffmanCode[256], this.huffmanCodeLength[256]);
        }
        if (this.lastBlock) {
            this.pushSmallBuffer(1, (byte)1);
        } else {
            this.pushSmallBuffer(0, (byte)1);
        }
        this.pushSmallBuffer(this.BTYPE, (byte)2);
        this.huffmanCode = new int[286];
        this.huffmanCodeLength = new byte[286];
        this.distHuffCode = new int[30];
        this.distHuffCodeLength = new byte[30];
        if (this.BTYPE == 1) {
            ZipOutputStream.genFixedTree(this.huffmanCode, this.huffmanCodeLength, this.distHuffCode, this.distHuffCodeLength);
        } else if (this.BTYPE == 2) {
            int i = 0;
            while (i < 2) {
                if (this.distCount[i] == 0) {
                    this.distCount[i] = 1;
                }
                ++i;
            }
            this.litCount[256] = 1;
            ZipOutputStream.genTreeLength(this.litCount, this.huffmanCodeLength, 15);
            ZipOutputStream.genHuffTree(this.huffmanCode, this.huffmanCodeLength);
            ZipOutputStream.revHuffTree(this.huffmanCode, this.huffmanCodeLength);
            ZipOutputStream.genTreeLength(this.distCount, this.distHuffCodeLength, 15);
            ZipOutputStream.genHuffTree(this.distHuffCode, this.distHuffCodeLength);
            ZipOutputStream.revHuffTree(this.distHuffCode, this.distHuffCodeLength);
            this.compressTree(this.huffmanCodeLength, this.distHuffCodeLength);
            i = 0;
            while (i < 286) {
                this.litCount[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 30) {
                this.distCount[i] = 0;
                ++i;
            }
        }
    }

    private void compileOutput() throws IOException {
        this.newBlock();
        int val = 0;
        int i = 0;
        while (i < this.outProcessed) {
            val = this.outputWindow[i];
            if (val < 0) {
                val += 256;
            }
            if (val != 255) {
                this.pushSmallBuffer(this.huffmanCode[val], this.huffmanCodeLength[val]);
            } else if (val == 255) {
                if (this.outputWindow[++i] == 0) {
                    this.pushSmallBuffer(this.huffmanCode[255], this.huffmanCodeLength[255]);
                } else if (this.outputWindow[i] > 0) {
                    int litlen = 255 + this.outputWindow[i];
                    byte litextra = this.outputWindow[++i];
                    byte di = this.outputWindow[++i];
                    int distExtra = this.outputWindow[++i] + 256 & 0xFF | (this.outputWindow[i + 1] + 256 & 0xFF) << 8 | (this.outputWindow[i + 2] + 256 & 0xFF) << 16;
                    i += 3;
                    this.pushSmallBuffer(this.huffmanCode[litlen], this.huffmanCodeLength[litlen]);
                    this.pushSmallBuffer(litextra, (byte)LENGTH_CODE[2 * (litlen - 257)]);
                    this.pushSmallBuffer(this.distHuffCode[di], this.distHuffCodeLength[di]);
                    this.pushSmallBuffer(distExtra, (byte)DISTANCE_CODE[di * 2]);
                    --i;
                } else {
                    throw new IOException("illegal code decoded");
                }
            }
            ++i;
        }
        this.outProcessed = 0;
    }

    private void writeFooter() throws IOException {
        this.pushSmallBuffer(this.huffmanCode[256], this.huffmanCodeLength[256]);
        if ((this.smallCodeBuffer[1] & 7) != 0) {
            this.pushSmallBuffer(0, (byte)(8 - (this.smallCodeBuffer[1] & 7)));
        }
        if (!this.zipFile) {
            this.writeLint(this.crc);
            this.writeLint(this.size);
            this.flushbuf();
            this.close();
        }
    }

    private void compressTree(byte[] huffmanCodeLength, byte[] distHuffCodeLength) throws IOException {
        int HLIT = 285;
        int HDIST = 29;
        while (huffmanCodeLength[HLIT] == 0 && HLIT > 29) {
            --HLIT;
        }
        ++HLIT;
        while (distHuffCodeLength[HDIST] == 0 && HDIST > 0) {
            --HDIST;
        }
        byte[] len = new byte[HLIT + ++HDIST];
        int j = 0;
        int i = 0;
        while (i < HLIT) {
            len[j] = huffmanCodeLength[i];
            ++j;
            ++i;
        }
        i = 0;
        while (i < HDIST) {
            len[j] = distHuffCodeLength[i];
            ++j;
            ++i;
        }
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        int[] miniHuffData = nArray;
        byte[] outLitLenDist = new byte[HLIT + HDIST];
        int outCount = 0;
        int[] miniCodeCount = new int[19];
        int i2 = 0;
        while (i2 < len.length) {
            if (i2 + 3 < len.length && len[i2] == len[i2 + 1] && len[i2] == len[i2 + 2] && len[i2] == len[i2 + 3]) {
                int k;
                if (len[i2] == 0) {
                    outLitLenDist[outCount] = 0;
                    k = 4;
                    while (i2 + k < len.length && len[i2] == len[i2 + k] && k < 139) {
                        k = (short)(k + 1);
                    }
                    if (k < 12) {
                        outLitLenDist[outCount + 1] = 17;
                        outLitLenDist[outCount + 2] = (byte)(k - 3 - 1);
                    } else {
                        outLitLenDist[outCount + 1] = 18;
                        outLitLenDist[outCount + 2] = (byte)(k - 11 - 1);
                    }
                    i2 += k - 1;
                } else {
                    outLitLenDist[outCount] = len[i2];
                    outLitLenDist[outCount + 1] = 16;
                    k = 4;
                    while (i2 + k < len.length && len[i2] == len[i2 + k] && k < 7) {
                        k = (short)(k + 1);
                    }
                    outLitLenDist[outCount + 2] = (byte)(k - 4);
                    i2 += k - 1;
                }
                byte by = outLitLenDist[outCount];
                miniCodeCount[by] = miniCodeCount[by] + 1;
                byte by2 = outLitLenDist[outCount + 1];
                miniCodeCount[by2] = miniCodeCount[by2] + 1;
                outCount += 2;
            } else {
                outLitLenDist[outCount] = len[i2];
                byte by = outLitLenDist[outCount];
                miniCodeCount[by] = miniCodeCount[by] + 1;
            }
            ++outCount;
            ++i2;
        }
        byte[] miniHuffCodeLength = new byte[19];
        int[] miniHuffCode = new int[19];
        int i3 = 0;
        ZipOutputStream.genTreeLength(miniCodeCount, miniHuffCodeLength, 7);
        ZipOutputStream.genHuffTree(miniHuffCode, miniHuffCodeLength);
        ZipOutputStream.revHuffTree(miniHuffCode, miniHuffCodeLength);
        this.pushSmallBuffer(HLIT - 257, (byte)5);
        this.pushSmallBuffer(HDIST - 1, (byte)5);
        int HCLEN = 18;
        while (miniHuffCodeLength[miniHuffData[HCLEN]] == 0 && HCLEN > 0) {
            --HCLEN;
        }
        this.pushSmallBuffer(++HCLEN - 4, (byte)4);
        i3 = 0;
        while (i3 < HCLEN) {
            this.pushSmallBuffer(miniHuffCodeLength[miniHuffData[i3]], (byte)3);
            ++i3;
        }
        i3 = 0;
        while (i3 < outCount) {
            this.pushSmallBuffer(miniHuffCode[outLitLenDist[i3]], miniHuffCodeLength[outLitLenDist[i3]]);
            if (outLitLenDist[i3] > 15) {
                switch (outLitLenDist[i3]) {
                    case 16: {
                        this.pushSmallBuffer(outLitLenDist[i3 + 1], (byte)2);
                        ++i3;
                        break;
                    }
                    case 17: {
                        this.pushSmallBuffer(outLitLenDist[i3 + 1], (byte)3);
                        ++i3;
                        break;
                    }
                    default: {
                        this.pushSmallBuffer(outLitLenDist[i3 + 1], (byte)7);
                        ++i3;
                    }
                }
            }
            ++i3;
        }
    }

    private void pushSmallBuffer(int val, byte len) throws IOException {
        int smallBuffer0 = this.smallCodeBuffer[0];
        int smallBuffer1 = this.smallCodeBuffer[1];
        smallBuffer0 &= ~((1 << len) - 1 << smallBuffer1);
        smallBuffer0 |= val << smallBuffer1;
        smallBuffer1 += len;
        while (smallBuffer1 >= 8) {
            this.writebuf(smallBuffer0 & 0xFF);
            smallBuffer0 >>>= 8;
            smallBuffer1 -= 8;
        }
        this.smallCodeBuffer[0] = smallBuffer0;
        this.smallCodeBuffer[1] = smallBuffer1;
    }

    static int encodeCode(int[] Code, int distance) {
        int i = 0;
        while (i < Code.length >> 1 && distance >= Code[(i << 1) + 1]) {
            ++i;
        }
        return i - 1;
    }

    static void genHuffTree(int[] huffmanCode, byte[] huffmanCodeLength) {
        int maxbits = 0;
        int i = 0;
        while (i < huffmanCodeLength.length) {
            int length = huffmanCodeLength[i];
            maxbits = maxbits > length ? maxbits : length;
            ++i;
        }
        short[] bitlen_count = new short[++maxbits];
        int i2 = 0;
        while (i2 < huffmanCodeLength.length) {
            byte by = huffmanCodeLength[i2];
            bitlen_count[by] = (short)(bitlen_count[by] + 1);
            ++i2;
        }
        int code = 0;
        int[] next_code = new int[maxbits];
        bitlen_count[0] = 0;
        int bits = 1;
        while (bits < maxbits) {
            next_code[bits] = code = code + bitlen_count[bits - 1] << 1;
            ++bits;
        }
        int i3 = 0;
        while (i3 < huffmanCode.length) {
            byte length = huffmanCodeLength[i3];
            if (length != 0) {
                huffmanCode[i3] = next_code[length];
                byte by = length;
                next_code[by] = next_code[by] + 1;
            }
            ++i3;
        }
    }

    static void revHuffTree(int[] huffmanCode, byte[] huffmanCodeLength) {
        int i = 0;
        while (i < huffmanCode.length) {
            int tmp = huffmanCode[i];
            int reversed = 0;
            int j = 0;
            while (j < huffmanCodeLength[i]) {
                reversed |= tmp >>> j & 1;
                reversed <<= 1;
                ++j;
            }
            huffmanCode[i] = reversed >>> 1;
            ++i;
        }
    }

    static void genFixedTree(int[] huffmanCode, byte[] huffmanCodeLength, int[] distHuffCode, byte[] distHuffCodeLength) {
        int i = 0;
        while (i <= 143) {
            huffmanCode[i] = 48 + i;
            huffmanCodeLength[i] = 8;
            ++i;
        }
        i = 144;
        while (i <= 255) {
            huffmanCode[i] = 400 + i - 144;
            huffmanCodeLength[i] = 9;
            ++i;
        }
        i = 256;
        while (i <= 279) {
            huffmanCode[i] = i - 256;
            huffmanCodeLength[i] = 7;
            ++i;
        }
        i = 280;
        while (i < 286) {
            huffmanCode[i] = 192 + i - 280;
            huffmanCodeLength[i] = 8;
            ++i;
        }
        ZipOutputStream.revHuffTree(huffmanCode, huffmanCodeLength);
        int j = 0;
        while (j < distHuffCode.length) {
            distHuffCode[j] = j;
            distHuffCodeLength[j] = 5;
            ++j;
        }
        ZipOutputStream.revHuffTree(distHuffCode, distHuffCodeLength);
    }

    static void genTreeLength(int[] count, byte[] huffmanCodeLength, int max_len) {
        int i;
        int[] knotCount = new int[count.length];
        int[] knotPointer = new int[count.length];
        int i2 = 0;
        while (i2 < count.length) {
            knotCount[i2] = count[i2] != 0 ? count[i2] : Integer.MAX_VALUE;
            knotPointer[i2] = i2;
            i2 = (short)(i2 + 1);
        }
        int s1 = 0;
        int s2 = 0;
        block1: while (true) {
            if (knotCount[0] < knotCount[1]) {
                s1 = 0;
                s2 = 1;
            } else {
                s1 = 1;
                s2 = 0;
            }
            int i3 = 2;
            while (i3 < count.length) {
                if (knotCount[i3] < knotCount[s1]) {
                    s2 = s1;
                    s1 = i3;
                } else if (knotCount[i3] < knotCount[s2]) {
                    s2 = i3;
                }
                ++i3;
            }
            if (knotCount[s2] == Integer.MAX_VALUE) break;
            int n = s1;
            knotCount[n] = knotCount[n] + knotCount[s2];
            int tmp = knotPointer[s2];
            knotCount[s2] = Integer.MAX_VALUE;
            i = 0;
            while (true) {
                if (i >= count.length) continue block1;
                if (knotPointer[i] == tmp) {
                    knotPointer[i] = knotPointer[s1];
                    int n2 = i;
                    huffmanCodeLength[n2] = (byte)(huffmanCodeLength[n2] + 1);
                } else if (knotPointer[i] == knotPointer[s1]) {
                    int n3 = i;
                    huffmanCodeLength[n3] = (byte)(huffmanCodeLength[n3] + 1);
                }
                ++i;
            }
            break;
        }
        int overflowCount = 0;
        i = 0;
        while (i < huffmanCodeLength.length) {
            if (huffmanCodeLength[i] > max_len) {
                ++overflowCount;
            }
            ++i;
        }
        if (overflowCount != 0) {
            short[] overflows = new short[overflowCount];
            overflowCount = 0;
            int i4 = 0;
            while (i4 < huffmanCodeLength.length) {
                if (huffmanCodeLength[i4] > max_len) {
                    overflows[overflowCount++] = i4;
                }
                i4 = (short)(i4 + 1);
            }
            int minNode = 0;
            int i5 = 0;
            while (i5 < huffmanCodeLength.length) {
                if (huffmanCodeLength[i5] != 0 && huffmanCodeLength[minNode] > huffmanCodeLength[i5]) {
                    minNode = i5;
                }
                ++i5;
            }
            while (overflowCount != 0) {
                int exendableNode = minNode;
                int i6 = 0;
                while (i6 < huffmanCodeLength.length) {
                    if (huffmanCodeLength[i6] < max_len && huffmanCodeLength[exendableNode] < huffmanCodeLength[i6]) {
                        exendableNode = i6;
                    }
                    ++i6;
                }
                int overflow1 = 0;
                int overflow2 = 0;
                i6 = 0;
                while (i6 < overflows.length) {
                    if (huffmanCodeLength[overflows[i6]] > huffmanCodeLength[overflow1]) {
                        overflow1 = overflows[i6];
                    } else if (huffmanCodeLength[overflows[i6]] == huffmanCodeLength[overflow1]) {
                        overflow2 = overflows[i6];
                    }
                    ++i6;
                }
                int n = exendableNode;
                huffmanCodeLength[n] = (byte)(huffmanCodeLength[n] + 1);
                huffmanCodeLength[overflow1] = huffmanCodeLength[exendableNode];
                int n4 = overflow2;
                huffmanCodeLength[n4] = (byte)(huffmanCodeLength[n4] - 1);
                --overflowCount;
                if (huffmanCodeLength[overflow2] != max_len) continue;
                --overflowCount;
            }
        }
    }

    static void convertTable2Tree(int[] huffmanCode, byte[] huffmanCodeLength, int[] huffmanData, short[] huffmanTree) {
        int i = 0;
        while (i < huffmanTree.length) {
            huffmanTree[i] = 0;
            ++i;
        }
        int nextNode = 1;
        int i2 = 0;
        while (i2 < huffmanCode.length) {
            if (huffmanCodeLength[i2] != 0) {
                int pointer = 0;
                short j = 0;
                while (j < huffmanCodeLength[i2]) {
                    if (huffmanTree[pointer * 2] == 0) {
                        int n = nextNode;
                        nextNode = (short)(n + 1);
                        huffmanTree[pointer * 2] = n;
                        int n2 = nextNode;
                        nextNode = (short)(n2 + 1);
                        huffmanTree[pointer * 2 + 1] = n2;
                    }
                    pointer = huffmanTree[pointer * 2 + (huffmanCode[i2] >>> j & 1)];
                    j = (short)(j + 1);
                }
                if (pointer < 0) {
                    // empty if block
                }
                huffmanTree[pointer * 2] = -1;
                huffmanTree[pointer * 2 + 1] = (short)huffmanData[i2];
            }
            i2 = (short)(i2 + 1);
        }
    }

    static int deHuffNext(long[] smallCodeBuffer, short[] huffmanTree) throws IOException {
        int pointer = 0;
        while (huffmanTree[pointer * 2] != -1) {
            pointer = huffmanTree[pointer * 2 + (int)(smallCodeBuffer[0] & 1L)];
            smallCodeBuffer[0] = smallCodeBuffer[0] >>> 1;
            smallCodeBuffer[1] = smallCodeBuffer[1] - 1L;
            if (pointer != 0) continue;
            throw new IOException("5");
        }
        return huffmanTree[pointer * 2 + 1];
    }

    public void putNextEntry(String name) throws Exception {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(System.currentTimeMillis());
        this.putNextEntry(entry);
    }

    public void putNextEntry(ZipEntry entry) throws Exception {
        if (this.curEntry != null) {
            this.closeEntry();
        }
        entry.flag = 8;
        entry.setMethod(this.curMethod);
        this.curEntry = entry;
        this.entries.addElement(entry);
        entry.offset = this.getoffse();
        this.writeLint(67324752);
        this.writeLshort(entry.getMethod() == 0 ? 10 : 20);
        this.writeEntry(entry);
        this.writebuf(entry.getNamebytes());
        this.size = 0;
        this.crc = 0;
        this.def_reset();
        this.entryoffset = this.getoffse();
    }

    public void putFooEntry(ZipEntry entry, ZipFile zip) throws Exception {
        if (this.curEntry != null) {
            this.closeEntry();
        }
        zip.setOffset(entry.offset + 26);
        zip.skipbuf(zip.readLshort() + zip.readLshort());
        entry.flag = 0;
        this.entries.addElement(entry);
        entry.offset = this.getoffse();
        this.writeLint(67324752);
        this.writeLshort(entry.isDirectory() ? 10 : 20);
        this.writeEntry(entry);
        this.writebuf(entry.getNamebytes());
        this.writebuf(zip.bytes, zip.getOffst(), entry.compressedSize);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void closeEntry() throws Exception {
        if (this.curEntry == null) {
            return;
        }
        if (this.curMethod == 8) {
            this.Def_close();
        }
        ZipEntry entry = this.curEntry;
        entry.size = this.size;
        int now = this.getoffse();
        entry.compressedSize = now - this.entryoffset;
        entry.crc = this.crc;
        if (!this.resetTo(entry.offset + 6)) {
            this.writeLint(134695760);
            this.writeLint(entry.crc);
            this.writeLint(entry.compressedSize);
            this.writeLint(entry.size);
        } else {
            entry.flag = 0;
            this.writeEntry(entry);
            this.skipto(now);
        }
        this.flushbuf();
        this.curEntry = null;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.curMethod == 0) {
            this.writebuf(b, off, len);
            this.crc = ZipOutputStream.updateCRC(this.crc, b, off, len);
        } else {
            this.Def_write(b, off, len);
        }
        this.size += len;
    }

    private void writeEntry(ZipEntry entry) throws IOException {
        this.writeLshort(entry.flag);
        this.writeLshort(entry.getMethod());
        this.writeLint(entry.dostime);
        this.writeLint(entry.crc);
        this.writeLint(entry.compressedSize);
        this.writeLint(entry.size);
        this.writeLshort(entry.namelen);
        this.writeLshort(0);
    }

    private void finish() throws Exception {
        if (this.curEntry != null) {
            this.closeEntry();
        }
        int dataoff = this.getoffse();
        int sizeEntries = 0;
        int numEntries = this.entries.size();
        int k = 0;
        while (k < numEntries) {
            ZipEntry entry = (ZipEntry)this.entries.elementAt(k);
            this.writeLint(33639248);
            this.writeLshort(20);
            this.writeLshort(entry.isDirectory() ? 10 : 20);
            this.writeEntry(entry);
            this.writeLshort(0);
            this.writeLshort(0);
            this.writeLshort(0);
            this.writeLint(entry.isDirectory() ? 1103101968 : -2122317792);
            this.writeLint(entry.offset);
            this.writebuf(entry.getNamebytes());
            sizeEntries += 46 + entry.namelen;
            ++k;
        }
        this.writeLint(101010256);
        this.writeLint(0);
        this.writeLshort(numEntries);
        this.writeLshort(numEntries);
        this.writeLint(sizeEntries);
        this.writeLint(dataoff);
        this.writeLshort(0);
        this.flushbuf();
        this.entries = null;
    }

    public void close() {
        try {
            if (this.zipFile && this.entries != null) {
                this.finish();
            } else {
                this.flushbuf();
            }
            this.bytes = null;
            this.outbuf.close();
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.outputWindow = null;
        this.inputBuffer = null;
        this.litCount = null;
    }

    private void BufDataOutputStream(OutputStream output, int bufsize) {
        this.outbuf = output;
        this.bytes = new byte[bufsize];
        this.bufoff = 0;
        this.offset = 0;
    }

    private boolean resetTo(int off) {
        int l = this.offset - off;
        if (l <= this.bufoff) {
            this.bufoff -= l;
            this.offset = off;
            return true;
        }
        return false;
    }

    private int getoffse() {
        return this.offset;
    }

    private void skipto(int off) {
        this.bufoff += off - this.offset;
        this.offset = off;
    }

    private void flushbuf() throws IOException {
        if (this.bufoff > 0) {
            this.outbuf.write(this.bytes, 0, this.bufoff);
            this.bufoff = 0;
        }
    }

    private void writebuf(byte[] addr, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (len < this.bytes.length - this.bufoff) {
            System.arraycopy(addr, off, this.bytes, this.bufoff, len);
            this.bufoff += len;
        } else {
            this.flushbuf();
            this.outbuf.write(addr, off, len);
        }
        this.offset += len;
    }

    private void writebuf(byte[] b) throws IOException {
        this.writebuf(b, 0, b.length);
    }

    private void writebuf(int l) throws IOException {
        if (this.bytes.length < this.bufoff + 1) {
            this.flushbuf();
        }
        ++this.offset;
        this.bytes[this.bufoff++] = (byte)l;
    }

    private void writeLshort(int l) throws IOException {
        if (this.bytes.length < this.bufoff + 2) {
            this.flushbuf();
        }
        this.offset += 2;
        this.bytes[this.bufoff++] = (byte)l;
        this.bytes[this.bufoff++] = (byte)(l >> 8);
    }

    private void writeLint(int l) throws IOException {
        if (this.bytes.length < this.bufoff + 4) {
            this.flushbuf();
        }
        this.offset += 4;
        this.bytes[this.bufoff++] = (byte)l;
        this.bytes[this.bufoff++] = (byte)(l >> 8);
        this.bytes[this.bufoff++] = (byte)(l >> 16);
        this.bytes[this.bufoff++] = (byte)(l >> 24);
    }
}

