/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Square
extends Face {
    public Vertex v1;
    public Vertex v2;
    public Vertex v3;
    public Vertex v4;
    public float nx;
    public float ny;
    public float nz;
    public float rnx;
    public float rny;
    public float rnz;
    public float k;

    public void normal() throws  {
    }

    public int getS() throws  {
        return (this.v1.zc + this.v2.zc + this.v3.zc + this.v4.zc) / 4;
    }

    public void paint(Graphics graphics) throws  {
        int n = this.color >> 16 & 0xFF;
        int n2 = this.color >> 8 & 0xFF;
        int n3 = this.color & 0xFF;
        n = (int)((float)n * -this.k);
        n2 = (int)((float)n2 * -this.k);
        n3 = (int)((float)n3 * -this.k);
        this.paint(graphics, n << 16 | n2 << 8 | n3);
    }

    public void paint(Graphics graphics, int n) throws  {
        graphics.setColor(n);
        graphics.fillTriangle(this.v1.sx, this.v1.sy, this.v2.sx, this.v2.sy, this.v3.sx, this.v3.sy);
        graphics.fillTriangle(this.v1.sx, this.v1.sy, this.v3.sx, this.v3.sy, this.v4.sx, this.v4.sy);
    }

    public void setMatrix(Matrix3D matrix3D) throws  {
        this.v1.setMatrix(matrix3D);
        this.v2.setMatrix(matrix3D);
        this.v3.setMatrix(matrix3D);
        this.v4.setMatrix(matrix3D);
        this.rnx = this.nx * matrix3D.xx + this.ny * matrix3D.xy + this.nz * matrix3D.xz;
        this.rny = this.nx * matrix3D.yx + this.ny * matrix3D.yy + this.nz * matrix3D.yz;
        this.k = this.rnz = this.nx * matrix3D.zx + this.ny * matrix3D.zy + this.nz * matrix3D.zz;
        if (!(this.k <= 0.0f)) {
            this.k = -this.k;
        }
        if (this.k < (float)-1) {
            this.k = -1;
        }
    }

    public void move(int n, int n2, int n3) throws  {
        this.v1.move(n, n2, n3);
        this.v2.move(n, n2, n3);
        this.v3.move(n, n2, n3);
        this.v4.move(n, n2, n3);
    }

    public boolean topaint() throws  {
        if (this.v1.zc < 0 || this.v2.zc < 0 || this.v3.zc < 0 || this.v4.zc < 0) {
            return false;
        }
        if (this.v1.zc > Camera.limit && this.v2.zc > Camera.limit && this.v3.zc > Camera.limit && this.v4.zc > Camera.limit) {
            return false;
        }
        if (this.v1.sx <= 0 && this.v2.sx <= 0 && this.v3.sx <= 0 && this.v4.sx <= 0) {
            return false;
        }
        if (this.v1.sx >= Camera.w && this.v2.sx >= Camera.w && this.v3.sx >= Camera.w && this.v4.sx >= Camera.w) {
            return false;
        }
        if (this.v1.sy <= 0 && this.v2.sy <= 0 && this.v3.sy <= 0 && this.v4.sy <= 0) {
            return false;
        }
        return this.v1.sy < Camera.h || this.v2.sy < Camera.h || this.v3.sy < Camera.h || this.v4.sy < Camera.h;
    }

    public void soequal() throws  {
        this.v1.soequal();
        this.v2.soequal();
        this.v3.soequal();
        this.v4.soequal();
        this.nx = this.rnx;
        this.ny = this.rny;
        this.nz = this.rnz;
    }

    public boolean checkCoor(int n, int n2, int n3) throws  {
        return this.v1.x == n && this.v1.y == n2 && this.v1.z == n3 || this.v2.x == n && this.v2.y == n2 && this.v2.z == n3 || this.v3.x == n && this.v3.y == n2 && this.v3.z == n3 || this.v4.x == n && this.v4.y == n2 && this.v4.z == n3;
    }

    public void paintXY(Graphics graphics, int n) throws  {
        this.paintXY(graphics, this.color, n);
    }

    public void paintXZ(Graphics graphics, int n) throws  {
        this.paintXZ(graphics, this.color, n);
    }

    public void paintYZ(Graphics graphics, int n) throws  {
        this.paintYZ(graphics, this.color, n);
    }

    public void paintXY(Graphics graphics, int n, int n2) throws  {
        graphics.setColor(n);
        int n3 = Camera.w / 2 + Camera.x0;
        int n4 = Camera.h / 2 - Camera.y0;
        int n5 = n3 + this.v1.x * n2;
        int n6 = n4 - this.v1.y * n2;
        int n7 = n3 + this.v3.x * n2;
        int n8 = n4 - this.v3.y * n2;
        graphics.fillTriangle(n5, n6, n3 + this.v2.x * n2, n4 - this.v2.y * n2, n7, n8);
        graphics.fillTriangle(n5, n6, n3 + this.v4.x * n2, n4 - this.v4.y * n2, n7, n8);
    }

    public void paintXZ(Graphics graphics, int n, int n2) throws  {
        graphics.setColor(n);
        int n3 = Camera.w / 2 + Camera.x0;
        int n4 = Camera.h / 2 - Camera.z0;
        int n5 = n3 + this.v1.x * n2;
        int n6 = n4 - this.v1.z * n2;
        int n7 = n3 + this.v3.x * n2;
        int n8 = n4 - this.v3.z * n2;
        graphics.fillTriangle(n5, n6, n3 + this.v2.x * n2, n4 - this.v2.z * n2, n7, n8);
        graphics.fillTriangle(n5, n6, n3 + this.v4.x * n2, n4 - this.v4.z * n2, n7, n8);
    }

    public void paintYZ(Graphics graphics, int n, int n2) throws  {
        graphics.setColor(n);
        int n3 = Camera.w / 2 + Camera.z0;
        int n4 = Camera.h / 2 - Camera.y0;
        int n5 = n3 + this.v1.z * n2;
        int n6 = n4 - this.v1.y * n2;
        int n7 = n3 + this.v3.z * n2;
        int n8 = n4 - this.v3.y * n2;
        graphics.fillTriangle(n5, n6, n3 + this.v2.z * n2, n4 - this.v2.y * n2, n7, n8);
        graphics.fillTriangle(n5, n6, n3 + this.v4.z * n2, n4 - this.v4.y * n2, n7, n8);
    }

    public Square(Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4, int n) throws  {
        this.v1 = vertex4;
        this.v2 = vertex2;
        this.v3 = vertex;
        this.color = n;
        float f = (this.v1.y - this.v2.y) * (this.v2.z - this.v3.z) - (this.v1.z - this.v2.z) * (this.v2.y - this.v3.y);
        float f2 = (this.v1.z - this.v2.z) * (this.v2.x - this.v3.x) - (this.v1.x - this.v2.x) * (this.v2.z - this.v3.z);
        float f3 = (this.v1.x - this.v2.x) * (this.v2.y - this.v3.y) - (this.v1.y - this.v2.y) * (this.v2.x - this.v3.x);
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        f = (float)((double)f / d);
        f2 = (float)((double)f2 / d);
        f3 = (float)((double)f3 / d);
        this.v1 = vertex4;
        this.v2 = vertex3;
        this.v3 = vertex2;
        float f4 = (this.v1.y - this.v2.y) * (this.v2.z - this.v3.z) - (this.v1.z - this.v2.z) * (this.v2.y - this.v3.y);
        float f5 = (this.v1.z - this.v2.z) * (this.v2.x - this.v3.x) - (this.v1.x - this.v2.x) * (this.v2.z - this.v3.z);
        float f6 = (this.v1.x - this.v2.x) * (this.v2.y - this.v3.y) - (this.v1.y - this.v2.y) * (this.v2.x - this.v3.x);
        d = Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        f4 = (float)((double)f4 / d);
        f5 = (float)((double)f5 / d);
        f6 = (float)((double)f6 / d);
        this.rnx = this.nx = (f + f4) / (float)2;
        this.rny = this.ny = (f2 + f5) / (float)2;
        this.rnz = this.nz = (f3 + f6) / (float)2;
        this.v1 = vertex;
        this.v2 = vertex2;
        this.v3 = vertex3;
        this.v4 = vertex4;
    }
}

