/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Triangle
extends Face {
    public Vertex v1;
    public Vertex v2;
    public Vertex v3;
    public float nx;
    public float ny;
    public float nz;
    public float rnx;
    public float rny;
    public float rnz;
    public float k;

    public void normal() throws  {
    }

    public int getS() throws  {
        return (this.v1.zc + this.v2.zc + this.v3.zc) / 3;
    }

    public int getX() throws  {
        return (this.v1.xc + this.v2.xc + this.v3.xc) / 3;
    }

    public int getY() throws  {
        return (this.v1.yc + this.v2.yc + this.v3.yc) / 3;
    }

    public void paint(Graphics graphics) throws  {
        int n = this.color >> 16 & 0xFF;
        int n2 = this.color >> 8 & 0xFF;
        int n3 = this.color & 0xFF;
        n = (int)((float)n * -this.k);
        n2 = (int)((float)n2 * -this.k);
        n3 = (int)((float)n3 * -this.k);
        int n4 = n << 16 | n2 << 8 | n3;
        this.paint(graphics, n4);
    }

    public boolean topaint() throws  {
        boolean bl = true;
        if (this.v1.zc < 0 || this.v2.zc < 0 || this.v3.zc < 0) {
            bl = false;
        }
        if (this.v1.zc > Camera.limit && this.v2.zc > Camera.limit && this.v3.zc > Camera.limit) {
            bl = false;
        }
        if (this.v1.sx < 0 && this.v2.sx < 0 && this.v3.sx < 0) {
            bl = false;
        }
        if (this.v1.sx > Camera.w && this.v2.sx > Camera.w && this.v3.sx > Camera.w) {
            bl = false;
        }
        if (this.v1.sy < 0 && this.v2.sy < 0 && this.v3.sy < 0) {
            bl = false;
        }
        if (this.v1.sy > Camera.h && this.v2.sy > Camera.h && this.v3.sy > Camera.h) {
            bl = false;
        }
        return bl;
    }

    public void paint(Graphics graphics, int n) throws  {
        graphics.setColor(n);
        graphics.fillTriangle(this.v1.sx, this.v1.sy, this.v2.sx, this.v2.sy, this.v3.sx, this.v3.sy);
    }

    public void move(int n, int n2, int n3) throws  {
        this.v1.move(n, n2, n3);
        this.v2.move(n, n2, n3);
        this.v3.move(n, n2, n3);
    }

    public void setMatrix(Matrix3D matrix3D) throws  {
        this.v1.setMatrix(matrix3D);
        this.v2.setMatrix(matrix3D);
        this.v3.setMatrix(matrix3D);
        this.rnx = this.nx * matrix3D.xx + this.ny * matrix3D.xy + this.nz * matrix3D.xz;
        this.rny = this.nx * matrix3D.yx + this.ny * matrix3D.yy + this.nz * matrix3D.yz;
        this.k = this.rnz = this.nx * matrix3D.zx + this.ny * matrix3D.zy + this.nz * matrix3D.zz;
        if (!(this.k <= 0.0f)) {
            this.k = -this.k;
        }
        if (this.k < (float)-1) {
            this.k = -1;
        }
    }

    public void paintXY(Graphics graphics, int n) throws  {
        this.paintXY(graphics, this.color, n);
    }

    public void paintXZ(Graphics graphics, int n) throws  {
        this.paintXZ(graphics, this.color, n);
    }

    public void paintYZ(Graphics graphics, int n) throws  {
        this.paintYZ(graphics, this.color, n);
    }

    public void paintXY(Graphics graphics, int n, int n2) throws  {
        graphics.setColor(n);
        graphics.fillTriangle(Camera.w / 2 + Camera.x0 + this.v1.x * n2, Camera.h / 2 - Camera.y0 - this.v1.y * n2, Camera.w / 2 + Camera.x0 + this.v2.x * n2, Camera.h / 2 - Camera.y0 - this.v2.y * n2, Camera.w / 2 + Camera.x0 + this.v3.x * n2, Camera.h / 2 - Camera.y0 - this.v3.y * n2);
    }

    public void paintXZ(Graphics graphics, int n, int n2) throws  {
        graphics.setColor(n);
        graphics.fillTriangle(Camera.w / 2 + Camera.x0 + this.v1.x * n2, Camera.h / 2 - Camera.z0 - this.v1.z * n2, Camera.w / 2 + Camera.x0 + this.v2.x * n2, Camera.h / 2 - Camera.z0 - this.v2.z * n2, Camera.w / 2 + Camera.x0 + this.v3.x * n2, Camera.h / 2 - Camera.z0 - this.v3.z * n2);
    }

    public void paintYZ(Graphics graphics, int n, int n2) throws  {
        graphics.setColor(n);
        graphics.fillTriangle(Camera.w / 2 + Camera.z0 + this.v1.z * n2, Camera.h / 2 - Camera.y0 - this.v1.y * n2, Camera.w / 2 + Camera.z0 + this.v2.z * n2, Camera.h / 2 - Camera.y0 - this.v2.y * n2, Camera.w / 2 + Camera.z0 + this.v3.z * n2, Camera.h / 2 - Camera.y0 - this.v3.y * n2);
    }

    public void soequal() throws  {
        this.v1.soequal();
        this.v2.soequal();
        this.v3.soequal();
        this.nx = this.rnx;
        this.ny = this.rny;
        this.nz = this.rnz;
    }

    public boolean checkCoor(int n, int n2, int n3) throws  {
        if (n == this.v1.x && n2 == this.v1.y && n3 == this.v1.z) {
            return true;
        }
        if (n == this.v2.x && n2 == this.v2.y && n3 == this.v2.z) {
            return true;
        }
        return n == this.v3.x && n2 == this.v3.y && n3 == this.v3.z;
    }

    public Triangle(Vertex vertex, Vertex vertex2, Vertex vertex3, int n) throws  {
        this.v1 = vertex;
        this.v2 = vertex2;
        this.v3 = vertex3;
        this.color = n;
        float f = (this.v1.y - this.v2.y) * (this.v2.z - this.v3.z) - (this.v1.z - this.v2.z) * (this.v2.y - this.v3.y);
        float f2 = (this.v1.z - this.v2.z) * (this.v2.x - this.v3.x) - (this.v1.x - this.v2.x) * (this.v2.z - this.v3.z);
        float f3 = (this.v1.x - this.v2.x) * (this.v2.y - this.v3.y) - (this.v1.y - this.v2.y) * (this.v2.x - this.v3.x);
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        f = (float)((double)f / d);
        f2 = (float)((double)f2 / d);
        f3 = (float)((double)f3 / d);
        this.rnx = this.nx = f;
        this.rny = this.ny = f2;
        this.rnz = this.nz = f3;
    }
}

