/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class FileWatcher
implements CommandListener,
Runnable {
    public static final Command OK_COMMAND = new Command("Ok", 4, 1);
    public static final Command SUBDIR_COMMAND = new Command("\u0412\u0432\u0435\u0440\u0445", 2, 2);
    public static final Image FOLDER_IMAGE = FileWatcher.loadImage("/dir.png");
    public static final Image UNKNOWN_IMAGE = FileWatcher.loadImage("/unk.png");
    public static final Image TXT_IMAGE = FileWatcher.loadImage("/gif.png");
    public static final String STORE_NAME = "last_path";
    private Vector indexes = new Vector();
    private RecordStore store;
    private Display display;
    private Runnable exit;
    private String path;
    private String file;
    private String message;
    private List list;
    private Alert error;
    private int currentIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileWatcher(Display initDisplay) {
        this.display = initDisplay;
        this.error = new Alert("\u0423\u043f\u0441!....", "", null, AlertType.ERROR);
        this.error.addCommand(OK_COMMAND);
        this.error.setCommandListener((CommandListener)this);
        try {
            this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            if (this.store.getNumRecords() > 0) {
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.store.getRecord(1)));
                this.indexes.removeAllElements();
                this.path = input.readUTF();
                int iCount = input.readInt();
                for (int index = 0; index < iCount; ++index) {
                    this.indexes.addElement(new Integer(input.readInt()));
                }
                this.currentIndex = input.readInt();
            }
        }
        catch (RecordStoreException exception) {
            this.message = exception.getMessage();
            this.message = "\u041e\u0448\u0438\u0431\u043a\u0430\n" + "code.Part : " + this.getClass().getName() + "\n" + ((Object)((Object)exception)).getClass().getName() + (this.message != null ? " : " + this.message : "");
        }
        catch (IOException exception) {
            System.out.println("warning! an i/o exception has been ocurred while reading filewatcher settings");
        }
        finally {
            if (this.store != null) {
                try {
                    this.store.closeRecordStore();
                }
                catch (RecordStoreException exception0) {}
            }
            this.store = null;
        }
    }

    public void setExitAction(Runnable runnable) {
        this.exit = runnable;
    }

    public String getFileName() {
        return this.file;
    }

    public void showWatcher() {
        new Thread(this).start();
    }

    public void run() {
        this.showWatcherThis();
    }

    private void showWatcherThis() {
        if (this.path != null && !this.path.endsWith("/")) {
            this.file = this.path;
            this.openChild(null);
            if (this.exit != null) {
                this.exit.run();
            }
            return;
        }
        this.file = null;
        if (this.list == null) {
            this.list = this.buildList();
            if (this.currentIndex >= 0) {
                try {
                    this.list.setSelectedIndex(this.currentIndex, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.message == null) {
            this.display.setCurrent((Displayable)this.list);
        } else {
            this.error.setString(this.message);
            this.message = null;
            this.display.setCurrent(this.error, (Displayable)this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List buildList() {
        Object[] files = null;
        try {
            Class.forName("javax.microedition.io.file.FileConnection");
            Vector vector = new Vector();
            Enumeration enumeration = null;
            if (this.path == null || this.path.length() == 0) {
                enumeration = FileSystemRegistry.listRoots();
            } else {
                FileConnection fileConnection = null;
                try {
                    fileConnection = (FileConnection)Connector.open((String)("file:///" + this.path));
                    enumeration = fileConnection.list("*", true);
                }
                catch (Exception exception) {
                    this.path = null;
                    enumeration = FileSystemRegistry.listRoots();
                }
                finally {
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
            }
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
            }
            files = new String[vector.size()];
            vector.copyInto(files);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int dist = files.length >> 1; dist > 0; dist >>= 1) {
            for (int iindex = dist; iindex < files.length; ++iindex) {
                int jindex;
                void element = files[jindex];
                for (jindex = iindex; jindex >= dist && this.compareNames((String)files[jindex - dist], (String)element) > 0; jindex -= dist) {
                    files[jindex] = files[jindex - dist];
                }
                files[jindex] = element;
            }
        }
        Image[] images = new Image[files.length];
        for (int index = 0; index < images.length; ++index) {
            images[index] = files[index].endsWith("/") ? FOLDER_IMAGE : (((String)files[index]).endsWith(".gif") || ((String)files[index]).endsWith(".GIF") ? TXT_IMAGE : UNKNOWN_IMAGE);
        }
        List build = new List("\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432", 3, (String[])files, images);
        build.addCommand(SUBDIR_COMMAND);
        build.setCommandListener((CommandListener)this);
        return build;
    }

    private int compareNames(String name1, String name2) {
        if (name1.endsWith("/")) {
            if (name2.endsWith("/")) {
                return name1.compareTo(name2);
            }
            return -1;
        }
        if (name2.endsWith("/")) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    public boolean openChild(String name) {
        if (name == null) {
            if (this.path == null || this.path.length() == 0) {
                return false;
            }
            int index = this.path.lastIndexOf(47, this.path.length() - 2);
            if (index < 0) {
                this.path = null;
                return true;
            }
            this.path = this.path.substring(0, index + 1);
            return true;
        }
        this.path = this.path == null ? name : this.path + name;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unalloc() {
        if (this.list != null) {
            this.currentIndex = this.list.getSelectedIndex();
        }
        try {
            try {
                RecordStore.deleteRecordStore((String)STORE_NAME);
            }
            catch (RecordStoreException exception) {
                // empty catch block
            }
            this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            if (this.path != null) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                DataOutputStream doutput = new DataOutputStream(output);
                doutput.writeUTF(this.path);
                doutput.writeInt(this.indexes.size());
                for (int index = 0; index < this.indexes.size(); ++index) {
                    doutput.writeInt((Integer)this.indexes.elementAt(index));
                }
                doutput.writeInt(this.currentIndex);
                byte[] data = output.toByteArray();
                this.store.addRecord(data, 0, data.length);
            }
        }
        catch (RecordStoreException exception) {
            this.message = exception.getMessage();
            this.message = "\u041e\u0448\u0438\u0431\u043a\u0430\n" + "code.Part : " + this.getClass().getName() + ((Object)((Object)exception)).getClass().getName() + (this.message != null ? " : " + this.message : "");
        }
        catch (IOException exception) {
            System.out.println("warning! an i/o exception has been ocurred while writing filewatcher settings");
        }
        finally {
            if (this.store != null) {
                try {
                    this.store.closeRecordStore();
                }
                catch (RecordStoreException exception0) {}
            }
            this.store = null;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.list) {
            if (command == List.SELECT_COMMAND) {
                int selected = this.list.getSelectedIndex();
                if (selected >= 0 && selected < this.list.size() && this.openChild(this.list.getString(selected))) {
                    this.storeIndex(selected);
                    if (this.path.endsWith("/")) {
                        this.list = null;
                    }
                    this.currentIndex = -1;
                    this.showWatcher();
                }
            } else if (command == SUBDIR_COMMAND) {
                if (this.path == null) {
                    if (this.exit != null) {
                        this.exit.run();
                    }
                } else if (this.openChild(null)) {
                    this.list = null;
                    this.currentIndex = this.restoreIndex();
                    this.showWatcher();
                }
            }
        }
        if (displayable == this.error && command == OK_COMMAND) {
            if (this.list != null) {
                this.currentIndex = -1;
                this.showWatcher();
            } else if (this.exit != null) {
                this.exit.run();
            }
        }
    }

    private void storeIndex(int index) {
        this.indexes.addElement(new Integer(index));
    }

    private int restoreIndex() {
        if (this.indexes.size() == 0) {
            return 0;
        }
        int index = (Integer)this.indexes.lastElement();
        this.indexes.setSize(this.indexes.size() - 1);
        return index;
    }

    private static Image loadImage(String resource) {
        Image image = null;
        try {
            image = Image.createImage((String)resource);
        }
        catch (Exception exception) {
            image = Image.createImage((int)1, (int)1);
        }
        return image;
    }
}

