/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.bluetooth;

import de.joergjahnke.common.bluetooth.BluetoothDevice;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public abstract class BluetoothClient
extends BluetoothDevice
implements DiscoveryListener {
    public static final int DEFAULT_TIMEOUT = 30000;
    private int timeout = 30000;
    private final Vector devices = new Vector();
    protected final DiscoveryAgent agent = this.local.getDiscoveryAgent();
    protected ServiceRecord serviceRecord = null;

    public BluetoothClient(String serviceName) throws BluetoothStateException {
        super(serviceName);
    }

    public BluetoothClient(int uuid, boolean isShortUUID) throws BluetoothStateException {
        super(uuid, isShortUUID);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector searchDevices() throws BluetoothStateException {
        this.devices.removeAllElements();
        DiscoveryAgent discoveryAgent = this.agent;
        synchronized (discoveryAgent) {
            if (!this.agent.startInquiry(10390323, (DiscoveryListener)this)) {
                throw new BluetoothStateException("Access code not supported!");
            }
            try {
                this.agent.wait(this.getTimeout(), 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.devices;
    }

    protected synchronized Hashtable searchDevices(UUID[] uuids) throws IOException {
        Hashtable<RemoteDevice, ServiceRecord> result = new Hashtable<RemoteDevice, ServiceRecord>();
        this.searchDevices();
        for (int i = 0; i < this.devices.size(); ++i) {
            RemoteDevice device = (RemoteDevice)this.devices.elementAt(i);
            ServiceRecord service = this.searchServices(device, uuids);
            if (service == null) continue;
            result.put(device, service);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ServiceRecord searchServices(RemoteDevice btDevice, UUID[] uuids) throws IOException {
        this.serviceRecord = null;
        DiscoveryAgent discoveryAgent = this.agent;
        synchronized (discoveryAgent) {
            this.agent.searchServices(null, uuids, btDevice, (DiscoveryListener)this);
            try {
                this.agent.wait(this.getTimeout(), 0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return this.serviceRecord;
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        this.devices.addElement(btDevice);
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        try {
            this.serviceRecord = servRecord[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        DiscoveryAgent discoveryAgent = this.agent;
        synchronized (discoveryAgent) {
            this.agent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        DiscoveryAgent discoveryAgent = this.agent;
        synchronized (discoveryAgent) {
            this.agent.notifyAll();
        }
    }
}

