/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.jme.LocalizationSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class FormattedTextForm
extends Form {
    private final MIDlet midlet;

    public FormattedTextForm(MIDlet midlet, String title, InputStream is) throws IOException {
        super(title);
        int c;
        this.midlet = midlet;
        Stack<Character> modes = new Stack<Character>();
        StringBuffer buffer = new StringBuffer();
        block5: while ((c = is.read()) >= 0) {
            switch ((char)c) {
                case '{': {
                    if (buffer.length() > 0) {
                        this.append((Item)this.createStringItem(buffer, modes));
                    }
                    buffer = new StringBuffer();
                    modes.push(new Character((char)is.read()));
                    continue block5;
                }
                case '}': {
                    if (buffer.length() > 0) {
                        this.append((Item)this.createStringItem(buffer, modes));
                    }
                    buffer = new StringBuffer();
                    modes.pop();
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
            }
            buffer.append((char)c);
        }
        if (buffer.length() > 0) {
            this.append((Item)this.createStringItem(buffer, modes));
        }
    }

    private StringItem createStringItem(StringBuffer buffer, Vector formatting) {
        int style = 0;
        int appearance = 0;
        int size = 0;
        int face = 0;
        Enumeration en = formatting.elements();
        while (en.hasMoreElements()) {
            Character c = (Character)en.nextElement();
            switch (c.charValue()) {
                case 'b': {
                    style = 1;
                    break;
                }
                case 'i': {
                    style = 2;
                    break;
                }
                case 'u': {
                    style = 4;
                    break;
                }
                case 'h': {
                    appearance = 1;
                    break;
                }
                case '-': {
                    size = size == 16 ? 0 : 8;
                    break;
                }
                case '+': {
                    size = size == 8 ? 0 : 16;
                    break;
                }
                case 'm': {
                    face = 32;
                    break;
                }
                case 'p': {
                    style = 64;
                }
            }
        }
        StringItem stringItem = new StringItem(null, LocalizationSupport._convertString(buffer.toString()), appearance);
        stringItem.setFont(Font.getFont((int)face, (int)style, (int)size));
        if (appearance == 1) {
            Command browseCommand = new Command(LocalizationSupport.getMessage("Browse"), 8, 2);
            stringItem.addCommand(browseCommand);
            stringItem.setItemCommandListener(new ItemCommandListener(){

                public void commandAction(Command c, Item item) {
                    try {
                        FormattedTextForm.this.midlet.platformRequest(((StringItem)item).getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return stringItem;
    }
}

