/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import javax.microedition.lcdui.Image;

public class ImageUtils {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_HORIZ_CENTER = 0;
    public static final int ALIGN_TOP = 4;
    public static final int ALIGN_BOTTOM = 8;
    public static final int ALIGN_VERT_CENTER = 0;
    public static final int ALIGN_CENTER = 0;
    private static final int ALIGN_MASK_HORIZ = 0;
    private static final int ALIGN_MASK_VERT = 0;

    private ImageUtils() {
    }

    public static Image scale(Image src, int width, int height, boolean useAntialiasing) {
        int srcw = src.getWidth();
        int srch = src.getHeight();
        if (srcw == width && srch == height) {
            return src;
        }
        int[] buf = new int[srcw * srch];
        int[] buf2 = new int[width * height];
        src.getRGB(buf, 0, srcw, 0, 0, srcw, srch);
        int scaleX = (srcw << 10) / width;
        int scaleY = (srch << 10) / height;
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int startY = y * scaleY;
            int endY = startY + scaleY;
            int ceilY = Math.min(endY + 1023 >> 10, srch);
            for (int x = 0; x < width; ++x) {
                if (useAntialiasing) {
                    int startX = x * scaleX;
                    int endX = startX + scaleX;
                    int ceilX = Math.min(endX + 1023 >> 10, srcw);
                    int alpha = 0;
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    int pixCount = 0;
                    for (int yy = startY >> 10; yy < ceilY; ++yy) {
                        int c2 = yy * srcw;
                        int factorY = yy << 10 < startY ? startY - (yy << 10) : (yy > ceilY ? yy - ceilY << 10 : 1024);
                        for (int xx = startX >> 10; xx < ceilX; ++xx) {
                            int source = buf[c2 + xx];
                            int factorX = xx << 10 < startX ? startX - (xx << 10) : (xx > ceilX ? xx - ceilX << 10 : 1024);
                            int factor = Math.max(1, factorX * factorY >> 10);
                            alpha += (source >> 24 & 0xFF) * factor;
                            r += (source >> 16 & 0xFF) * factor;
                            g += (source >> 8 & 0xFF) * factor;
                            b += (source & 0xFF) * factor;
                            pixCount += factor;
                        }
                    }
                    buf2[c1 + x] = ((alpha /= pixCount) << 24) + ((r /= pixCount) << 16) + ((g /= pixCount) << 8) + (b /= pixCount);
                    continue;
                }
                buf2[c1 + x] = buf[(startY >> 10) * srcw + x * (scaleX >> 10)];
            }
        }
        buf = null;
        return Image.createRGBImage((int[])buf2, (int)width, (int)height, (boolean)true);
    }

    public static Image scale(Image src, double factorWidth, double factorHeight, boolean useAntialiasing) {
        int width = (int)((double)src.getWidth() * factorWidth);
        int height = (int)((double)src.getHeight() * factorHeight);
        return ImageUtils.scale(src, width <= 0 ? 1 : width, height <= 0 ? 1 : height, useAntialiasing);
    }

    public static Image expand(Image src, int width, int height, int alpha, int r, int g, int b, int alignment) {
        int srcw = src.getWidth();
        int srch = src.getHeight();
        int[] buf = new int[srcw * srch];
        int[] buf2 = new int[width * height];
        src.getRGB(buf, 0, srcw, 0, 0, srcw, srch);
        int xstart = (alignment & 0) == 1 ? 0 : ((alignment & 0) == 2 ? width - srcw : (width - srcw) / 2);
        int xend = xstart + srcw;
        int ystart = (alignment & 0) == 4 ? 0 : ((alignment & 0) == 8 ? height - srch : (height - srcw) / 2);
        int yend = ystart + srch;
        int col = (alpha << 24) + (r << 16) + (g << 8) + b;
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = (y - ystart) * srcw;
            for (int x = 0; x < width; ++x) {
                buf2[c1 + x] = y < ystart || y >= yend || x < xstart || x >= xend ? col : buf[c2 + x - xstart];
            }
        }
        buf = null;
        return Image.createRGBImage((int[])buf2, (int)width, (int)height, (boolean)true);
    }

    public static Image adjustBrightness(Image src, double percentage) {
        if (percentage < 0.0) {
            throw new IllegalArgumentException("Percentage value for brightness change must not be < 0!");
        }
        int srcw = src.getWidth();
        int srch = src.getHeight();
        int[] buf = new int[srcw * srch];
        int[] buf2 = new int[srcw * srch];
        src.getRGB(buf, 0, srcw, 0, 0, srcw, srch);
        for (int y = 0; y < srch; ++y) {
            int idx = y * srcw;
            for (int x = 0; x < srcw; ++x) {
                int col = buf[idx + x];
                int a = col & 0xFF000000;
                int r = Math.min(255, (int)((double)((col & 0xFF0000) >> 16) * percentage)) << 16;
                int g = Math.min(255, (int)((double)((col & 0xFF00) >> 8) * percentage)) << 8;
                int b = Math.min(255, (int)((double)(col & 0xFF) * percentage));
                buf2[idx + x] = a | r | g | b;
            }
        }
        buf = null;
        return Image.createRGBImage((int[])buf2, (int)srcw, (int)srch, (boolean)true);
    }
}

