/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Settings {
    final RecordStore db;
    final Hashtable nameRecordIDMap = new Hashtable();

    public Settings(String dbName) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        this.db = RecordStore.openRecordStore((String)dbName, (boolean)true);
        Vector<Integer> ids = new Vector<Integer>();
        RecordEnumeration en = this.db.enumerateRecords(null, null, false);
        while (en.hasNextElement()) {
            ids.addElement(new Integer(en.nextRecordId()));
        }
        for (int i = 0; i < ids.size(); ++i) {
            int id = (Integer)ids.elementAt(i);
            byte[] bytes = this.db.getRecord(id);
            int hashCode = this.toInt(bytes);
            this.nameRecordIDMap.put(new Integer(hashCode), new Integer(id));
        }
    }

    public void close() throws RecordStoreNotOpenException, RecordStoreException {
        this.db.closeRecordStore();
    }

    public int getInteger(String key) {
        return this.toInt(this.getRecordRawData(key));
    }

    public int getInteger(String key, int defaultValue) {
        try {
            return this.getInteger(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setInteger(String key, int value) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        this.setRecordRawData(key, this.toBytes(value));
    }

    public boolean getBoolean(String key) {
        return this.getRecordRawData(key)[0] == 1;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setBoolean(String key, boolean value) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        byte[] bytes = new byte[]{(byte)(value ? 1 : 0)};
        this.setRecordRawData(key, bytes);
    }

    public String getString(String key) {
        return new String(this.getRecordRawData(key));
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getString(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setString(String key, String value) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        this.setRecordRawData(key, value.getBytes());
    }

    public boolean exists(String key) {
        return this.nameRecordIDMap.containsKey(new Integer(key.hashCode()));
    }

    public void remove(String key) {
        Integer hashCode = new Integer(key.hashCode());
        Integer recordId = (Integer)this.nameRecordIDMap.get(hashCode);
        try {
            this.db.deleteRecord(recordId.intValue());
            this.nameRecordIDMap.remove(hashCode);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Key '" + key + "' could not be found in storage!\n The original exception and message was " + e.getClass() + ": " + e.getMessage());
        }
    }

    private final int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result += bytes[i] >= 0 ? bytes[i] : 256 + bytes[i];
        }
        return result;
    }

    private final byte[] toBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return bytes;
    }

    private byte[] getRecordRawData(String key) {
        Integer recordId = (Integer)this.nameRecordIDMap.get(new Integer(key.hashCode()));
        try {
            byte[] raw = this.db.getRecord(recordId.intValue());
            byte[] bytes = new byte[raw.length - 4];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = raw[i + 4];
            }
            return bytes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Key '" + key + "' could not be read from storage!\n The original exception and message was " + e.getClass() + ": " + e.getMessage());
        }
    }

    private void setRecordRawData(String key, byte[] bytes) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        byte[] raw = new byte[bytes.length + 4];
        int hashCode = key.hashCode();
        raw[0] = (byte)(hashCode >>> 24);
        raw[1] = (byte)(hashCode >> 16);
        raw[2] = (byte)(hashCode >> 8);
        raw[3] = (byte)hashCode;
        for (int i = 0; i < bytes.length; ++i) {
            raw[i + 4] = bytes[i];
        }
        if (this.nameRecordIDMap.containsKey(new Integer(hashCode))) {
            this.db.setRecord(((Integer)this.nameRecordIDMap.get(new Integer(hashCode))).intValue(), raw, 0, raw.length);
        } else {
            int id = this.db.addRecord(raw, 0, raw.length);
            this.nameRecordIDMap.put(new Integer(hashCode), new Integer(id));
        }
    }
}

