/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.gameboy.core.SoundChannel;
import de.joergjahnke.gameboy.core.SoundChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class WhiteNoiseChannel
extends SoundChannel {
    private static final boolean[] randoms = new boolean[32768];
    private int envelopeSweeps;
    private int envelopeSweepsLeft;
    private int envelopeDirection = -1;
    private boolean isSmallStepWidth;

    public WhiteNoiseChannel(SoundChip sound) {
        super(sound);
    }

    public void setVolumeEnvelope(int initialVolume, boolean increase, int envelopeSweeps) {
        this.volume = initialVolume;
        this.envelopeSweeps = this.envelopeSweepsLeft = envelopeSweeps * 128 >> 6;
        this.envelopeDirection = increase ? 1 : -1;
    }

    public void setPolynomialCounter(int shift, boolean isSmallStepWidth, int dividingRatio) {
        this.isSmallStepWidth = isSmallStepWidth;
        double divider = dividingRatio == 0 ? 0.5 : (double)dividingRatio;
        this.frequency = (int)(524288.0 / divider) >> shift + 1;
    }

    public void update() {
        --this.length;
        if (this.envelopeSweeps > 0) {
            --this.envelopeSweepsLeft;
            if (this.envelopeSweepsLeft <= 0) {
                this.volume = Math.min(15, Math.max(0, this.volume + this.envelopeDirection));
                this.envelopeSweepsLeft = this.envelopeSweeps;
            }
        }
    }

    public void mix(byte[] buffer) {
        int sampleRate = this.sound.getSampleRate();
        boolean isLeftActive = this.isTerminalActive(0);
        boolean isRightActive = this.isTerminalActive(1);
        int mod = sampleRate * (this.isSmallStepWidth ? 128 : 32768);
        int to = buffer.length;
        for (int i = 0; i < to; i += 2) {
            int sample;
            int index = this.audioIndex / sampleRate;
            int n = sample = randoms[index] ? this.volume << 1 : -this.volume << 1;
            if (isLeftActive) {
                int n2 = i + 0;
                buffer[n2] = (byte)(buffer[n2] + sample);
            }
            if (isRightActive) {
                int n3 = i + 1;
                buffer[n3] = (byte)(buffer[n3] + sample);
            }
            this.audioIndex += this.frequency;
            this.audioIndex %= mod;
        }
    }

    public final int getFrequency() {
        return this.startFrequency % 12000;
    }

    public final int getVolume() {
        return this.hasSound() && this.length > 0 ? this.startVolume * 100 / 15 : 0;
    }

    public final int getType() {
        return 127;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.envelopeSweeps);
        out.writeInt(this.envelopeSweepsLeft);
        out.writeInt(this.envelopeDirection);
        out.writeBoolean(this.isSmallStepWidth);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.envelopeSweeps = in.readInt();
        this.envelopeSweepsLeft = in.readInt();
        this.envelopeDirection = in.readInt();
        this.isSmallStepWidth = in.readBoolean();
    }

    static {
        Random rand = new Random();
        for (int i = 0; i < randoms.length; ++i) {
            WhiteNoiseChannel.randoms[i] = (rand.nextInt() & 1) == 1;
        }
    }
}

