/*
 * Decompiled with CFR 0.152.
 */
public abstract class Em6502 {
    public byte[] mem = null;
    public int A;
    public int X;
    public int Y;
    public int P;
    public int S;
    public int PC;
    private int easp1;
    private int easp2;
    private int operandAddress;
    private int opcode;
    private int operand;
    private int result;
    private int NZFlags;
    public int clock;
    public static final int FLAG_C = 1;
    public static final int FLAG_Z = 2;
    public static final int FLAG_I = 4;
    public static final int FLAG_D = 8;
    public static final int FLAG_B = 16;
    public static final int FLAG_V = 64;
    public static final int FLAG_N = 128;
    private int exceptionRegister = 1;
    public static final int SIG_6502_RESET = 1;
    public static final int SIG_6502_NMI = 2;
    public static final int SIG_6502_IRQ = 4;
    private int pendingIRQ;
    private int[] BCDTableAdd;
    private int[] BCDTableSub;

    public abstract int memoryRead(int var1);

    public abstract void memoryWrite(int var1, int var2);

    public void Em6502() {
    }

    public void initBCD() {
        this.BCDTableAdd = new int[512];
        this.BCDTableSub = new int[512];
        for (int i = 0; i < 512; ++i) {
            this.BCDTableAdd[i] = (i & 0xF) <= 9 ? i : i + 6;
            int n = i;
            this.BCDTableAdd[n] = this.BCDTableAdd[n] + ((this.BCDTableAdd[i] & 0xF0) <= 144 ? 0 : 96);
            if (this.BCDTableAdd[i] > 511) {
                int n2 = i;
                this.BCDTableAdd[n2] = this.BCDTableAdd[n2] - 256;
            }
            this.BCDTableSub[i] = (i & 0xF) <= 9 ? i : i - 6;
            int n3 = i;
            this.BCDTableSub[n3] = this.BCDTableSub[n3] - ((this.BCDTableSub[i] & 0xF0) <= 144 ? 0 : 96);
        }
    }

    private final int zeroPageRead(int n) {
        return this.mem[n] & 0xFF;
    }

    private final void zeroPageWrite(int n, int n2) {
        this.mem[n] = (byte)n2;
    }

    private final int pop() {
        ++this.S;
        this.S &= 0xFF;
        return this.mem[this.S | 0x100] & 0xFF;
    }

    private final void push(int n) {
        this.mem[this.S | 0x100] = (byte)n;
        --this.S;
        this.S &= 0xFF;
    }

    private final void setN(boolean bl) {
        this.P = bl ? (this.P |= 0x80) : (this.P &= 0xFFFFFF7F);
    }

    private final void setV(boolean bl) {
        this.P = bl ? (this.P |= 0x40) : (this.P &= 0xFFFFFFBF);
    }

    private final void setB(boolean bl) {
        this.P = bl ? (this.P |= 0x10) : (this.P &= 0xFFFFFFEF);
    }

    private final void setD(boolean bl) {
        this.P = bl ? (this.P |= 8) : (this.P &= 0xFFFFFFF7);
    }

    private final void setI(boolean bl) {
        this.P = bl ? (this.P |= 4) : (this.P &= 0xFFFFFFFB);
    }

    private final void setZ(boolean bl) {
        this.P = bl ? (this.P |= 2) : (this.P &= 0xFFFFFFFD);
    }

    private final void setC(boolean bl) {
        this.P = bl ? (this.P |= 1) : (this.P &= 0xFFFFFFFE);
    }

    private final boolean getN() {
        return (this.P & 0x80) != 0;
    }

    private final boolean getV() {
        return (this.P & 0x40) != 0;
    }

    private final boolean getB() {
        return (this.P & 0x10) != 0;
    }

    private final boolean getD() {
        return (this.P & 8) != 0;
    }

    private final boolean getI() {
        return (this.P & 4) != 0;
    }

    private final boolean getZ() {
        return (this.P & 2) != 0;
    }

    private final boolean getC() {
        return (this.P & 1) != 0;
    }

    private final boolean getFN() {
        return (this.NZFlags & 0x280) != 0;
    }

    private final boolean getFNotN() {
        return (this.NZFlags & 0x280) == 0;
    }

    private final boolean getFZ() {
        return (this.NZFlags & 0xFF) == 0;
    }

    private final boolean getFNotZ() {
        return (this.NZFlags & 0xFF) != 0;
    }

    private final void setFNZ(boolean bl, boolean bl2) {
        this.NZFlags = (bl ? 512 : 0) | (bl2 ? 0 : 1);
    }

    private final boolean getFC() {
        return this.result >> 8 != 0;
    }

    private final boolean getFNotC() {
        return this.result >> 8 == 0;
    }

    private final int getFC_() {
        return this.result >> 8;
    }

    private final void setFC(boolean bl) {
        this.result = bl ? 256 : 0;
    }

    private final void CheckCross(int n, int n2) {
        if (((n + n2 ^ n) & 0xFF00) != 0) {
            ++this.clock;
        }
    }

    private final int eaimm() {
        this.easp1 = this.memoryRead(this.PC);
        ++this.PC;
        return this.easp1;
    }

    private final int eazp() {
        this.easp1 = this.memoryRead(this.PC);
        ++this.PC;
        return this.easp1;
    }

    private final int eazpx() {
        this.easp1 = this.memoryRead(this.PC) + this.X & 0xFF;
        ++this.PC;
        return this.easp1;
    }

    private final int eazpy() {
        this.easp1 = this.memoryRead(this.PC) + this.Y & 0xFF;
        ++this.PC;
        return this.easp1;
    }

    private final int eaabs() {
        this.easp1 = this.memoryRead(this.PC);
        ++this.PC;
        this.easp1 += this.memoryRead(this.PC) << 8;
        ++this.PC;
        return this.easp1;
    }

    private final int earel() {
        this.easp1 = (byte)this.memoryRead(this.PC);
        ++this.PC;
        return this.easp1;
    }

    private final int eaabsx() {
        return this.eaabs() + this.X;
    }

    private final int eaabsxNC() {
        return this.eaabs() + this.X;
    }

    private final int eaabsy() {
        return this.eaabs() + this.Y;
    }

    private final int eaabsyNC() {
        return this.eaabs() + this.Y;
    }

    private final int eaabsind() {
        this.easp1 = this.eaabs();
        this.easp2 = this.memoryRead(this.easp1);
        return this.easp2 + (this.memoryRead(this.easp1 + 1) << 8);
    }

    private final int eazpxind() {
        this.easp1 = this.eazpx();
        this.easp2 = this.zeroPageRead(this.easp1);
        return this.easp2 + (this.zeroPageRead(this.easp1 + 1 & 0xFF) << 8);
    }

    private final int eazpindy() {
        this.easp1 = this.eaimm();
        this.easp2 = this.zeroPageRead(this.easp1);
        return this.easp2 + (this.zeroPageRead(this.easp1 + 1 & 0xFF) << 8) + this.Y;
    }

    private final int eazpindyNC() {
        this.easp1 = this.eaimm();
        this.easp2 = this.zeroPageRead(this.easp1);
        return this.easp2 + (this.zeroPageRead(this.easp1 + 1 & 0xFF) << 8) + this.Y;
    }

    private final int eazpind() {
        this.easp1 = this.eazp();
        this.easp2 = this.zeroPageRead(this.easp1);
        return this.easp2 + (this.zeroPageRead(this.easp1 + 1 & 0xFF) << 8);
    }

    private final int eaabsxind() {
        this.easp1 = this.eaabs();
        this.easp2 = this.memoryRead(this.easp1);
        return this.easp2 + (this.memoryRead(this.easp1 + 1) << 8) + this.X;
    }

    private final void adcBCDAdjust() {
        if (this.getD()) {
            this.result = this.BCDTableAdd[this.result];
        }
    }

    private final void sbcBCDAdjust() {
        if (this.getD()) {
            this.result = this.BCDTableSub[this.result];
        }
    }

    private final void branch(int n) {
        this.PC += n;
        ++this.clock;
    }

    public void assertReset() {
        this.exceptionRegister |= 1;
    }

    protected void resetAssertion() {
    }

    void assertNMI() {
        this.exceptionRegister |= 2;
    }

    void assertIRQ() {
        this.exceptionRegister |= 4;
    }

    private final void executeInstruction() {
        this.opcode = this.memoryRead(this.PC);
        ++this.PC;
        switch (this.opcode) {
            case 105: {
                this.operand = this.eaimm();
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 2;
                break;
            }
            case 109: {
                this.operand = this.memoryRead(this.eaabs());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 101: {
                this.operand = this.zeroPageRead(this.eazp());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 3;
                break;
            }
            case 97: {
                this.operand = this.memoryRead(this.eazpxind());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 6;
                break;
            }
            case 113: {
                this.operandAddress = this.eazpindy();
                this.operand = this.memoryRead(this.operandAddress);
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 5;
                break;
            }
            case 117: {
                this.operandAddress = this.eazpx();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 125: {
                this.operand = this.memoryRead(this.eaabsx());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 121: {
                this.operand = this.memoryRead(this.eaabsy());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 41: {
                this.A &= this.eaimm();
                this.NZFlags = this.A;
                this.clock += 2;
                break;
            }
            case 45: {
                this.A &= this.memoryRead(this.eaabs());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 37: {
                this.A &= this.zeroPageRead(this.eazp());
                this.NZFlags = this.A;
                this.clock += 3;
                break;
            }
            case 33: {
                this.A &= this.memoryRead(this.eazpxind());
                this.NZFlags = this.A;
                this.clock += 6;
                break;
            }
            case 49: {
                this.A &= this.memoryRead(this.eazpindy());
                this.NZFlags = this.A;
                this.clock += 5;
                break;
            }
            case 53: {
                this.A &= this.zeroPageRead(this.eazpx());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 61: {
                this.A &= this.memoryRead(this.eaabsx());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 57: {
                this.A &= this.memoryRead(this.eaabsy());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 14: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1;
                this.memoryWrite(this.operandAddress, this.result);
                this.clock += 6;
                break;
            }
            case 6: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1;
                this.zeroPageWrite(this.operandAddress, this.result);
                this.clock += 5;
                break;
            }
            case 10: {
                this.result = this.A << 1;
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 2;
                break;
            }
            case 22: {
                this.operandAddress = this.eazpx();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1;
                this.zeroPageWrite(this.operandAddress, this.result);
                this.clock += 6;
                break;
            }
            case 30: {
                this.operandAddress = this.eaabsx();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1;
                this.memoryWrite(this.operandAddress, this.result);
                this.clock += 7;
                break;
            }
            case 144: {
                this.operand = this.earel();
                this.clock += 2;
                if (!this.getFNotC()) break;
                this.branch(this.operand);
                break;
            }
            case 176: {
                this.operand = this.earel();
                this.clock += 2;
                if (!this.getFC()) break;
                this.branch(this.operand);
                break;
            }
            case 240: {
                this.operand = this.earel();
                this.clock += 2;
                if (!this.getFZ()) break;
                this.branch(this.operand);
                break;
            }
            case 44: {
                this.operand = this.memoryRead(this.eaabs());
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.clock += 4;
                break;
            }
            case 36: {
                this.operand = this.zeroPageRead(this.eazp());
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.clock += 3;
                break;
            }
            case 48: {
                this.operand = this.earel();
                this.clock += 2;
                if (!this.getFN()) break;
                this.branch(this.operand);
                break;
            }
            case 208: {
                this.operand = this.earel();
                this.clock += 2;
                if (!this.getFNotZ()) break;
                this.branch(this.operand);
                break;
            }
            case 16: {
                this.operand = this.earel();
                this.clock += 2;
                if (!this.getFNotN()) break;
                this.branch(this.operand);
                break;
            }
            case 0: {
                this.push(this.PC >> 8);
                this.push(this.PC);
                this.setN(this.getFN());
                this.setZ(this.getFZ());
                this.setC(this.getFC());
                this.setB(true);
                this.push(this.P);
                this.setI(true);
                this.PC = this.memoryRead(65534);
                this.PC |= this.memoryRead(65535) << 8;
                this.clock += 7;
                break;
            }
            case 80: {
                this.operand = this.earel();
                this.clock += 2;
                if (this.getV()) break;
                this.branch(this.operand);
                break;
            }
            case 112: {
                this.operand = this.earel();
                this.clock += 2;
                if (!this.getV()) break;
                this.branch(this.operand);
                break;
            }
            case 24: {
                this.setFC(false);
                this.clock += 2;
                break;
            }
            case 216: {
                this.setD(false);
                this.clock += 2;
                break;
            }
            case 88: {
                this.setI(false);
                this.clock += 2;
                if (this.pendingIRQ <= 0) break;
                --this.pendingIRQ;
                this.assertIRQ();
                break;
            }
            case 184: {
                this.setV(false);
                this.clock += 2;
                break;
            }
            case 201: {
                this.NZFlags = this.result = 256 + this.A - this.eaimm();
                this.clock += 2;
                break;
            }
            case 205: {
                this.NZFlags = this.result = 256 + this.A - this.memoryRead(this.eaabs());
                this.clock += 4;
                break;
            }
            case 197: {
                this.NZFlags = this.result = 256 + this.A - this.zeroPageRead(this.eazp());
                this.clock += 3;
                break;
            }
            case 193: {
                this.NZFlags = this.result = 256 + this.A - this.memoryRead(this.eazpxind());
                this.clock += 6;
                break;
            }
            case 209: {
                this.NZFlags = this.result = 256 + this.A - this.memoryRead(this.eazpindy());
                this.clock += 5;
                break;
            }
            case 213: {
                this.NZFlags = this.result = 256 + this.A - this.zeroPageRead(this.eazpx());
                this.clock += 4;
                break;
            }
            case 221: {
                this.NZFlags = this.result = 256 + this.A - this.memoryRead(this.eaabsx());
                this.clock += 4;
                break;
            }
            case 217: {
                this.NZFlags = this.result = 256 + this.A - this.memoryRead(this.eaabsy());
                this.clock += 4;
                break;
            }
            case 224: {
                this.NZFlags = this.result = 256 + this.X - this.eaimm();
                this.clock += 2;
                break;
            }
            case 236: {
                this.NZFlags = this.result = 256 + this.X - this.memoryRead(this.eaabs());
                this.clock += 4;
                break;
            }
            case 228: {
                this.NZFlags = this.result = 256 + this.X - this.zeroPageRead(this.eazp());
                this.clock += 3;
                break;
            }
            case 192: {
                this.NZFlags = this.result = 256 + this.Y - this.eaimm();
                this.clock += 2;
                break;
            }
            case 204: {
                this.NZFlags = this.result = 256 + this.Y - this.memoryRead(this.eaabs());
                this.clock += 4;
                break;
            }
            case 196: {
                this.NZFlags = this.result = 256 + this.Y - this.zeroPageRead(this.eazp());
                this.clock += 3;
                break;
            }
            case 206: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.operand + 255;
                this.memoryWrite(this.operandAddress, this.NZFlags);
                this.clock += 6;
                break;
            }
            case 198: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.operand + 255;
                this.zeroPageWrite(this.operandAddress, this.NZFlags);
                this.clock += 5;
                break;
            }
            case 214: {
                this.operandAddress = this.eazpx();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.operand + 255;
                this.zeroPageWrite(this.operandAddress, this.NZFlags);
                this.clock += 6;
                break;
            }
            case 222: {
                this.operandAddress = this.eaabsx();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.operand + 255;
                this.memoryWrite(this.operandAddress, this.NZFlags);
                this.clock += 7;
                break;
            }
            case 202: {
                this.NZFlags = this.X + 255;
                this.X = this.NZFlags & 0xFF;
                this.clock += 2;
                break;
            }
            case 136: {
                this.NZFlags = this.Y + 255;
                this.Y = this.NZFlags & 0xFF;
                this.clock += 2;
                break;
            }
            case 73: {
                this.A ^= this.eaimm();
                this.NZFlags = this.A;
                this.clock += 2;
                break;
            }
            case 77: {
                this.A ^= this.memoryRead(this.eaabs());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 69: {
                this.A ^= this.zeroPageRead(this.eazp());
                this.NZFlags = this.A;
                this.clock += 3;
                break;
            }
            case 65: {
                this.A ^= this.memoryRead(this.eazpxind());
                this.NZFlags = this.A;
                this.clock += 6;
                break;
            }
            case 81: {
                this.A ^= this.memoryRead(this.eazpindy());
                this.NZFlags = this.A;
                this.clock += 5;
                break;
            }
            case 85: {
                this.A ^= this.zeroPageRead(this.eazpx());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 93: {
                this.A ^= this.memoryRead(this.eaabsx());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 89: {
                this.A ^= this.memoryRead(this.eaabsy());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 238: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.operand + 1;
                this.memoryWrite(this.operandAddress, this.NZFlags);
                this.clock += 6;
                break;
            }
            case 230: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.operand + 1;
                this.zeroPageWrite(this.operandAddress, this.NZFlags);
                this.clock += 5;
                break;
            }
            case 246: {
                this.operandAddress = this.eazpx();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.operand + 1;
                this.zeroPageWrite(this.operandAddress, this.NZFlags);
                this.clock += 6;
                break;
            }
            case 254: {
                this.operandAddress = this.eaabsxNC();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.operand + 1;
                this.memoryWrite(this.operandAddress, this.NZFlags);
                this.clock += 7;
                break;
            }
            case 232: {
                this.NZFlags = this.X + 1;
                this.X = this.NZFlags & 0xFF;
                this.clock += 2;
                break;
            }
            case 200: {
                this.NZFlags = this.Y + 1;
                this.Y = this.NZFlags & 0xFF;
                this.clock += 2;
                break;
            }
            case 76: {
                this.PC = this.eaabs();
                this.clock += 3;
                break;
            }
            case 108: {
                this.PC = this.eaabsind();
                this.clock += 5;
                break;
            }
            case 32: {
                this.operandAddress = this.eaabs();
                --this.PC;
                this.push(this.PC >> 8);
                this.push(this.PC);
                this.PC = this.operandAddress;
                this.clock += 6;
                break;
            }
            case 169: {
                this.NZFlags = this.A = this.eaimm();
                this.clock += 2;
                break;
            }
            case 173: {
                this.NZFlags = this.A = this.memoryRead(this.eaabs());
                this.clock += 4;
                break;
            }
            case 165: {
                this.NZFlags = this.A = this.zeroPageRead(this.eazp());
                this.clock += 3;
                break;
            }
            case 161: {
                this.NZFlags = this.A = this.memoryRead(this.eazpxind());
                this.clock += 6;
                break;
            }
            case 177: {
                this.NZFlags = this.A = this.memoryRead(this.eazpindy());
                this.clock += 5;
                break;
            }
            case 181: {
                this.NZFlags = this.A = this.zeroPageRead(this.eazpx());
                this.clock += 4;
                break;
            }
            case 189: {
                this.NZFlags = this.A = this.memoryRead(this.eaabsx());
                this.clock += 4;
                break;
            }
            case 185: {
                this.NZFlags = this.A = this.memoryRead(this.eaabsy());
                this.clock += 4;
                break;
            }
            case 162: {
                this.NZFlags = this.X = this.eaimm();
                this.clock += 2;
                break;
            }
            case 174: {
                this.NZFlags = this.X = this.memoryRead(this.eaabs());
                this.clock += 4;
                break;
            }
            case 166: {
                this.NZFlags = this.X = this.zeroPageRead(this.eazp());
                this.clock += 3;
                break;
            }
            case 190: {
                this.NZFlags = this.X = this.memoryRead(this.eaabsy());
                this.clock += 4;
                break;
            }
            case 182: {
                this.NZFlags = this.X = this.zeroPageRead(this.eazpy());
                this.clock += 4;
                break;
            }
            case 160: {
                this.NZFlags = this.Y = this.eaimm();
                this.clock += 2;
                break;
            }
            case 172: {
                this.NZFlags = this.Y = this.memoryRead(this.eaabs());
                this.clock += 4;
                break;
            }
            case 164: {
                this.NZFlags = this.Y = this.zeroPageRead(this.eazp());
                this.clock += 3;
                break;
            }
            case 180: {
                this.NZFlags = this.Y = this.zeroPageRead(this.eazpx());
                this.clock += 4;
                break;
            }
            case 188: {
                this.NZFlags = this.Y = this.memoryRead(this.eaabsx());
                this.clock += 4;
                break;
            }
            case 78: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.result = (this.operand & 1) << 8;
                this.NZFlags = this.operand >> 1;
                this.memoryWrite(this.operandAddress, this.NZFlags);
                this.clock += 6;
                break;
            }
            case 70: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.result = (this.operand & 1) << 8;
                this.NZFlags = this.operand >> 1;
                this.zeroPageWrite(this.operandAddress, this.NZFlags);
                this.clock += 5;
                break;
            }
            case 74: {
                this.result = (this.A & 1) << 8;
                this.A >>= 1;
                this.NZFlags = this.A;
                this.clock += 2;
                break;
            }
            case 86: {
                this.operandAddress = this.eazpx();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.result = (this.operand & 1) << 8;
                this.NZFlags = this.operand >> 1;
                this.zeroPageWrite(this.operandAddress, this.NZFlags);
                this.clock += 6;
                break;
            }
            case 94: {
                this.operandAddress = this.eaabsx();
                this.operand = this.memoryRead(this.operandAddress);
                this.result = (this.operand & 1) << 8;
                this.NZFlags = this.operand >> 1;
                this.memoryWrite(this.operandAddress, this.NZFlags);
                this.clock += 7;
                break;
            }
            case 234: {
                this.clock += 2;
                break;
            }
            case 9: {
                this.A |= this.eaimm();
                this.NZFlags = this.A;
                this.clock += 2;
                break;
            }
            case 13: {
                this.A |= this.memoryRead(this.eaabs());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 5: {
                this.A |= this.zeroPageRead(this.eazp());
                this.NZFlags = this.A;
                this.clock += 3;
                break;
            }
            case 1: {
                this.A |= this.memoryRead(this.eazpxind());
                this.NZFlags = this.A;
                this.clock += 6;
                break;
            }
            case 17: {
                this.A |= this.memoryRead(this.eazpindy());
                this.NZFlags = this.A;
                this.clock += 5;
                break;
            }
            case 21: {
                this.A |= this.zeroPageRead(this.eazpx());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 29: {
                this.A |= this.memoryRead(this.eaabsx());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 25: {
                this.A |= this.memoryRead(this.eaabsy());
                this.NZFlags = this.A;
                this.clock += 4;
                break;
            }
            case 72: {
                this.push(this.A);
                this.clock += 3;
                break;
            }
            case 8: {
                this.setN(this.getFN());
                this.setZ(this.getFZ());
                this.setC(this.getFC());
                this.push(this.P);
                this.clock += 3;
                break;
            }
            case 104: {
                this.NZFlags = this.A = this.pop();
                this.clock += 4;
                break;
            }
            case 40: {
                this.P = this.pop() | 0x20;
                this.setFC(this.getC());
                this.setFNZ(this.getN(), this.getZ());
                this.clock += 4;
                if (this.pendingIRQ <= 0 || this.getI()) break;
                --this.pendingIRQ;
                this.assertIRQ();
                break;
            }
            case 46: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1 | this.getFC_();
                this.memoryWrite(this.operandAddress, this.result);
                this.clock += 6;
                break;
            }
            case 38: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1 | this.getFC_();
                this.zeroPageWrite(this.operandAddress, this.result);
                this.clock += 5;
                break;
            }
            case 42: {
                this.result = this.A << 1 | this.getFC_();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 2;
                break;
            }
            case 54: {
                this.operandAddress = this.eazpx();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1 | this.getFC_();
                this.zeroPageWrite(this.operandAddress, this.result);
                this.clock += 6;
                break;
            }
            case 62: {
                this.operandAddress = this.eaabsx();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.result = this.operand << 1 | this.getFC_();
                this.memoryWrite(this.operandAddress, this.result);
                this.clock += 7;
                break;
            }
            case 110: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.result = (this.operand & 1) << 8 | this.getFC_() << 7 | this.operand >> 1;
                this.memoryWrite(this.operandAddress, this.result);
                this.clock += 6;
                break;
            }
            case 102: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.result = (this.operand & 1) << 8 | this.getFC_() << 7 | this.operand >> 1;
                this.zeroPageWrite(this.operandAddress, this.result);
                this.clock += 5;
                break;
            }
            case 106: {
                this.result = (this.A & 1) << 8 | this.getFC_() << 7 | this.A >> 1;
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 2;
                break;
            }
            case 118: {
                this.operandAddress = this.eazpx();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.NZFlags = this.result = (this.operand & 1) << 8 | this.getFC_() << 7 | this.operand >> 1;
                this.zeroPageWrite(this.operandAddress, this.result);
                this.clock += 6;
                break;
            }
            case 126: {
                this.operandAddress = this.eaabsx();
                this.operand = this.memoryRead(this.operandAddress);
                this.NZFlags = this.result = (this.operand & 1) << 8 | this.getFC_() << 7 | this.operand >> 1;
                this.memoryWrite(this.operandAddress, this.result);
                this.clock += 7;
                break;
            }
            case 64: {
                this.P = this.pop() | 0x20;
                this.setFC(this.getC());
                this.setFNZ(this.getN(), this.getZ());
                this.PC = this.pop();
                this.PC += this.pop() << 8;
                this.clock += 6;
                break;
            }
            case 96: {
                this.PC = this.pop();
                this.PC += this.pop() << 8;
                ++this.PC;
                this.clock += 6;
                break;
            }
            case 233: {
                this.operand = 255 - this.eaimm();
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 2;
                break;
            }
            case 237: {
                this.operand = 255 - this.memoryRead(this.eaabs());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 229: {
                this.operand = 255 - this.zeroPageRead(this.eazp());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 3;
                break;
            }
            case 225: {
                this.operand = 255 - this.memoryRead(this.eazpxind());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 6;
                break;
            }
            case 241: {
                this.operand = 255 - this.memoryRead(this.eazpindy());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 5;
                break;
            }
            case 245: {
                this.operand = 255 - this.zeroPageRead(this.eazpx());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 253: {
                this.operand = 255 - this.memoryRead(this.eaabsx());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 249: {
                this.operand = 255 - this.memoryRead(this.eaabsy());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 4;
                break;
            }
            case 56: {
                this.setFC(true);
                this.clock += 2;
                break;
            }
            case 248: {
                this.setD(true);
                this.clock += 2;
                break;
            }
            case 120: {
                this.setI(true);
                this.clock += 2;
                break;
            }
            case 141: {
                this.memoryWrite(this.eaabs(), this.A);
                this.clock += 4;
                break;
            }
            case 133: {
                this.zeroPageWrite(this.eazp(), this.A);
                this.clock += 3;
                break;
            }
            case 129: {
                this.memoryWrite(this.eazpxind(), this.A);
                this.clock += 6;
                break;
            }
            case 145: {
                this.memoryWrite(this.eazpindy(), this.A);
                this.clock += 6;
                break;
            }
            case 149: {
                this.zeroPageWrite(this.eazpx(), this.A);
                this.clock += 4;
                break;
            }
            case 157: {
                this.memoryWrite(this.eaabsx(), this.A);
                this.clock += 5;
                break;
            }
            case 153: {
                this.memoryWrite(this.eaabsy(), this.A);
                this.clock += 5;
                break;
            }
            case 142: {
                this.memoryWrite(this.eaabs(), this.X);
                this.clock += 4;
                break;
            }
            case 134: {
                this.zeroPageWrite(this.eazp(), this.X);
                this.clock += 3;
                break;
            }
            case 150: {
                this.zeroPageWrite(this.eazpy(), this.X);
                this.clock += 4;
                break;
            }
            case 140: {
                this.memoryWrite(this.eaabs(), this.Y);
                this.clock += 4;
                break;
            }
            case 132: {
                this.zeroPageWrite(this.eazp(), this.Y);
                this.clock += 3;
                break;
            }
            case 148: {
                this.zeroPageWrite(this.eazpx(), this.Y);
                this.clock += 4;
                break;
            }
            case 170: {
                this.NZFlags = this.X = this.A;
                this.clock += 2;
                break;
            }
            case 168: {
                this.NZFlags = this.Y = this.A;
                this.clock += 2;
                break;
            }
            case 186: {
                this.NZFlags = this.X = this.S;
                this.clock += 2;
                break;
            }
            case 138: {
                this.NZFlags = this.A = this.X;
                this.clock += 2;
                break;
            }
            case 154: {
                this.S = this.X;
                this.clock += 2;
                break;
            }
            case 152: {
                this.NZFlags = this.A = this.Y;
                this.clock += 2;
                break;
            }
            case 114: {
                this.operand = this.memoryRead(this.eazpind());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.adcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 5;
                break;
            }
            case 50: {
                this.A &= this.memoryRead(this.eazpind());
                this.NZFlags = this.A;
                this.clock += 5;
                break;
            }
            case 52: {
                this.operand = this.zeroPageRead(this.eazpx());
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.clock += 3;
                break;
            }
            case 137: {
                this.operand = this.eaimm();
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.clock += 2;
                break;
            }
            case 60: {
                this.operand = this.eaabsx();
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.clock += 4;
                break;
            }
            case 128: {
                this.operand = this.earel();
                this.clock += 2;
                this.branch(this.operand);
                break;
            }
            case 210: {
                this.NZFlags = this.result = 256 + this.A - this.memoryRead(this.eazpind());
                this.clock += 5;
                break;
            }
            case 58: {
                this.NZFlags = this.A + 255;
                this.A = this.NZFlags & 0xFF;
                this.clock += 2;
                break;
            }
            case 82: {
                this.A ^= this.memoryRead(this.eazpind());
                this.NZFlags = this.A;
                this.clock += 5;
                break;
            }
            case 26: {
                this.NZFlags = this.A + 1;
                this.A = this.NZFlags & 0xFF;
                this.clock += 2;
                break;
            }
            case 124: {
                this.PC = this.eaabsxind();
                this.clock += 6;
                break;
            }
            case 178: {
                this.NZFlags = this.A = this.memoryRead(this.eazpind());
                this.clock += 5;
                break;
            }
            case 18: {
                this.A |= this.memoryRead(this.eazpind());
                this.NZFlags = this.A;
                this.clock += 5;
                break;
            }
            case 218: {
                this.push(this.X);
                this.clock += 3;
                break;
            }
            case 250: {
                this.NZFlags = this.X = this.pop();
                this.clock += 4;
                break;
            }
            case 90: {
                this.push(this.Y);
                this.clock += 3;
                break;
            }
            case 122: {
                this.NZFlags = this.Y = this.pop();
                this.clock += 4;
                break;
            }
            case 242: {
                this.operand = 255 - this.memoryRead(this.eazpind());
                this.result = this.operand + this.A + this.getFC_();
                this.setV(((this.operand ^ this.A) & 0x80) == 0 && ((this.A ^ this.result) & 0x80) != 0);
                this.sbcBCDAdjust();
                this.NZFlags = this.A = this.result & 0xFF;
                this.clock += 5;
                break;
            }
            case 146: {
                this.memoryWrite(this.eazpind(), this.A);
                this.clock += 6;
                break;
            }
            case 156: {
                this.memoryWrite(this.eaabs(), 0);
                this.clock += 4;
                break;
            }
            case 100: {
                this.zeroPageWrite(this.eazp(), 0);
                this.clock += 3;
                break;
            }
            case 116: {
                this.zeroPageWrite(this.eazpx(), 0);
                this.clock += 3;
                break;
            }
            case 158: {
                this.memoryWrite(this.eaabsx(), 0);
                this.clock += 4;
                break;
            }
            case 28: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.memoryWrite(this.operandAddress, this.operand & ~this.A & 0xFF);
                this.clock += 5;
                break;
            }
            case 20: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.zeroPageWrite(this.operandAddress, this.operand & ~this.A & 0xFF);
                this.clock += 5;
                break;
            }
            case 12: {
                this.operandAddress = this.eaabs();
                this.operand = this.memoryRead(this.operandAddress);
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.memoryWrite(this.operandAddress, this.operand | this.A);
                this.clock += 5;
                break;
            }
            case 4: {
                this.operandAddress = this.eazp();
                this.operand = this.zeroPageRead(this.operandAddress);
                this.setV((this.operand & 0x40) != 0);
                this.NZFlags = (this.operand & 0x80) << 2 | this.A & this.operand;
                this.zeroPageWrite(this.operandAddress, this.operand | this.A);
                this.clock += 5;
                break;
            }
            default: {
                this.clock += 2;
            }
        }
    }

    public final void executeInstructions(int n) {
        if ((this.exceptionRegister & 1) != 0) {
            this.resetAssertion();
            this.Y = 0;
            this.X = 0;
            this.A = 0;
            this.P = 32;
            this.setFC(this.getC());
            this.setFNZ(this.getN(), this.getZ());
            this.S = 255;
            this.PC = this.memoryRead(65532);
            this.PC |= this.memoryRead(65533) << 8;
            this.exceptionRegister &= 0xFFFFFFFE;
        }
        if ((this.exceptionRegister & 2) != 0) {
            this.push(this.PC >> 8);
            this.push(this.PC);
            this.setN(this.getFN());
            this.setZ(this.getFZ());
            this.setC(this.getFC());
            this.push(this.P);
            this.PC = this.memoryRead(65530);
            this.PC |= this.memoryRead(65531) << 8;
            this.clock += 7;
            this.exceptionRegister ^= 2;
        }
        if ((this.exceptionRegister & 4) != 0) {
            if (this.getI()) {
                ++this.pendingIRQ;
            } else {
                this.push(this.PC >> 8);
                this.push(this.PC);
                this.setN(this.getFN());
                this.setZ(this.getFZ());
                this.setC(this.getFC());
                this.setB(false);
                this.push(this.P);
                this.setI(true);
                this.PC = this.memoryRead(65534);
                this.PC |= this.memoryRead(65535) << 8;
                this.clock += 7;
            }
            this.exceptionRegister ^= 4;
        }
        while (n >= 16) {
            this.PC &= 0xFFFF;
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            this.executeInstruction();
            n -= 16;
        }
        while (n > 0) {
            this.executeInstruction();
            --n;
        }
    }
}

