/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.ui;

public class Color {
    private final int argb;

    public Color(int r, int g, int b, int alpha) {
        this.argb = alpha << 24 | r << 16 | g << 8 | b;
    }

    public Color(int argb) {
        this.argb = argb;
    }

    public final int getAlpha() {
        return this.argb >> 24 & 0xFF;
    }

    public final int getRed() {
        return this.argb >> 16 & 0xFF;
    }

    public final int getGreen() {
        return this.argb >> 8 & 0xFF;
    }

    public final int getBlue() {
        return this.argb & 0xFF;
    }

    public final int getRGB() {
        return this.argb;
    }

    public boolean equals(Object obj) {
        return obj instanceof Color && this.argb == ((Color)obj).argb;
    }

    public int hashCode() {
        return this.argb;
    }

    public static int mix(int color1, int color2) {
        return (((color1 ^ color2) & 0xFFFEFEFE) >> 1) + (color1 & color2);
    }

    public static int mix(int color1, int color2, int color3, int color4) {
        return Color.mix(Color.mix(color1, color2), Color.mix(color3, color4));
    }

    public static int mix(int color1, int fraction1, int color2, int fraction2, int color3, int fraction3, int color4, int fraction4) {
        if (color1 == color2 && color1 == color3 && color1 == color4) {
            return color1;
        }
        return (color1 & 0xFF000000) + (((color1 & 0xFF0000) >> 10) * fraction1 + ((color2 & 0xFF0000) >> 10) * fraction2 + ((color3 & 0xFF0000) >> 10) * fraction3 + ((color4 & 0xFF0000) >> 10) * fraction4 & 0xFF0000) + (((color1 & 0xFF00) * fraction1 >> 10) + ((color2 & 0xFF00) * fraction2 >> 10) + ((color3 & 0xFF00) * fraction3 >> 10) + ((color4 & 0xFF00) * fraction4 >> 10) & 0xFF00) + (((color1 & 0xFF) * fraction1 >> 10) + ((color2 & 0xFF) * fraction2 >> 10) + ((color3 & 0xFF) * fraction3 >> 10) + ((color4 & 0xFF) * fraction4 >> 10) & 0xFF);
    }
}

