/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.smalldisplays;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.VIC6569;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScalableVIC6569
extends VIC6569 {
    protected static final int MULTIPLIER_BITS = 10;
    protected static final int MULTIPLIER = 1024;
    private final double scaling;
    protected int memInc;
    private int borderWidth;
    protected int[] scaledPixels = null;
    protected int nextScaledPixel = 0;
    protected int yFraction;
    protected boolean isPaintLine = true;
    protected int savedScaledPosition;
    protected int savedYFraction;
    protected final int pixelsPerPaint;

    public ScalableVIC6569(C64 c64, double scaling) {
        super(c64);
        if (scaling <= 0.0) {
            throw new IllegalArgumentException("Scaling factor must be >0!");
        }
        this.scaling = Math.floor(scaling * 8.0) / 8.0;
        this.determineBorderWidth();
        this.memInc = (int)(this.getScaling() * 1024.0);
        this.pixelsPerPaint = (int)Math.floor(scaling + 0.99);
    }

    public void initScreenMemory() {
        this.pixels = new int[this.getBorderWidth() * this.getBorderHeight()];
        this.scaledPixels = this.pixels;
    }

    public final double getScaling() {
        return this.scaling;
    }

    public int getDisplayWidth() {
        return (int)((double)super.getDisplayWidth() * this.getScaling());
    }

    public int getDisplayHeight() {
        return (int)((double)super.getDisplayHeight() * this.getScaling());
    }

    public final int getBorderWidth() {
        return this.borderWidth;
    }

    public final int getBorderHeight() {
        return (int)((double)super.getBorderHeight() * this.getScaling());
    }

    private void determineBorderWidth() {
        this.borderWidth = (int)((double)super.getBorderWidth() * this.getScaling());
    }

    public void gotoPixel(int x, int y) {
        this.nextScaledPixel = (int)((Math.floor((double)y * this.getScaling()) * (double)this.getBorderWidth() + (double)x * this.getScaling()) * 1024.0);
        this.yFraction = (int)((double)y * this.getScaling() * 1024.0) % 1024;
        this.isPaintLine = (double)(y + 1) * this.getScaling() % 1.0 < this.getScaling();
        super.gotoPixel(x, y);
    }

    protected boolean isValidPixel() {
        return this.nextScaledPixel >= 0 && this.nextScaledPixel >> 10 < this.scaledPixels.length;
    }

    public int getNextPixel() {
        return this.nextScaledPixel >> 10;
    }

    protected void setNextPixel(int color) {
        if (this.isPaintLine) {
            if (this.pixelsPerPaint == 1) {
                this.scaledPixels[this.nextScaledPixel >> 10] = color;
            } else {
                int pixelsPerPaint_ = this.pixelsPerPaint;
                int borderWidth_ = this.borderWidth;
                for (int y = 0; y < pixelsPerPaint_; ++y) {
                    for (int x = 0; x < pixelsPerPaint_; ++x) {
                        this.scaledPixels[(this.nextScaledPixel >> 10) + x + y * borderWidth_] = color;
                    }
                }
            }
        }
        this.skipPixels(1);
    }

    protected void skipPixels(int n) {
        this.nextScaledPixel += n * this.memInc;
        super.skipPixels(n);
    }

    protected void saveCurrentPixelPosition() {
        super.saveCurrentPixelPosition();
        this.savedScaledPosition = this.nextScaledPixel;
        this.savedYFraction = this.yFraction;
    }

    protected void restoreSavedPixelPosition() {
        this.yFraction = this.savedYFraction;
        this.nextScaledPixel = this.savedScaledPosition;
        super.restoreSavedPixelPosition();
    }

    public int[] getRGBData() {
        return this.scaledPixels;
    }

    public void reset() {
        if (this.scaledPixels != this.pixels) {
            for (int i = 0; i < this.scaledPixels.length; ++i) {
                this.scaledPixels[i] = 0;
            }
        }
        super.reset();
    }

    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeBoolean(this.isPaintLine);
        out.writeInt(this.memInc);
        out.writeInt(this.borderWidth);
        out.writeInt(this.nextScaledPixel);
        out.writeInt(this.yFraction);
        out.writeInt(this.savedScaledPosition);
        out.writeInt(this.savedYFraction);
    }

    public void deserialize(DataInputStream in) throws IOException {
        super.deserialize(in);
        this.isPaintLine = in.readBoolean();
        this.memInc = in.readInt();
        this.borderWidth = in.readInt();
        this.nextScaledPixel = in.readInt();
        this.yFraction = in.readInt();
        this.savedScaledPosition = in.readInt();
        this.savedYFraction = in.readInt();
    }
}

