/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.bluetooth;

import de.joergjahnke.common.bluetooth.BluetoothClient;
import de.joergjahnke.common.bluetooth.BluetoothEventListener;
import de.joergjahnke.common.bluetooth.BluetoothOBEXEventListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import javax.obex.Operation;
import javax.obex.ServerRequestHandler;
import javax.obex.SessionNotifier;

public class BluetoothOBEXClient
extends BluetoothClient {
    private static final int UUID_OBEX_FILE_TRANSFER = 4358;
    private static final int TRANSFER_CHUNK_SIZE = 1000;
    private ClientSession clientSession = null;
    private transient SessionNotifier notifier = null;

    public BluetoothOBEXClient() throws IOException {
        super(4358, true);
    }

    public Hashtable searchOBEXDevices() throws IOException {
        UUID[] uuids = new UUID[]{this.getUUID()};
        return this.searchDevices(uuids);
    }

    public synchronized void connect(RemoteDevice btDevice) throws IOException {
        UUID[] uuids = new UUID[]{this.getUUID()};
        super.searchServices(btDevice, uuids);
        if (this.serviceRecord == null) {
            throw new IOException("Could not connect to " + btDevice + "!");
        }
        this.connect(btDevice, this.serviceRecord);
    }

    public synchronized void connect(RemoteDevice btDevice, ServiceRecord serviceRecord) throws IOException {
        this.clientSession = (ClientSession)Connector.open((String)serviceRecord.getConnectionURL(0, false));
        HeaderSet hsConnectReply = this.clientSession.connect(null);
        if (hsConnectReply.getResponseCode() != 160) {
            this.disconnect();
            throw new IOException("Could not connect to " + btDevice + "!");
        }
    }

    public void disconnect() {
        super.stop();
        try {
            this.clientSession.disconnect(null);
            this.clientSession.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.clientSession = null;
    }

    public void sendFile(String filename, byte[] data) throws IOException {
        super.run();
        HeaderSet hs = this.clientSession.createHeaderSet();
        hs.setHeader(1, (Object)filename);
        hs.setHeader(195, (Object)new Long(data.length));
        hs.setHeader(192, (Object)new Long(1L));
        Operation op = this.clientSession.put(hs);
        OutputStream os = op.openOutputStream();
        this.notifyTransferStarted(filename, data.length);
        for (int i = 0; this.isRunning() && i < data.length; i += 1000) {
            os.write(data, i, Math.min(1000, data.length - i));
            this.notifyTransferProgressed(i);
        }
        os.flush();
        os.close();
        op.close();
        super.stop();
    }

    public void waitForFile() throws IOException {
        super.run();
        this.local.setDiscoverable(10390323);
        this.notifier = (SessionNotifier)Connector.open((String)("btgoep://localhost:" + this.getUUID() + (this.name == null ? "" : ";name=" + this.name)));
        final ServerRequestHandler handler = new ServerRequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int onPut(Operation op) {
                try {
                    HeaderSet hs = op.getReceivedHeaders();
                    if (hs != null) {
                        int read;
                        String name = hs.getHeader(1).toString();
                        long len = -1L;
                        try {
                            len = (Long)hs.getHeader(195);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        BluetoothOBEXClient.this.notifyTransferStarted(name, len);
                        InputStream is = op.openInputStream();
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        byte[] buf = new byte[1000];
                        int n = 0;
                        while ((read = is.read(buf)) > 0) {
                            os.write(buf, 0, read);
                            BluetoothOBEXClient.this.notifyTransferProgressed(n += read);
                        }
                        byte[] result = os.toByteArray();
                        BluetoothOBEXClient.this.notifyFileReceived(name, result);
                        os.close();
                        is.close();
                        op.close();
                        int n2 = 160;
                        return n2;
                    }
                    int n = 192;
                    return n;
                }
                catch (Exception e) {
                    BluetoothOBEXClient.this.notifyErrorOccurred(e);
                    int n = 208;
                    return n;
                }
                finally {
                    BluetoothOBEXClient.this.abortFileReception();
                }
            }
        };
        new Thread(){

            public void run() {
                try {
                    BluetoothOBEXClient.this.notifier.acceptAndOpen(handler);
                }
                catch (IOException e) {
                    BluetoothOBEXClient.this.notifyErrorOccurred(e);
                    BluetoothOBEXClient.this.abortFileReception();
                }
            }
        }.start();
    }

    public void abortFileReception() {
        super.stop();
        try {
            this.local.setDiscoverable(0);
            this.notifier.close();
            this.notifier = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void notifyTransferStarted(String name, long len) {
        int to = this.listeners.size();
        for (int i = 0; i < to; ++i) {
            BluetoothEventListener listener = (BluetoothEventListener)this.listeners.elementAt(i);
            if (!(listener instanceof BluetoothOBEXEventListener)) continue;
            ((BluetoothOBEXEventListener)listener).transferStarted(name, len);
        }
    }

    private void notifyTransferProgressed(long n) {
        int to = this.listeners.size();
        for (int i = 0; i < to; ++i) {
            BluetoothEventListener listener = (BluetoothEventListener)this.listeners.elementAt(i);
            if (!(listener instanceof BluetoothOBEXEventListener)) continue;
            ((BluetoothOBEXEventListener)listener).transferProgressed(n);
        }
    }

    private void notifyFileReceived(String name, byte[] data) {
        int to = this.listeners.size();
        for (int i = 0; i < to; ++i) {
            BluetoothEventListener listener = (BluetoothEventListener)this.listeners.elementAt(i);
            if (!(listener instanceof BluetoothOBEXEventListener)) continue;
            ((BluetoothOBEXEventListener)listener).fileReceived(name, data);
        }
    }
}

