/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.jme.LocalizationSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;

public class FileBrowser {
    private static final Command useDirCommand = new Command(LocalizationSupport.getMessage("Select"), LocalizationSupport.getMessage("SelectThisFile"), 4, 1);
    private static final Command listDirCommand = new Command(LocalizationSupport.getMessage("List"), LocalizationSupport.getMessage("ListDirectory"), 8, 2);
    private static final Command backCommand = new Command(LocalizationSupport.getMessage("Back"), 2, 99);
    private static final String RESOURCE_ROOT = "/res/drawable/";
    private static final String FOLDER = "folder.png";
    private static final String FILE = "file.png";
    private static final String PARENT = "parent.png";
    private static final Hashtable images = new Hashtable();
    private String selected = "";
    private final Vector currentFiles = new Vector();
    private final Vector filters;
    private final Displayable previous;
    private final Display display;

    public FileBrowser(Display display, String currentDir, Vector filters) {
        this.selected = currentDir;
        this.filters = filters;
        this.previous = display.getCurrent();
        this.display = display;
    }

    public String getSelectedFile() {
        return this.selected;
    }

    public void show() {
        this.retrieveDirectory();
    }

    private void retrieveDirectory() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    FileBrowser.this.currentFiles.removeAllElements();
                    if (null == FileBrowser.this.selected || "".equals(FileBrowser.this.selected)) {
                        Enumeration en = FileSystemRegistry.listRoots();
                        while (en.hasMoreElements()) {
                            FileBrowser.this.currentFiles.addElement(en.nextElement());
                        }
                    } else {
                        String url = "file:///" + FileBrowser.this.selected;
                        FileConnection dirConn = (FileConnection)Connector.open((String)url, (int)1);
                        Enumeration en = dirConn.list();
                        block3: while (en.hasMoreElements()) {
                            String file = en.nextElement().toString();
                            for (int i = 0; i < FileBrowser.this.filters.size(); ++i) {
                                if (!file.endsWith(FileBrowser.this.filters.elementAt(i).toString())) continue;
                                FileBrowser.this.currentFiles.addElement(file);
                                continue block3;
                            }
                        }
                    }
                    FileBrowser.this.showFiles();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileBrowser.this.onError(e);
                }
            }
        };
        thread.start();
    }

    private void showFiles() {
        Form settingsForm = new Form(LocalizationSupport.getMessage("FileBrowser"));
        final ChoiceGroup dirChoice = new ChoiceGroup(LocalizationSupport.getMessage("ContentsOf") + (null == this.selected || "".equals(this.selected) ? "/" : this.selected), 1);
        if (null != this.selected && !"".equals(this.selected)) {
            dirChoice.append("..", (Image)images.get(PARENT));
        }
        for (int i = 0; i < this.currentFiles.size(); ++i) {
            String file;
            dirChoice.append(file, (file = this.currentFiles.elementAt(i).toString()).endsWith("/") ? (Image)images.get(FOLDER) : (Image)images.get(FILE));
        }
        settingsForm.append((Item)dirChoice);
        settingsForm.addCommand(useDirCommand);
        settingsForm.addCommand(listDirCommand);
        settingsForm.addCommand(backCommand);
        settingsForm.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == useDirCommand) {
                    String file = dirChoice.getString(dirChoice.getSelectedIndex());
                    if (!"..".equals(file)) {
                        FileBrowser.this.selected = FileBrowser.this.selected + file;
                    }
                    FileBrowser.this.onSelect();
                } else if (c == listDirCommand) {
                    String directory = dirChoice.getString(dirChoice.getSelectedIndex());
                    if ("..".equals(directory)) {
                        if (FileBrowser.this.selected.indexOf(47) <= 0 || FileBrowser.this.selected.indexOf(47) == FileBrowser.this.selected.lastIndexOf(47)) {
                            FileBrowser.this.selected = "";
                        } else {
                            FileBrowser.this.selected = FileBrowser.this.selected.substring(0, FileBrowser.this.selected.substring(0, FileBrowser.this.selected.length() - 1).lastIndexOf(47) + 1);
                        }
                    } else if (directory.endsWith("/")) {
                        FileBrowser.this.selected = FileBrowser.this.selected + directory;
                        FileBrowser.this.retrieveDirectory();
                    } else {
                        FileBrowser.this.display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("NotADirectory"), LocalizationSupport.getMessage("SelectedNotADirectory"), null, AlertType.WARNING));
                    }
                } else if (c == backCommand) {
                    FileBrowser.this.display.setCurrent(FileBrowser.this.previous);
                }
            }
        });
        this.display.setCurrent((Displayable)settingsForm);
    }

    public void onSelect() {
    }

    public void onError(Throwable t) {
        this.display.setCurrent(this.previous);
        this.display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("AnErrorHasOccurred"), LocalizationSupport.getMessage("ErrorWas") + t, null, AlertType.WARNING));
    }

    static {
        try {
            images.put(FOLDER, Image.createImage((String)"/res/drawable/folder.png"));
            images.put(PARENT, Image.createImage((String)"/res/drawable/parent.png"));
            images.put(FILE, Image.createImage((String)"/res/drawable/file.png"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

