/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.emulation.FrequencyDataProducer;
import de.joergjahnke.common.emulation.FrequencyDataProducerOwner;
import de.joergjahnke.common.jme.MathUtils;
import de.joergjahnke.common.util.Observer;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class PCMtoMIDIPlayer
implements Observer {
    public static final Integer SIGNAL_STOP = new Integer(0);
    public static final Integer SIGNAL_PAUSE = new Integer(0);
    private static final int NOTE_OFF = 128;
    private static final int CONTROL_ALL_SOUND_OFF = 120;
    private static final int CONTROL_MAIN_VOLUME = 7;
    protected static final int SHORT_MIDI_EVENT = 1;
    protected static final int PROGRAM_CHANGE = 2;
    private final Player player = Manager.createPlayer((String)"device://midi");
    private final MIDIThread worker;
    private final int[] prevFrequencies;
    private final int[] prevVolumes;
    private final int[] prevTypes;
    private final int[] currentNote;

    public PCMtoMIDIPlayer(FrequencyDataProducerOwner producer) throws IOException, MediaException {
        this.player.prefetch();
        int channelCount = producer.getFrequencyDataProducerCount();
        this.prevFrequencies = new int[channelCount];
        this.prevVolumes = new int[channelCount];
        this.prevTypes = new int[channelCount];
        this.currentNote = new int[channelCount];
        for (int i = 0; i < this.currentNote.length; ++i) {
            this.currentNote[i] = -1;
        }
        Control control = this.player.getControl("javax.microedition.media.control.MIDIControl");
        this.worker = new MIDIThread(control);
        this.worker.start();
    }

    private int getNote(int freq) {
        return 69 + (int)(12.0 * MathUtils.log2((double)freq / 440.0));
    }

    public void update(Object observed, Object obj) {
        if (observed instanceof FrequencyDataProducerOwner) {
            if (obj == SIGNAL_STOP) {
                this.worker.pause();
                this.worker.stop();
            } else if (obj == SIGNAL_PAUSE) {
                this.worker.pause();
            } else {
                int channelCount = ((FrequencyDataProducerOwner)observed).getFrequencyDataProducerCount();
                for (int i = 0; i < channelCount; ++i) {
                    FrequencyDataProducer channel = ((FrequencyDataProducerOwner)observed).getFrequencyDataProducers(i);
                    int freq = channel.getFrequency();
                    int volume = channel.getVolume() * 127 / 100;
                    int type = channel.getType();
                    int prevFreq = this.prevFrequencies[i];
                    int prevVolume = this.prevVolumes[i];
                    int prevType = this.prevTypes[i];
                    if (type != prevType) {
                        if (this.currentNote[i] >= 0) {
                            this.worker.addMidiEvent(128 + i, this.currentNote[i], 127);
                            this.currentNote[i] = -1;
                            this.prevFrequencies[i] = 0;
                        }
                        this.worker.addMidiEvent(2, i, -1, type);
                        this.prevTypes[i] = type;
                    }
                    if (freq == prevFreq && volume == prevVolume) continue;
                    if (volume == 0 || freq == 0) {
                        if (this.currentNote[i] >= 0) {
                            this.worker.addMidiEvent(128 + i, this.currentNote[i], 127);
                            this.currentNote[i] = -1;
                        }
                    } else {
                        if (freq != prevFreq) {
                            if (this.currentNote[i] >= 0) {
                                this.worker.addMidiEvent(128 + i, this.currentNote[i], 127);
                            }
                            this.currentNote[i] = this.getNote(freq);
                            this.worker.addMidiEvent(144 + i, this.currentNote[i], 127);
                        }
                        if (volume != prevVolume) {
                            this.worker.addMidiEvent(176 + i, 7, volume);
                        }
                    }
                    this.prevFrequencies[i] = volume == 0 ? 0 : freq;
                    this.prevVolumes[i] = volume;
                }
            }
        }
    }

    class MIDIQueueEntry {
        public final int type;
        public final int event;
        public final int arg1;
        public final int arg2;

        public MIDIQueueEntry(int type, int event, int arg1, int arg2) {
            this.type = type;
            this.event = event;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public MIDIQueueEntry(int event, int arg1, int arg2) {
            this(1, event, arg1, arg2);
        }
    }

    class MIDIThread
    extends Thread {
        private boolean isRunning = false;
        private final Vector queue = new Vector();
        private final Object control;

        public MIDIThread(Object control) {
            this.control = control;
        }

        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                block7: while (!this.queue.isEmpty()) {
                    MIDIQueueEntry entry = (MIDIQueueEntry)this.queue.firstElement();
                    this.queue.removeElementAt(0);
                    switch (entry.type) {
                        case 1: {
                            ((MIDIControl)this.control).shortMidiEvent(entry.event, entry.arg1, entry.arg2);
                            continue block7;
                        }
                        case 2: {
                            ((MIDIControl)this.control).setProgram(entry.event, entry.arg1, entry.arg2);
                            continue block7;
                        }
                    }
                    throw new RuntimeException("Illegal type for MIDIQueueEntry: " + entry.type + "!");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stop() {
            this.isRunning = false;
            this.queue.removeAllElements();
        }

        public void pause() {
            this.queue.removeAllElements();
            for (int i = 0; i < PCMtoMIDIPlayer.this.prevFrequencies.length; ++i) {
                ((MIDIControl)this.control).shortMidiEvent(0xB0 | i, 120, 0);
                ((PCMtoMIDIPlayer)PCMtoMIDIPlayer.this).prevFrequencies[i] = 0;
                ((PCMtoMIDIPlayer)PCMtoMIDIPlayer.this).prevVolumes[i] = 0;
            }
        }

        public void addMidiEvent(int event, int arg1, int arg2) {
            this.queue.addElement(new MIDIQueueEntry(event, arg1, arg2));
        }

        public void addMidiEvent(int type, int event, int arg1, int arg2) {
            this.queue.addElement(new MIDIQueueEntry(type, event, arg1, arg2));
        }
    }
}

