/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.drive.DriveChannel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ByteArrayDriveChannel
implements DriveChannel {
    protected ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
    protected ByteArrayOutputStream out = new ByteArrayOutputStream();
    protected final C1541 c1541;

    public ByteArrayDriveChannel(C1541 c1541) {
        this.c1541 = c1541;
    }

    protected void fill(byte[] bytes, int offset, int len) {
        this.in = new ByteArrayInputStream(bytes, offset, len);
    }

    protected byte[] skip(int numBytes) {
        ByteArrayOutputStream skipped = new ByteArrayOutputStream();
        for (int i = 0; i < numBytes; ++i) {
            skipped.write(this.in.read());
        }
        return skipped.toByteArray();
    }

    public void write(int b) throws IOException {
        this.c1541.setChanged(true);
        this.c1541.notifyObservers(C1541.WRITING);
        this.out.write(b);
    }

    public void write(byte[] bytes, int offset, int len) {
        this.c1541.setChanged(true);
        this.c1541.notifyObservers(C1541.WRITING);
        this.out.write(bytes, offset, len);
    }

    public int read() {
        this.c1541.setChanged(true);
        this.c1541.notifyObservers(C1541.READING);
        return this.in.read();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void commit() throws IOException {
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }
}

