/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class GBCanvas
extends Canvas
implements CommandListener {
    public MeBoy parent;
    private Dmgcpu cpu;
    private int w;
    private int h;
    private int l;
    private int t;
    private int sw;
    private int sh;
    private int trans;
    private int ssw;
    private int ssh;
    private int clipHeight;
    private int[] previousTime = new int[16];
    private int previousTimeIx;
    private Command pauseCommand = new Command(MeBoy.literal[30], 1, 0);
    private Command resumeCommand = new Command(MeBoy.literal[31], 1, 0);
    private Command saveCommand = new Command(MeBoy.literal[32], 1, 1);
    private Command showFpsCommand = new Command(MeBoy.literal[33], 1, 3);
    private Command fullScreenCommand = new Command(MeBoy.literal[34], 1, 4);
    private Command setButtonsCommand = new Command(MeBoy.literal[35], 1, 5);
    private Command exitCommand;
    private static int[] key = new int[]{54, 52, 50, 56, 55, 57, 35, 42};
    private String[] keyName = new String[]{MeBoy.literal[38], MeBoy.literal[39], MeBoy.literal[40], MeBoy.literal[41], MeBoy.literal[42], MeBoy.literal[43], MeBoy.literal[44], MeBoy.literal[45]};
    private int keySetCounter;
    private boolean settingKeys;
    private boolean paused;
    private String cartDisplayName;
    private String cartID = "";
    private String cartFileName;
    private String suspendName;
    private Thread cpuThread;

    private GBCanvas(MeBoy meBoy, String string, String string2) {
        this.parent = meBoy;
        this.cartFileName = string;
        this.cartDisplayName = string2;
        this.exitCommand = new Command(MeBoy.literal[36] + " " + string2, 1, 6);
        this.setCommandListener(this);
        this.updateCommands();
        this.setFullScreenMode(MeBoy.fullScreen);
    }

    public GBCanvas(String string, String string2, MeBoy meBoy, String string3, String string4, byte[] byArray) {
        this(meBoy, string2, string3);
        this.suspendName = string4;
        this.cpu = new Dmgcpu(string2, this, byArray);
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    public GBCanvas(String string, MeBoy meBoy, String string2) {
        this(meBoy, string, string2);
        this.cpu = new Dmgcpu(string, this);
        if (this.cpu.hasBattery()) {
            this.loadCartRam();
        }
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    private void updateCommands() {
        this.removeCommand(this.pauseCommand);
        this.removeCommand(this.resumeCommand);
        this.removeCommand(this.saveCommand);
        this.removeCommand(this.showFpsCommand);
        this.removeCommand(this.fullScreenCommand);
        this.removeCommand(this.setButtonsCommand);
        this.removeCommand(this.exitCommand);
        if (this.paused) {
            this.addCommand(this.resumeCommand);
        } else {
            this.addCommand(this.pauseCommand);
        }
        this.addCommand(this.saveCommand);
        this.addCommand(this.showFpsCommand);
        this.addCommand(this.fullScreenCommand);
        this.addCommand(this.setButtonsCommand);
        this.addCommand(this.exitCommand);
    }

    public void setDimensions() {
        boolean bl;
        this.w = this.getWidth();
        this.h = this.getHeight();
        int[] nArray = new int[]{0, 5, 3, 6};
        this.trans = nArray[MeBoy.rotations];
        boolean bl2 = bl = (MeBoy.rotations & 1) != 0;
        if (MeBoy.enableScaling) {
            int n = MeBoy.showFps ? -16 : 0;
            this.cpu.setScale(bl ? this.h + n : this.w, bl ? this.w : this.h + n);
        }
        this.ssw = this.sw = this.cpu.graphicsChip.scaledWidth;
        this.ssh = this.sh = this.cpu.graphicsChip.scaledHeight;
        this.clipHeight = this.sh;
        if (bl) {
            this.sw = this.ssh;
            this.clipHeight = this.sh = this.ssw;
        }
        this.l = (this.w - this.sw) / 2;
        this.t = (this.h - this.sh) / 2;
        if (MeBoy.showFps) {
            this.t -= 8;
            this.clipHeight += 16;
        }
        if (this.l < 0) {
            this.l = 0;
        }
        if (this.t < 0) {
            this.t = 0;
        }
    }

    public void keyReleased(int n) {
        for (int i = 0; i < 8; ++i) {
            if (n != key[i]) continue;
            this.cpu.buttonUp(i);
        }
    }

    public void keyPressed(int n) {
        if (this.settingKeys) {
            GBCanvas.key[this.keySetCounter++] = n;
            if (this.keySetCounter == 8) {
                GBCanvas.writeSettings();
                this.settingKeys = false;
            }
            this.repaint();
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (n != key[i]) continue;
            this.cpu.buttonDown(i);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            String string = command.getLabel();
            if (string.startsWith(MeBoy.literal[36])) {
                if (this.cpu.hasBattery()) {
                    this.saveCartRam();
                }
                this.parent.unloadCart();
                Runtime.getRuntime().gc();
            } else if (string == MeBoy.literal[30]) {
                this.pause();
            } else if (string == MeBoy.literal[31] && !this.settingKeys) {
                this.paused = false;
                this.updateCommands();
                this.cpuThread = new Thread(this.cpu);
                this.cpuThread.start();
            } else if (string == MeBoy.literal[33]) {
                MeBoy.showFps = !MeBoy.showFps;
                this.setDimensions();
            } else if (string == MeBoy.literal[35] && !this.settingKeys) {
                this.pause();
                this.settingKeys = true;
                this.keySetCounter = 0;
            } else if (string == MeBoy.literal[32] && !this.settingKeys) {
                if (!this.cpu.isTerminated()) {
                    this.cpu.terminate();
                    while (this.cpuThread.isAlive()) {
                        Thread.yield();
                    }
                    this.suspend();
                    this.cpuThread = new Thread(this.cpu);
                    this.cpuThread.start();
                } else {
                    this.suspend();
                }
            } else if (string == MeBoy.literal[34] && !this.settingKeys) {
                MeBoy.fullScreen = !MeBoy.fullScreen;
                this.setFullScreenMode(MeBoy.fullScreen);
                this.setDimensions();
            }
        }
        catch (Throwable throwable) {
            MeBoy.log(throwable.toString());
            MeBoy.showLog();
        }
        this.repaint();
    }

    public final void pause() {
        if (this.cpuThread == null) {
            return;
        }
        this.paused = true;
        this.updateCommands();
        this.cpu.terminate();
        while (this.cpuThread.isAlive()) {
            Thread.yield();
        }
        this.cpuThread = null;
    }

    public final void redrawSmall() {
        this.repaint(this.l, this.t, this.sw, this.clipHeight);
    }

    public final void paintFps(Graphics graphics) {
        graphics.setClip(this.l, this.t + this.sh, this.sw, 16);
        graphics.setColor(0x999999);
        graphics.fillRect(this.l, this.t + this.sh, this.sw, 16);
        graphics.setColor(0);
        int n = (int)System.currentTimeMillis();
        int n2 = (32640 + n - this.previousTime[this.previousTimeIx]) / (n - this.previousTime[this.previousTimeIx]) >> 1;
        this.previousTime[this.previousTimeIx] = n;
        this.previousTimeIx = this.previousTimeIx + 1 & 0xF;
        graphics.drawString(n2 + " fps * " + (this.cpu.getLastSkipCount() + 1), this.l + 1, this.t + this.sh, 20);
    }

    public final void paint(Graphics graphics) {
        if (this.cpu == null) {
            return;
        }
        if (this.settingKeys) {
            graphics.setColor(0x446688);
            graphics.fillRect(0, 0, this.w, this.h);
            graphics.setColor(-1);
            int n = MeBoy.literal[37].indexOf(32, MeBoy.literal[37].length() * 2 / 5);
            if (n == -1) {
                n = 0;
            }
            graphics.drawString(MeBoy.literal[37].substring(0, n), this.w / 2, this.h / 2 - 18, 65);
            graphics.drawString(MeBoy.literal[37].substring(n + 1), this.w / 2, this.h / 2, 65);
            graphics.drawString(this.keyName[this.keySetCounter], this.w / 2, this.h / 2 + 18, 65);
            return;
        }
        if (graphics.getClipWidth() != this.sw || graphics.getClipHeight() != this.clipHeight) {
            graphics.setColor(0x666666);
            graphics.fillRect(0, 0, this.w, this.h);
        }
        if (MeBoy.showFps) {
            this.paintFps(graphics);
        }
        graphics.setClip(this.l, this.t, this.sw, this.sh);
        if (this.cpu.graphicsChip.frameBufferImage == null) {
            graphics.setColor(0xAAAAAA);
            graphics.fillRect(this.l, this.t, this.sw, this.sh);
        } else if (this.trans == 0) {
            graphics.drawImage(this.cpu.graphicsChip.frameBufferImage, this.l, this.t, 20);
        } else {
            graphics.drawRegion(this.cpu.graphicsChip.frameBufferImage, 0, 0, this.ssw, this.ssh, this.trans, this.l, this.t, 20);
        }
        this.cpu.graphicsChip.notifyRepainted();
        if (this.paused) {
            graphics.setColor(0);
            graphics.drawString(MeBoy.literal[30], this.w / 2 - 1, this.h / 2, 65);
            graphics.drawString(MeBoy.literal[30], this.w / 2, this.h / 2 - 1, 65);
            graphics.drawString(MeBoy.literal[30], this.w / 2 + 1, this.h / 2, 65);
            graphics.drawString(MeBoy.literal[30], this.w / 2, this.h / 2 + 1, 65);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(MeBoy.literal[30], this.w / 2, this.h / 2, 65);
        }
    }

    public static final void setInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)n2;
    }

    public static final int getInt(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        n2 = (n2 << 8) + (byArray[n++] & 0xFF);
        n2 = (n2 << 8) + (byArray[n++] & 0xFF);
        return (n2 << 8) + (byArray[n++] & 0xFF);
    }

    public static final void writeSettings() {
        try {
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            RecordStore recordStore = RecordStore.openRecordStore((String)"set", (boolean)true);
            int n5 = 55;
            for (n4 = 0; n4 < MeBoy.suspendName10.length; ++n4) {
                n5 += 1 + MeBoy.suspendName10[n4].length();
            }
            for (n4 = 0; n4 < MeBoy.suspendName20.length; ++n4) {
                n5 += 1 + MeBoy.suspendName20[n4].length() * 2;
            }
            byte[] byArray = new byte[++n5];
            for (n3 = 0; n3 < 8; ++n3) {
                GBCanvas.setInt(byArray, n3 * 4, key[n3]);
            }
            GBCanvas.setInt(byArray, 32, MeBoy.maxFrameSkip);
            GBCanvas.setInt(byArray, 36, MeBoy.rotations);
            GBCanvas.setInt(byArray, 40, MeBoy.lazyLoadingThreshold);
            GBCanvas.setInt(byArray, 44, MeBoy.suspendCounter);
            GBCanvas.setInt(byArray, 48, MeBoy.suspendName10.length);
            n3 = 52;
            for (n2 = 0; n2 < MeBoy.suspendName10.length; ++n2) {
                object = MeBoy.suspendName10[n2];
                byArray[n3++] = (byte)((String)object).length();
                for (n = 0; n < ((String)object).length(); ++n) {
                    byArray[n3++] = (byte)((String)object).charAt(n);
                }
            }
            byArray[n3++] = (byte)((MeBoy.enableScaling ? 1 : 0) + (MeBoy.keepProportions ? 2 : 0) + (MeBoy.fullScreen ? 4 : 0) + (MeBoy.disableColor ? 8 : 0) + (MeBoy.enableSound ? 32 : 0) + (MeBoy.advancedSound ? 64 : 0) + (MeBoy.advancedGraphics ? 128 : 0));
            byArray[n3++] = (byte)MeBoy.language;
            byArray[n3++] = (byte)((MeBoy.showFps ? 1 : 0) + (MeBoy.showLogItem ? 2 : 0));
            byArray[n3++] = (byte)MeBoy.suspendName20.length;
            for (n2 = 0; n2 < MeBoy.suspendName20.length; ++n2) {
                object = MeBoy.suspendName20[n2].toCharArray();
                byArray[n3++] = (byte)((Object)object).length;
                for (n = 0; n < ((Object)object).length; ++n) {
                    byArray[n3++] = (byte)(object[n] >> 8);
                    byArray[n3++] = (byte)object[n];
                }
            }
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, n5);
            } else {
                recordStore.setRecord(1, byArray, 0, n5);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    public static final void readSettings() {
        try {
            MeBoy.suspendName10 = new String[0];
            MeBoy.suspendName20 = new String[0];
            RecordStore recordStore = RecordStore.openRecordStore((String)"set", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                int n;
                int n2;
                int n3;
                byte[] byArray = recordStore.getRecord(1);
                for (n3 = 0; n3 < 8; ++n3) {
                    GBCanvas.key[n3] = GBCanvas.getInt(byArray, n3 * 4);
                }
                if (byArray.length >= 36) {
                    MeBoy.maxFrameSkip = GBCanvas.getInt(byArray, 32);
                }
                if (byArray.length >= 40) {
                    MeBoy.rotations = GBCanvas.getInt(byArray, 36);
                }
                if (byArray.length >= 44) {
                    MeBoy.lazyLoadingThreshold = GBCanvas.getInt(byArray, 40);
                }
                if (byArray.length > (n3 = 44)) {
                    MeBoy.suspendCounter = GBCanvas.getInt(byArray, n3);
                    MeBoy.suspendName10 = new String[GBCanvas.getInt(byArray, n3 += 4)];
                    n3 += 4;
                    for (n2 = 0; n2 < MeBoy.suspendName10.length; ++n2) {
                        n = byArray[n3++] & 0xFF;
                        MeBoy.suspendName10[n2] = new String(byArray, n3, n);
                        n3 += n;
                    }
                }
                if (byArray.length > n3) {
                    MeBoy.enableScaling = (byArray[n3] & 1) != 0;
                    MeBoy.keepProportions = (byArray[n3] & 2) != 0;
                    MeBoy.fullScreen = (byArray[n3] & 4) != 0;
                    MeBoy.disableColor = (byArray[n3] & 8) != 0;
                    MeBoy.language = (byArray[n3] & 0x10) != 0 ? 1 : 0;
                    MeBoy.enableSound = (byArray[n3] & 0x20) != 0;
                    MeBoy.advancedSound = (byArray[n3] & 0x40) != 0;
                    MeBoy.advancedGraphics = (byArray[n3] & 0x80) != 0;
                    ++n3;
                }
                if (byArray.length > n3) {
                    MeBoy.language = byArray[n3++];
                }
                if (byArray.length > n3) {
                    MeBoy.showFps = (byArray[n3] & 1) != 0;
                    MeBoy.showLogItem = (byArray[n3] & 2) != 0;
                    ++n3;
                }
                if (byArray.length > n3) {
                    MeBoy.suspendName20 = new String[byArray[n3++]];
                    for (n2 = 0; n2 < MeBoy.suspendName20.length; ++n2) {
                        n = byArray[n3++] & 0xFF;
                        char[] cArray = new char[n];
                        int n4 = 0;
                        while (n4 < n) {
                            int n5 = n4;
                            cArray[n5] = (char)(cArray[n5] + ((byArray[n3++] & 0xFF) << 8));
                            int n6 = n4++;
                            cArray[n6] = (char)(cArray[n6] + (byArray[n3++] & 0xFF));
                        }
                        MeBoy.suspendName20[n2] = new String(cArray);
                    }
                }
            } else {
                GBCanvas.writeSettings();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    private final void saveCartRam() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)("20R_" + this.cartID), (boolean)true);
            byte[][] byArray = this.cpu.getCartRam();
            int n = byArray.length;
            int n2 = byArray[0].length;
            int n3 = n * n2 + 13;
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n; ++i) {
                System.arraycopy(byArray[i], 0, byArray2, i * n2, n2);
            }
            System.arraycopy(this.cpu.getRtcReg(), 0, byArray2, n * n2, 5);
            long l = System.currentTimeMillis();
            GBCanvas.setInt(byArray2, n * n2 + 5, (int)(l >> 32));
            GBCanvas.setInt(byArray2, n * n2 + 9, (int)l);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray2, 0, n3);
            } else {
                recordStore.setRecord(1, byArray2, 0, n3);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadCartRam() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)("20R_" + this.cartID), (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[][] byArray = this.cpu.getCartRam();
                int n = byArray.length;
                int n2 = byArray[0].length;
                byte[] byArray2 = recordStore.getRecord(1);
                for (int i = 0; i < n; ++i) {
                    System.arraycopy(byArray2, i * n2, byArray[i], 0, n2);
                }
                if (byArray2.length == n * n2 + 13) {
                    System.arraycopy(byArray2, n * n2, this.cpu.getRtcReg(), 0, 5);
                    long l = GBCanvas.getInt(byArray2, n * n2 + 5);
                    l = (l << 32) + ((long)GBCanvas.getInt(byArray2, n * n2 + 9) & 0xFFFFFFFFL);
                    l = System.currentTimeMillis() - l;
                    this.cpu.rtcSkip((int)(l / 1000L));
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    private final void suspend() {
        try {
            boolean bl = false;
            if (this.suspendName == null) {
                this.suspendName = MeBoy.suspendCounter++ + ": " + this.cartDisplayName;
                bl = true;
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)("20S_" + this.suspendName), (boolean)true);
            byte[] byArray = this.cpu.flatten();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(this.cartID.getBytes(), 0, this.cartID.length());
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, this.cartID.getBytes(), 0, this.cartID.length());
                recordStore.setRecord(2, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
            if (bl) {
                MeBoy.addSuspendedGame(this.suspendName);
            }
        }
        catch (Exception exception) {
            MeBoy.showError(null, "error#10", exception);
        }
    }

    public void updateCartID(String string) {
        this.cartID = string;
        this.parent.updateCartID(this.cartFileName, string);
    }

    public void releaseReferences() {
        this.cpu.terminate();
        while (this.cpuThread != null && this.cpuThread.isAlive()) {
            Thread.yield();
        }
        this.cpu.releaseReferences();
        this.cpu = null;
        this.cartID = null;
        this.cartDisplayName = null;
        this.previousTime = null;
        this.parent = null;
        System.gc();
    }
}

