/*
 * Decompiled with CFR 0.152.
 */
package dma;

import app.GBACore;

public abstract class DMA {
    int source;
    int destination;
    short count;
    short control;
    boolean isEnabled;
    boolean isIRQEnabled;
    boolean isRepeatEnabled;
    int startTiming;
    private int dmaNumber;
    private int dmaMaxCount;
    private short dmaInterruptBit;
    private GBACore Core;

    public DMA(int n) {
        this.dmaNumber = n;
        this.dmaMaxCount = n == 3 ? 65536 : 16384;
        this.dmaInterruptBit = (short)(256 << n);
    }

    public final void connectToMemory(GBACore gBACore) {
        this.Core = gBACore;
    }

    public final void reset() {
        this.destination = 0;
        this.source = 0;
        this.control = 0;
        this.count = 0;
        this.isRepeatEnabled = false;
        this.isIRQEnabled = false;
        this.isEnabled = false;
        this.startTiming = 0;
    }

    public final String getName() {
        return "DMA" + this.dmaNumber;
    }

    public void setSourceLRegister(short s) {
        this.source = this.source & 0xFFFF0000 | s & 0xFFFF;
    }

    public abstract void setSourceHRegister(short var1);

    public void setDestinationLRegister(short s) {
        this.destination = this.destination & 0xFFFF0000 | s & 0xFFFF;
    }

    public abstract void setDestinationHRegister(short var1);

    public abstract void setCountRegister(short var1);

    public final void setControlRegister(short s) {
        this.control = s;
        this.isEnabled = (this.control & 0x8000) != 0;
        this.isIRQEnabled = (this.control & 0x4000) != 0;
        this.isRepeatEnabled = (this.control & 0x200) != 0;
        this.startTiming = this.control & 0x3000;
        this.signalImmediately();
    }

    private final void signal(int n) {
        if (this.isEnabled & this.startTiming == n) {
            int n2;
            int n3;
            boolean bl = (this.control & 0x400) != 0;
            int n4 = bl ? 4 : 2;
            int n5 = this.count == 0 ? this.dmaMaxCount : this.count & 0xFFFF;
            int n6 = this.control & 0x60;
            int n7 = this.control & 0x180;
            switch (n6) {
                case 0: 
                case 96: {
                    n3 = n4;
                    break;
                }
                case 32: {
                    n3 = -n4;
                    break;
                }
                case 64: {
                    n3 = 0;
                    break;
                }
                default: {
                    return;
                }
            }
            switch (n7) {
                case 0: {
                    n2 = n4;
                    break;
                }
                case 128: {
                    n2 = -n4;
                    break;
                }
                case 256: {
                    n2 = 0;
                    break;
                }
                default: {
                    return;
                }
            }
            int n8 = this.destination;
            if (bl) {
                for (int i = 0; i < n5; ++i) {
                    this.Core.storeWord(this.destination, this.Core.loadWord(this.source));
                    this.destination += n3;
                    this.source += n2;
                }
            } else {
                for (int i = 0; i < n5; ++i) {
                    this.Core.storeHalfWord(this.destination, this.Core.loadHalfWord(this.source));
                    this.destination += n3;
                    this.source += n2;
                }
            }
            if (n6 == 96) {
                this.destination = n8;
            }
            if (this.isIRQEnabled) {
                this.Core.generateInterrupt(this.dmaInterruptBit);
            }
            if (!this.isRepeatEnabled) {
                this.control = (short)(this.control & 0xFFFF7FFF);
                this.isEnabled = false;
            }
        }
    }

    private final void signalImmediately() {
        this.signal(0);
    }

    public final void signalVBlank() {
        this.signal(4096);
    }

    public final void signalHBlank() {
        this.signal(8192);
    }

    public final void signalSpecial() {
        this.signal(12288);
    }

    public final short getSourceLRegister() {
        return (short)(this.source & 0xFFFF);
    }

    public final short getSourceHRegister() {
        return (short)(this.source >>> 16);
    }

    public final short getDestinationLRegister() {
        return (short)(this.destination & 0xFFFF);
    }

    public final short getDestinationHRegister() {
        return (short)(this.destination >>> 16);
    }

    public final short getCountRegister() {
        return this.count;
    }

    public final short getControlRegister() {
        return this.control;
    }
}

