/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery.browser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import net.benhui.btgallery.Util;
import net.benhui.btgallery.browser.BBRemoteDevice;
import net.benhui.btgallery.browser.BBServiceRecord;
import net.benhui.btgallery.browser.DeviceDetailsUI;
import net.benhui.btgallery.browser.ListServicesUI;
import net.benhui.btgallery.browser.MessageUI;
import net.benhui.btgallery.browser.RemoteDeviceUI;
import net.benhui.btgallery.browser.SearchCriteriaUI;
import net.benhui.btgallery.browser.ServiceDetailsUI;
import net.benhui.btgallery.browser.ServiceSummaryUI;
import net.benhui.btgallery.browser.ShowValueUI;
import net.benhui.btgallery.browser.UploadFormUI;

public class BTBrowserMain
extends MIDlet
implements CommandListener {
    DiscoveryAgent agent;
    LocalDevice device;
    private DeviceDetailsUI devicedetailsui = null;
    public static Vector devices = new Vector();
    public static Display display;
    public static BTBrowserMain instance;
    boolean isUseHomeUrl = false;
    private ListServicesUI listservicesui = null;
    private MessageUI messageui = null;
    public RemoteDeviceUI remotedeviceui = null;
    private SearchCriteriaUI searchcriteriaui = null;
    public static int selectedDevice;
    public static int selectedService;
    private ServiceDetailsUI servicedetailsui = null;
    public static Vector services;
    private ServiceSummaryUI servicesummaryui = null;
    private ShowValueUI showvalueui = null;
    public String uploadComment = "BT Browser rocks!";
    public String uploadRemoteDevice = "e.g. Moto V600";
    public int uploadSelectedDevice = 0;
    UploadThread uploadThread = null;
    public String uploaderName = "Ben";
    private UploadFormUI uploadformui = null;

    static {
        services = new Vector();
        selectedDevice = -1;
        selectedService = -1;
    }

    public BTBrowserMain() {
        instance = this;
    }

    public static void alert(String msg, AlertType alert_type, Displayable next_screen) {
        Alert alert = new Alert("Info", msg, (Image)null, alert_type);
        alert.setTimeout(3000);
        display.setCurrent(alert, next_screen);
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.remotedeviceui && c.getLabel().equals("Device Inquiry")) {
            try {
                devices.removeAllElements();
                this.device = LocalDevice.getLocalDevice();
                this.device.setDiscoverable(10390323);
                this.agent = this.device.getDiscoveryAgent();
                this.agent.startInquiry(10390323, (DiscoveryListener)new Listener(10390323));
                this.remotedeviceui.setMsg("[ Please Wait... ]");
            }
            catch (BluetoothStateException e) {
                e.printStackTrace();
            }
        } else if (d == this.remotedeviceui && c.getLabel().equals("Device Details")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            this.devicedetailsui.showui();
            display.setCurrent((Displayable)this.devicedetailsui);
        } else if (d == this.remotedeviceui && c.getLabel().equals("Explore Services")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
            if (remoteDevice.hasServiceRecord && !this.searchcriteriaui.selectionChanged) {
                services = remoteDevice.serviceRecords;
                this.listservicesui.showui();
                display.setCurrent((Displayable)this.listservicesui);
            } else {
                this.searchcriteriaui.selectionChanged = false;
                services.removeAllElements();
                try {
                    int[] attr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 256, 257, 258, 512, 513, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 784, 785, 786, 787};
                    BTBrowserMain.log("Search UUID is " + Util.uuidToName(new UUID((long)this.searchcriteriaui.selectValue)));
                    this.agent.searchServices(attr, new UUID[]{new UUID((long)this.searchcriteriaui.selectValue)}, remoteDevice.original, (DiscoveryListener)new Listener());
                    this.remotedeviceui.setMsg("[ Please Wait... ]");
                }
                catch (BluetoothStateException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (d == this.remotedeviceui && c.getLabel().equals("Exit")) {
            BTBrowserMain.quitApp();
        } else if (d == this.remotedeviceui && c.getLabel().equals("About BT Browser")) {
            Alert alert = new Alert("About", "BT Browser 2.0. (c) 2004 By Ben Hui. www.benhui.net", null, AlertType.INFO);
            alert.setTimeout(-2);
            display.setCurrent(alert, (Displayable)this.remotedeviceui);
        } else if (d == this.remotedeviceui && c.getLabel().equals("Save Device")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
            if (!remoteDevice.hasServiceRecord) {
                BTBrowserMain.alert("This device services are not retrieved. Explore records first. Cannot save.", AlertType.ERROR, (Displayable)this.remotedeviceui);
            } else if (remoteDevice.presistentMode != 0) {
                BTBrowserMain.alert("This device already saved before. Cannot save again.", AlertType.ERROR, (Displayable)this.remotedeviceui);
            } else {
                this.save();
                this.remotedeviceui.showui();
            }
        } else if (d == this.remotedeviceui && c.getLabel().equals("Load Devices")) {
            Enumeration enumeration = devices.elements();
            while (enumeration.hasMoreElements()) {
                BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)enumeration.nextElement());
                if (remoteDevice.presistentMode != 1) continue;
                devices.removeElement((Object)remoteDevice);
            }
            this.load();
            this.remotedeviceui.showui();
        } else if (d == this.remotedeviceui && c.getLabel().equals("Remove Saved Device")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
            if (remoteDevice.presistentMode != 1) {
                BTBrowserMain.alert("This device has not been saved. Cannot remove this device.", AlertType.ERROR, (Displayable)this.remotedeviceui);
            } else {
                this.delete(remoteDevice.rmsRecordId);
            }
        } else if (d == this.remotedeviceui && c.getLabel().equals("Upload Device")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
            if (!remoteDevice.hasServiceRecord) {
                BTBrowserMain.alert("This device service records are not retrieved. Explore records first.", AlertType.ERROR, (Displayable)this.remotedeviceui);
            } else {
                this.uploadformui.showui();
                display.setCurrent((Displayable)this.uploadformui);
            }
        } else if (d == this.remotedeviceui && c.getLabel().equals("View Debug Logs")) {
            this.messageui.backTo = 0;
            display.setCurrent((Displayable)this.messageui);
            this.messageui.repaint();
        } else if (d == this.remotedeviceui && c.getLabel().equals("Search Criteria")) {
            this.searchcriteriaui.showui();
            display.setCurrent((Displayable)this.searchcriteriaui);
        } else if (d == this.listservicesui && c.getLabel().equals("View Debug Logs")) {
            this.messageui.backTo = 1;
            display.setCurrent((Displayable)this.messageui);
            this.messageui.repaint();
        } else if (d == this.servicedetailsui && c.getLabel().equals("View Debug Logs")) {
            this.messageui.backTo = 2;
            display.setCurrent((Displayable)this.messageui);
            this.messageui.repaint();
        } else if (d == this.listservicesui && c.getLabel().equals("Service Summary")) {
            selectedService = this.listservicesui.getSelectedIndex();
            this.servicesummaryui.showui();
            display.setCurrent((Displayable)this.servicesummaryui);
        } else if (d == this.listservicesui && c.getLabel().equals("Explore Records")) {
            selectedService = this.listservicesui.getSelectedIndex();
            this.servicedetailsui.showui();
            display.setCurrent((Displayable)this.servicedetailsui);
        } else if (d == this.listservicesui && c.getLabel().equals("Refresh")) {
            BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
            if (remoteDevice.presistentMode == 1) {
                BTBrowserMain.alert("Device is stored. Cannot refresh this device", AlertType.ERROR, (Displayable)this.listservicesui);
                return;
            }
            remoteDevice.hasServiceRecord = false;
            services.removeAllElements();
            try {
                int[] attr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 256, 257, 258, 512, 513, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 784, 785, 786, 787};
                BTBrowserMain.log("Search UUID is " + Util.uuidToName(new UUID((long)this.searchcriteriaui.selectValue)));
                this.agent.searchServices(attr, new UUID[]{new UUID((long)this.searchcriteriaui.selectValue)}, remoteDevice.original, (DiscoveryListener)new Listener());
                this.remotedeviceui.setMsg("[ Please Wait... ]");
                display.setCurrent((Displayable)this.remotedeviceui);
            }
            catch (BluetoothStateException ex) {
                ex.printStackTrace();
            }
        } else if (d == this.listservicesui && c.getLabel().equals("Back")) {
            this.remotedeviceui.showui();
            display.setCurrent((Displayable)this.remotedeviceui);
        } else if (d == this.devicedetailsui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.remotedeviceui);
        } else if (d == this.servicesummaryui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.listservicesui);
        } else if (d == this.servicedetailsui && c.getLabel().equals("View Value")) {
            int select = this.servicedetailsui.getSelectedIndex();
            String[] value = (String[])this.servicedetailsui.map.get(new Integer(select));
            if (value != null) {
                this.showvalueui.clear();
                this.showvalueui.addStrings(value);
                display.setCurrent((Displayable)this.showvalueui);
            } else {
                Alert alert = new Alert("Problem!", "Cannot select this item", null, AlertType.ERROR);
                alert.setTimeout(3000);
                display.setCurrent(alert, (Displayable)this.servicedetailsui);
            }
        } else if (d == this.uploadformui && (c.getLabel().equals("Upload") || c.getLabel().equals("Upload(Home)"))) {
            this.uploadSelectedDevice = this.uploadformui.device_in.getSelectedIndex();
            this.uploadRemoteDevice = this.uploadformui.other_in.getString();
            this.uploaderName = this.uploadformui.name_in.getString();
            this.uploadComment = this.uploadformui.note_in.getString();
            this.savePref();
            this.isUseHomeUrl = c.getLabel().equals("Upload(Home)");
            this.upload();
            this.remotedeviceui.showui();
            display.setCurrent((Displayable)this.remotedeviceui);
        } else if (d == this.servicedetailsui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.listservicesui);
        } else if (d == this.servicedetailsui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.listservicesui);
        } else if (d == this.showvalueui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.servicedetailsui);
        } else if (d == this.messageui && c.getLabel().equals("Back")) {
            if (this.messageui.backTo == 0) {
                this.remotedeviceui.showui();
                display.setCurrent((Displayable)this.remotedeviceui);
            } else if (this.messageui.backTo == 1) {
                this.listservicesui.showui();
                display.setCurrent((Displayable)this.listservicesui);
            } else if (this.messageui.backTo == 2) {
                this.servicedetailsui.showui();
                display.setCurrent((Displayable)this.servicedetailsui);
            }
        } else if (d == this.searchcriteriaui && c.getLabel().equals("Back")) {
            this.remotedeviceui.showui();
            display.setCurrent((Displayable)this.remotedeviceui);
        } else if (d == this.uploadformui && c.getLabel().equals("Back")) {
            this.uploadSelectedDevice = this.uploadformui.device_in.getSelectedIndex();
            this.uploadRemoteDevice = this.uploadformui.other_in.getString();
            this.uploaderName = this.uploadformui.name_in.getString();
            this.uploadComment = this.uploadformui.note_in.getString();
            this.savePref();
            this.remotedeviceui.showui();
            display.setCurrent((Displayable)this.remotedeviceui);
        } else if (d == this.messageui && c.getLabel().equals("Insert Bookmark")) {
            this.messageui.msgs.addElement("------- BOOKMARK " + this.messageui.bookmarkId + " ----------");
            ++this.messageui.bookmarkId;
            this.messageui.repaint();
        } else if (d == this.messageui && c.getLabel().equals("Clear")) {
            this.messageui.clear();
        } else if (d == this.searchcriteriaui && c.getLabel().equals("OK")) {
            this.searchcriteriaui.selectIdx = this.searchcriteriaui.choice.getSelectedIndex();
            this.searchcriteriaui.selectValue = this.searchcriteriaui.value[this.searchcriteriaui.selectIdx];
            this.searchcriteriaui.selectionChanged = true;
            BTBrowserMain.log("User selected search value " + this.searchcriteriaui.protocol[this.searchcriteriaui.selectIdx]);
            this.remotedeviceui.showui();
            display.setCurrent((Displayable)this.remotedeviceui);
        }
    }

    public void delete(int record_id) {
        try {
            BTBrowserMain.log("delete record id: " + record_id);
            RecordStore store = RecordStore.openRecordStore((String)"btbrowser", (boolean)false);
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
            store.deleteRecord(record_id);
            devices.removeElement((Object)remoteDevice);
            this.remotedeviceui.showui();
            store.closeRecordStore();
            BTBrowserMain.log("delete done");
        }
        catch (Exception e) {
            e.printStackTrace();
            BTBrowserMain.err(e);
        }
    }

    public void destroyApp(boolean unconditional) {
    }

    public static void err(Exception e) {
        System.out.println(e.toString());
        BTBrowserMain.instance.messageui.msgs.addElement("ERR: " + e.getClass().getName() + " " + e.getMessage());
        BTBrowserMain.instance.messageui.repaint();
    }

    public void load() {
        try {
            BTBrowserMain.log("load");
            RecordStore store = RecordStore.openRecordStore((String)"btbrowser", (boolean)false);
            int rec_cnt = store.getNumRecords();
            RecordEnumeration recordEnumeration = store.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int rid = recordEnumeration.nextRecordId();
                byte[] raw = store.getRecord(rid);
                DataInputStream data_in = new DataInputStream(new ByteArrayInputStream(raw));
                String bt_address = data_in.readUTF();
                data_in.reset();
                BTBrowserMain.log("loading device address " + bt_address);
                BBRemoteDevice remoteDevice = new BBRemoteDevice(bt_address, data_in, rid);
                devices.addElement(remoteDevice);
                data_in.close();
            }
            store.closeRecordStore();
            BTBrowserMain.log("load done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadPref() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"btbrowserpref", (boolean)false);
            int rec_cnt = store.getNumRecords();
            byte[] raw = store.getRecord(1);
            ByteArrayInputStream byte_in = new ByteArrayInputStream(raw);
            DataInputStream data_in = new DataInputStream(byte_in);
            this.uploadSelectedDevice = data_in.readInt();
            this.uploadRemoteDevice = data_in.readUTF();
            this.uploaderName = data_in.readUTF();
            this.uploadComment = data_in.readUTF();
            store.closeRecordStore();
        }
        catch (RecordStoreNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log(String s) {
        System.out.println(s);
        BTBrowserMain.instance.messageui.msgs.addElement(s);
        BTBrowserMain.instance.messageui.repaint();
    }

    public void pauseApp() {
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public void save() {
        try {
            int new_rec_id;
            BTBrowserMain.log("save selectedDevice:" + selectedDevice);
            RecordStore store = RecordStore.openRecordStore((String)"btbrowser", (boolean)true);
            int rec_cnt = store.getNumRecords();
            ByteArrayOutputStream byte_out = new ByteArrayOutputStream();
            DataOutputStream data_out = new DataOutputStream(byte_out);
            BBRemoteDevice remoteDevice = null;
            if (selectedDevice != -1) {
                remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
                remoteDevice.serialize(data_out);
            } else {
                BTBrowserMain.alert("Please select a device first", AlertType.ERROR, (Displayable)this.remotedeviceui);
            }
            data_out.flush();
            byte[] raw = byte_out.toByteArray();
            remoteDevice.rmsRecordId = new_rec_id = store.addRecord(raw, 0, raw.length);
            BTBrowserMain.log("saved " + raw.length + " bytes to record id " + new_rec_id);
            data_out.close();
            store.closeRecordStore();
            remoteDevice.presistentMode = 1;
            BTBrowserMain.alert("Device " + remoteDevice.getFriendlyName(false) + " is saved to record #" + new_rec_id + " (" + raw.length + "bytes)", AlertType.INFO, (Displayable)this.remotedeviceui);
            BTBrowserMain.log("save done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void savePref() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"btbrowserpref", (boolean)true);
            int rec_cnt = store.getNumRecords();
            ByteArrayOutputStream byte_out = new ByteArrayOutputStream();
            DataOutputStream data_out = new DataOutputStream(byte_out);
            data_out.writeInt(this.uploadSelectedDevice);
            data_out.writeUTF(this.uploadRemoteDevice);
            data_out.writeUTF(this.uploaderName);
            data_out.writeUTF(this.uploadComment);
            data_out.flush();
            byte[] raw = byte_out.toByteArray();
            if (rec_cnt == 1) {
                store.setRecord(1, raw, 0, raw.length);
            } else if (rec_cnt == 0) {
                store.addRecord(raw, 0, raw.length);
            } else {
                System.out.println("ERROR: Corrupted data store");
            }
            data_out.close();
            store.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startApp() {
        display = Display.getDisplay((MIDlet)this);
        this.remotedeviceui = new RemoteDeviceUI();
        this.devicedetailsui = new DeviceDetailsUI();
        this.listservicesui = new ListServicesUI();
        this.servicesummaryui = new ServiceSummaryUI();
        this.servicedetailsui = new ServiceDetailsUI();
        this.showvalueui = new ShowValueUI();
        this.uploadformui = new UploadFormUI();
        this.messageui = new MessageUI();
        this.searchcriteriaui = new SearchCriteriaUI();
        this.remotedeviceui.showui();
        display.setCurrent((Displayable)this.remotedeviceui);
        try {
            this.device = LocalDevice.getLocalDevice();
        }
        catch (Throwable e) {
            Alert alert = new Alert("Problem!", "Cannot initialize Java Bluetooth. This device does not support BT Browser. You must Exit BT Browser.", (Image)null, AlertType.ERROR);
            alert.setTimeout(-2);
            display.setCurrent(alert, (Displayable)this.remotedeviceui);
        }
        this.loadPref();
    }

    public void upload() {
        if (this.uploadThread != null) {
            BTBrowserMain.alert("Another upload is in progress, please try again later. (If this keep happening, you may need to restart BT Browser)", AlertType.INFO, (Displayable)this.remotedeviceui);
        } else {
            this.uploadThread = new UploadThread();
            this.uploadThread.start();
        }
    }

    private void upload_internal() {
        try {
            BTBrowserMain.log("upload selectedDevice: " + selectedDevice);
            ByteArrayOutputStream byte_out = new ByteArrayOutputStream();
            byte[] signature = new byte[]{66, 84, 66, 82, 79, 87, 83, 50, 48, 1};
            byte_out.write(signature);
            DataOutputStream data_out = new DataOutputStream(byte_out);
            String upload_device_name = UploadFormUI.names[this.uploadSelectedDevice];
            data_out.writeUTF(this.uploaderName);
            data_out.writeUTF(upload_device_name);
            data_out.writeUTF(this.uploadRemoteDevice);
            data_out.writeUTF(this.uploadComment);
            data_out.writeUTF(this.device.getBluetoothAddress());
            data_out.writeInt(this.device.getDeviceClass().getMajorDeviceClass() | this.device.getDeviceClass().getMinorDeviceClass() | this.device.getDeviceClass().getServiceClasses());
            data_out.writeInt(this.device.getDiscoverable());
            data_out.writeUTF(this.device.getFriendlyName());
            data_out.writeInt(10);
            data_out.writeUTF("bluetooth.api.version");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.api.version"));
            data_out.writeUTF("bluetooth.l2cap.receiveMTU.max");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.l2cap.receiveMTU.max"));
            data_out.writeUTF("bluetooth.connected.devices.max");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.connected.devices.max"));
            data_out.writeUTF("bluetooth.connected.inquiry");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.connected.inquiry"));
            data_out.writeUTF("bluetooth.connected.page");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.connected.page"));
            data_out.writeUTF("bluetooth.connected.inquiry.scan");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.connected.inquiry.scan"));
            data_out.writeUTF("bluetooth.connected.page.scan");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.connected.page.scan"));
            data_out.writeUTF("bluetooth.master.switch");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.master.switch"));
            data_out.writeUTF("bluetooth.sd.trans.max");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.sd.trans.max"));
            data_out.writeUTF("bluetooth.sd.attr.retrievable.max");
            data_out.writeUTF(LocalDevice.getProperty((String)"bluetooth.sd.attr.retrievable.max"));
            data_out.writeInt(0);
            BBRemoteDevice remoteDevice = null;
            if (selectedDevice != -1) {
                remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
                if (!remoteDevice.hasServiceRecord) {
                    BTBrowserMain.alert("Select a device to upload.", AlertType.INFO, (Displayable)this.remotedeviceui);
                    return;
                }
            } else {
                BTBrowserMain.alert("Select a device to upload.", AlertType.INFO, (Displayable)this.remotedeviceui);
                return;
            }
            remoteDevice.serialize(data_out);
            data_out.flush();
            byte[] raw = byte_out.toByteArray();
            BTBrowserMain.log("going to write " + raw.length + " bytes to server");
            String url = "http://www.benhui.net/servlet/net.benhui.bbserver.BTServiceRecordUpload";
            if (this.isUseHomeUrl) {
                url = "http://24.101.33.84:85/bbupload";
            }
            BTBrowserMain.log("connecting to " + url);
            HttpConnection con = (HttpConnection)Connector.open((String)url);
            BTBrowserMain.log("connection open ok");
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Length", String.valueOf(raw.length));
            BTBrowserMain.log("connection set header ok");
            OutputStream http_out = con.openOutputStream();
            BTBrowserMain.log("connection open output stream ok");
            http_out.write(raw);
            http_out.flush();
            BTBrowserMain.log("connection write and flush ok");
            int code = con.getResponseCode();
            BTBrowserMain.log("HTTP Code: " + code);
            con.close();
            BTBrowserMain.alert("Device " + remoteDevice.getFriendlyName(false) + " has been uploaded to www.benhui.net", AlertType.INFO, (Displayable)this.remotedeviceui);
        }
        catch (Exception e) {
            BTBrowserMain.alert("An error has occurs while uploading. (" + e.getClass().getName() + " " + e.getMessage() + ")", AlertType.ERROR, (Displayable)this.remotedeviceui);
            e.printStackTrace();
        }
    }

    public class UploadThread
    extends Thread {
        public void run() {
            BTBrowserMain.this.upload_internal();
            BTBrowserMain.this.uploadThread = null;
        }
    }

    class Listener
    implements DiscoveryListener {
        int discoveryMode = 10390323;
        long end;
        long start = System.currentTimeMillis();

        public Listener(int mode) {
            this.discoveryMode = mode;
        }

        public Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            BTBrowserMain.log("A remote Bluetooth device is discovered:");
            Util.printRemoteDevice(remoteDevice, deviceClass);
            BBRemoteDevice bb_remoteDevice = new BBRemoteDevice(remoteDevice, deviceClass, this.discoveryMode);
            devices.addElement(bb_remoteDevice);
        }

        public void inquiryCompleted(int complete) {
            BTBrowserMain.log("device discovery is completed with return code:" + complete);
            BTBrowserMain.log("" + devices.size() + " devices are discovered");
            try {
                this.end = System.currentTimeMillis();
                BTBrowserMain.log("device inquiry time " + (this.end - this.start) + " ms");
                if (devices.size() == 0) {
                    Alert alert = new Alert("Problem!", "No Bluetooth device found", null, AlertType.INFO);
                    alert.setTimeout(3000);
                    BTBrowserMain.this.remotedeviceui.setMsg("[ Press Inquiry ]");
                    display.setCurrent(alert, (Displayable)BTBrowserMain.this.remotedeviceui);
                } else {
                    int i = 0;
                    while (i < devices.size()) {
                        ((BBRemoteDevice)((Object)BTBrowserMain.devices.elementAt((int)i))).inquiryTime = this.end - this.start;
                        ((BBRemoteDevice)((Object)BTBrowserMain.devices.elementAt((int)i))).inquiryCount = devices.size();
                        ++i;
                    }
                    BTBrowserMain.this.remotedeviceui.showui();
                    display.setCurrent((Displayable)BTBrowserMain.this.remotedeviceui);
                }
            }
            catch (Exception e) {
                BTBrowserMain.err(e);
            }
        }

        public void serviceSearchCompleted(int transId, int complete) {
            BTBrowserMain.log("service discovery completed with return code:" + complete);
            BTBrowserMain.log("" + services.size() + " services are discovered");
            BBRemoteDevice remoteDevice = (BBRemoteDevice)((Object)devices.elementAt(selectedDevice));
            remoteDevice.serviceRecords = services;
            remoteDevice.hasServiceRecord = true;
            this.end = System.currentTimeMillis();
            remoteDevice.discoveryTime = this.end - this.start;
            BTBrowserMain.log("service discovery time " + (this.end - this.start) + " ms");
            BTBrowserMain.this.listservicesui.showui();
            display.setCurrent((Displayable)BTBrowserMain.this.listservicesui);
        }

        public void servicesDiscovered(int transId, ServiceRecord[] records) {
            BTBrowserMain.log("Remote Bluetooth services is discovered:");
            int i = 0;
            while (i < records.length) {
                ServiceRecord record = records[i];
                Util.printServiceRecord(record);
                services.addElement(new BBServiceRecord(record));
                ++i;
            }
        }
    }
}

