/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class XList
extends Canvas {
    XItem header = null;
    Vector list = new Vector();
    int first_row = 0;
    int highlight_row = -1;
    int last_row = 0;
    CommandListener xlistener = null;
    public static final Command SELECT_COMMAND = List.SELECT_COMMAND;
    static final boolean[] actions = new boolean[]{true, false, false, false};

    public void paint(Graphics g) {
        Font f = Font.getFont((int)32, (int)0, (int)0);
        int fh = f.getHeight();
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, w, h);
        int y = 0;
        if (this.header != null) {
            y += fh;
            g.setColor(230, 230, 230);
            g.fillRoundRect(0, 0, w - 4, fh, 4, 4);
            g.setColor(0);
            if (this.header.s1 != null) {
                g.drawString(this.header.s1, 1, y, 36);
            }
            if (this.header.s2 != null) {
                g.drawString(this.header.s2, w - 4, y, 40);
            }
        }
        int i = this.first_row;
        while (i < this.list.size()) {
            int j;
            XItem item = (XItem)this.list.elementAt(i);
            int rh = 0;
            boolean singleLine = false;
            String[] c1 = null;
            if (item.s1 != null) {
                c1 = this.breakup(item.s1, w, f);
                rh += c1.length * fh;
            }
            String[] c2 = null;
            if (item.s2 != null) {
                c2 = this.breakup(item.s2, w, f);
                boolean bl = singleLine = c1 != null && c1.length == 1 && c2.length == 1 && f.stringWidth(c1[0]) + f.stringWidth(c2[0]) <= w;
                if (!singleLine) {
                    rh += c2.length * fh;
                }
            }
            if (this.highlight_row != -1 && i == this.highlight_row) {
                g.setColor(96, 96, 255);
                g.fillRect(0, y, w, rh);
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(0);
            }
            if (c1 != null) {
                j = 0;
                while (j < c1.length) {
                    g.drawString(c1[j], 1, y += fh, 36);
                    ++j;
                }
            }
            if (c2 != null) {
                if (singleLine) {
                    g.drawString(c2[0], w - 4, y, 40);
                } else {
                    j = 0;
                    while (j < c2.length) {
                        g.drawString(c2[j], w - 4, y += fh, 40);
                        ++j;
                    }
                }
            }
            if (item.line) {
                g.setColor(0);
                g.drawLine(0, y, w, y);
                g.setColor(128, 128, 128);
                g.drawLine(0, y + 1, w, y + 1);
            }
            if (y + fh > h) {
                this.last_row = i;
                break;
            }
            this.last_row = i++;
        }
        if (this.list.size() > 0) {
            int x2 = w - 3;
            g.setColor(0xFFFFFF);
            g.fillRect(x2 - 1, 0, 4, h);
            g.setColor(168, 168, 255);
            g.fillRect(x2, 2, 3, h - 2);
            g.setColor(96, 96, 255);
            int y2 = this.first_row * (h - 2) / this.list.size();
            int h2 = (this.last_row - this.first_row + 1) * (h - 2) / this.list.size();
            g.fillRect(x2, y2, 3, h2);
        }
    }

    public int size() {
        return this.list.size();
    }

    public String getString(int idx) {
        return ((XItem)this.list.elementAt((int)idx)).s1;
    }

    public Image getImage(int idx) {
        return ((XItem)this.list.elementAt((int)idx)).img;
    }

    public int append(String string, Image image) {
        return this.append(string, null, image);
    }

    public void insert(int idx, String string, Image image) {
        XItem item = new XItem(string, null, image);
        this.list.insertElementAt(item, idx);
        this.repaint();
    }

    public void delete(int idx) {
        this.list.removeElementAt(idx);
        if (idx == this.highlight_row) {
            if (this.list.size() == 0) {
                this.highlight_row = -1;
            } else {
                this.highlight_row = 0;
                ((XItem)this.list.elementAt((int)0)).select = true;
            }
        }
        this.repaint();
    }

    public void set(int idx, String string, Image image) {
        this.set(idx, string, null, image);
    }

    public boolean isSelected(int idx) {
        return ((XItem)this.list.elementAt((int)idx)).select;
    }

    public int getSelectedIndex() {
        int i = 0;
        while (i < this.list.size()) {
            if (((XItem)this.list.elementAt((int)i)).select) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSelectedIndex(int idx, boolean select) {
        ((XItem)this.list.elementAt((int)idx)).select = select;
        if (select) {
            this.highlight_row = idx;
        }
        this.repaint();
    }

    public String getString2(int idx) {
        return ((XItem)this.list.elementAt((int)idx)).s2;
    }

    public void deleteAll() {
        this.list.removeAllElements();
        this.first_row = 0;
        this.last_row = 0;
        this.highlight_row = -1;
        this.repaint();
    }

    public void set(int idx, String string, String string2, Image image) {
        XItem item = (XItem)this.list.elementAt(idx);
        item.s1 = string;
        item.s2 = string2;
        item.img = image;
        this.list.setElementAt(item, idx);
        this.repaint();
    }

    public int append(String string, String string2, Image image) {
        int idx = this.list.size();
        XItem item = new XItem(string, string2, image);
        if (idx == 0) {
            this.highlight_row = 0;
            item.select = true;
        }
        this.list.addElement(item);
        this.repaint();
        return idx;
    }

    public void setHeader(String string, String string2, Image image) {
        XItem _header;
        this.header = _header = new XItem(string, string2, image);
        this.repaint();
    }

    public void addLine() {
        int i = this.list.size() - 1;
        if (i >= 0) {
            XItem item = (XItem)this.list.elementAt(i);
            item.line = true;
        }
    }

    public void showTop() {
        this.first_row = 0;
        this.highlight_row = -1;
        this.last_row = 0;
    }

    private final String[] breakup(String src, int w, Font f) {
        Vector<String> result = new Vector<String>();
        int last_sp = -1;
        int start = 0;
        while (true) {
            int sp;
            if ((sp = src.indexOf(32, last_sp + 1)) == -1) break;
            if (f.substringWidth(src, start, sp - start) > w - 4) {
                result.addElement(src.substring(start, last_sp));
                last_sp = start = last_sp + 1;
                continue;
            }
            last_sp = sp;
        }
        result.addElement(src.substring(start));
        Object[] str = new String[result.size()];
        result.copyInto(str);
        return str;
    }

    protected void keyReleased(int key) {
        if (this.getGameAction(key) == 1) {
            if (this.highlight_row > 0) {
                XItem item = (XItem)this.list.elementAt(this.highlight_row);
                item.select = false;
                --this.highlight_row;
                XItem item2 = (XItem)this.list.elementAt(this.highlight_row);
                item2.select = true;
                if (this.highlight_row <= this.first_row) {
                    this.first_row = this.highlight_row;
                }
            }
        } else if (this.getGameAction(key) == 6) {
            if (this.highlight_row < this.list.size() - 1) {
                if (this.highlight_row > -1) {
                    XItem item = (XItem)this.list.elementAt(this.highlight_row);
                    item.select = false;
                }
                ++this.highlight_row;
                XItem item2 = (XItem)this.list.elementAt(this.highlight_row);
                item2.select = true;
                if (this.highlight_row > this.last_row) {
                    this.first_row = this.highlight_row - (this.last_row - this.first_row);
                }
            }
        } else if (this.getGameAction(key) == 8 && this.xlistener != null) {
            this.xlistener.commandAction(SELECT_COMMAND, (Displayable)this);
        } else if (this.getGameAction(key) == 9 && this.xlistener != null && actions[0]) {
            this.xlistener.commandAction(SELECT_COMMAND, (Displayable)this);
        } else if (this.getGameAction(key) == 10 && this.xlistener != null && actions[1]) {
            this.xlistener.commandAction(SELECT_COMMAND, (Displayable)this);
        } else if (this.getGameAction(key) == 11 && this.xlistener != null && actions[2]) {
            this.xlistener.commandAction(SELECT_COMMAND, (Displayable)this);
        } else if (this.getGameAction(key) == 12 && this.xlistener != null && actions[3]) {
            this.xlistener.commandAction(SELECT_COMMAND, (Displayable)this);
        }
        this.repaint();
        super.keyReleased(key);
    }

    public void setCommandListener(CommandListener listener) {
        this.xlistener = listener;
        super.setCommandListener(listener);
    }

    private final class XItem {
        String s1 = null;
        String s2 = null;
        boolean select;
        Image img;
        boolean line = false;

        public XItem(String s1, String s2, Image img) {
            this.s1 = s1;
            this.s2 = s2;
            this.img = img;
        }
    }
}

