/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery.browser;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.DataElement;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import net.benhui.btgallery.browser.BBRemoteDevice;

public class BBServiceRecord
implements ServiceRecord {
    public int[] attributeIds = new int[0];
    public Hashtable map = new Hashtable();
    public RemoteDevice hostDevice;
    public ServiceRecord originalServiceRecord = null;

    public BBServiceRecord(ServiceRecord src) {
        this.originalServiceRecord = src;
        this.hostDevice = src.getHostDevice();
        this.attributeIds = src.getAttributeIDs();
        this.deep_copy_service_record(src);
    }

    public BBServiceRecord(BBRemoteDevice host_device, DataInputStream data_in) {
        this.originalServiceRecord = null;
        this.hostDevice = host_device;
        this.deserialize(data_in);
    }

    public DataElement getAttributeValue(int parm1) {
        if (this.originalServiceRecord != null) {
            return this.originalServiceRecord.getAttributeValue(parm1);
        }
        Integer int_obj = new Integer(parm1);
        return (DataElement)this.map.get(int_obj);
    }

    public RemoteDevice getHostDevice() {
        if (this.originalServiceRecord != null) {
            return this.originalServiceRecord.getHostDevice();
        }
        return this.hostDevice;
    }

    public int[] getAttributeIDs() {
        if (this.originalServiceRecord != null) {
            return this.originalServiceRecord.getAttributeIDs();
        }
        return this.attributeIds;
    }

    private void deep_copy_service_record(ServiceRecord src) {
        int i = 0;
        while (i < this.attributeIds.length) {
            DataElement e = src.getAttributeValue(this.attributeIds[i]);
            DataElement e2 = this.deep_copy_data_element(e, this.attributeIds[i]);
            this.map.put(new Integer(this.attributeIds[i]), e2);
            ++i;
        }
    }

    private DataElement deep_copy_data_element(DataElement e, int id) {
        int type = e.getDataType();
        if (type == 56 || type == 48) {
            DataElement e1 = new DataElement(type);
            Enumeration enumeration = (Enumeration)e.getValue();
            while (enumeration.hasMoreElements()) {
                DataElement e2 = (DataElement)enumeration.nextElement();
                DataElement e3 = this.deep_copy_data_element(e2, id);
                e1.addElement(e3);
            }
            return e1;
        }
        if (type == 8 || type == 9 || type == 10 || type == 16 || type == 17 || type == 18 || type == 19) {
            long v = e.getLong();
            return new DataElement(type, v);
        }
        if (type == 24) {
            UUID uuid = (UUID)e.getValue();
            return new DataElement(type, (Object)uuid);
        }
        if (type == 11 || type == 12 || type == 20) {
            byte[] v = (byte[])e.getValue();
            return new DataElement(type, (Object)v);
        }
        if (type == 32 || type == 64) {
            String v = (String)e.getValue();
            return new DataElement(type, (Object)v);
        }
        if (type == 40) {
            boolean v = e.getBoolean();
            return new DataElement(v);
        }
        if (type == 0) {
            return new DataElement(type);
        }
        return null;
    }

    public void serialize(DataOutputStream data_out) {
        try {
            data_out.writeInt(this.attributeIds.length);
            int i = 0;
            while (i < this.attributeIds.length) {
                data_out.writeInt(this.attributeIds[i]);
                DataElement e = (DataElement)this.map.get(new Integer(this.attributeIds[i]));
                this.deep_serialize_data_element(e, data_out);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deep_serialize_data_element(DataElement e, DataOutputStream data_out) {
        try {
            int type = e.getDataType();
            data_out.writeInt(type);
            if (type == 56 || type == 48) {
                int size = e.getSize();
                data_out.writeInt(size);
                Enumeration enumeration = (Enumeration)e.getValue();
                while (enumeration.hasMoreElements()) {
                    DataElement e2 = (DataElement)enumeration.nextElement();
                    this.deep_serialize_data_element(e2, data_out);
                }
                return;
            }
            if (type == 8 || type == 9 || type == 10 || type == 16 || type == 17 || type == 18 || type == 19) {
                long v = e.getLong();
                data_out.writeLong(v);
                return;
            }
            if (type == 24) {
                UUID uuid = (UUID)e.getValue();
                data_out.writeUTF(uuid.toString());
                return;
            }
            if (type == 11 || type == 12 || type == 20) {
                byte[] v = (byte[])e.getValue();
                data_out.writeInt(v.length);
                data_out.write(v);
                return;
            }
            if (type == 32 || type == 64) {
                String v = (String)e.getValue();
                data_out.writeUTF(v);
                return;
            }
            if (type == 40) {
                boolean v = e.getBoolean();
                data_out.writeBoolean(v);
                return;
            }
            if (type != 0) return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return;
    }

    public void deserialize(DataInputStream data_in) {
        try {
            int length = data_in.readInt();
            this.attributeIds = new int[length];
            int i = 0;
            while (i < this.attributeIds.length) {
                this.attributeIds[i] = data_in.readInt();
                DataElement e = this.deep_deserialize_data_element(data_in);
                this.map.put(new Integer(this.attributeIds[i]), e);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DataElement deep_deserialize_data_element(DataInputStream data_in) {
        try {
            int type = data_in.readInt();
            if (type == 56 || type == 48) {
                int size = data_in.readInt();
                DataElement e = new DataElement(type);
                int i = 0;
                while (i < size) {
                    DataElement e2 = this.deep_deserialize_data_element(data_in);
                    e.addElement(e2);
                    ++i;
                }
                return e;
            }
            if (type == 8 || type == 9 || type == 10 || type == 16 || type == 17 || type == 18 || type == 19) {
                long v = data_in.readLong();
                return new DataElement(type, v);
            }
            if (type == 24) {
                String v = data_in.readUTF();
                UUID uuid = new UUID(v, false);
                return new DataElement(type, (Object)uuid);
            }
            if (type == 11 || type == 12 || type == 20) {
                int length = data_in.readInt();
                byte[] v = new byte[length];
                data_in.read(v);
                return new DataElement(type, (Object)v);
            }
            if (type == 32 || type == 64) {
                String v = data_in.readUTF();
                return new DataElement(type, (Object)v);
            }
            if (type == 40) {
                boolean v = data_in.readBoolean();
                return new DataElement(v);
            }
            if (type == 0) {
                return new DataElement(type);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean populateRecord(int[] parm1) throws IOException {
        if (this.originalServiceRecord != null) {
            return this.originalServiceRecord.populateRecord(parm1);
        }
        return false;
    }

    public String getConnectionURL(int parm1, boolean parm2) {
        if (this.originalServiceRecord != null) {
            return this.originalServiceRecord.getConnectionURL(parm1, parm2);
        }
        return null;
    }

    public void setDeviceServiceClasses(int parm1) {
        if (this.originalServiceRecord != null) {
            this.originalServiceRecord.setDeviceServiceClasses(parm1);
        }
    }

    public boolean setAttributeValue(int parm1, DataElement parm2) {
        if (this.originalServiceRecord != null) {
            return this.originalServiceRecord.setAttributeValue(parm1, parm2);
        }
        return false;
    }
}

