/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery.bluelet;

import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;
import net.benhui.btgallery.Util;
import net.benhui.btgallery.bluelet.RemoteDeviceUI;

public class BLUElet
implements CommandListener {
    public static Command COMPLETED = new Command("COMPLETED", 1, 1);
    public static Command SELECTED = new Command("SELECTED", 1, 1);
    public static Command BACK = new Command("Back", 2, 1);
    public static MIDlet host;
    public static CommandListener callback;
    public static BLUElet instance;
    public static Display display;
    public static Vector devices;
    public static Vector deviceClasses;
    public static Vector services;
    public static int selectedDevice;
    public int discoveryMode;
    public UUID[] serviceUUIDs = null;
    public int deviceReturnCode;
    public int serviceReturnCode;
    private RemoteDeviceUI remotedeviceui = null;
    private LocalDevice device;
    private DiscoveryAgent agent;
    private static final int ID_SERVICE_COMPLETED = 1;
    private static final int ID_DEVICE_COMPLETED = 2;
    private static final int ID_DEVICE_SELECTED = 3;

    public BLUElet(MIDlet host, CommandListener listener) {
        BLUElet.host = host;
        callback = listener;
        instance = this;
    }

    public void startApp() {
        display = Display.getDisplay((MIDlet)host);
        this.remotedeviceui = new RemoteDeviceUI();
        this.remotedeviceui.showui();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public static void log(String s) {
        System.out.println(s);
    }

    public Screen getUI() {
        return this.remotedeviceui;
    }

    public ServiceRecord[] getDiscoveredServices() {
        Object[] r = new ServiceRecord[services.size()];
        services.copyInto(r);
        return r;
    }

    public ServiceRecord getFirstDiscoveredService() {
        if (services.size() > 0) {
            return (ServiceRecord)services.elementAt(0);
        }
        return null;
    }

    public int getDeviceDiscoveryReturnCode() {
        return this.deviceReturnCode;
    }

    public int getServiceDiscoveryReturnCode() {
        return this.serviceReturnCode;
    }

    public RemoteDevice getSelectedDevice() {
        if (selectedDevice != -1) {
            return (RemoteDevice)devices.elementAt(selectedDevice);
        }
        return null;
    }

    public void startInquiry(int mode, UUID[] serviceUUIDs) {
        try {
            this.discoveryMode = mode;
            this.serviceUUIDs = serviceUUIDs;
            devices.removeAllElements();
            deviceClasses.removeAllElements();
            this.device = LocalDevice.getLocalDevice();
            this.device.setDiscoverable(10390323);
            this.agent = this.device.getDiscoveryAgent();
            boolean result = this.agent.startInquiry(mode, (DiscoveryListener)new Listener());
            this.remotedeviceui.setMsg("[Please Wait...]");
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.remotedeviceui && c.getLabel().equals("Search")) {
            this.startInquiry(this.discoveryMode, this.serviceUUIDs);
        } else if (d == this.remotedeviceui && c.getLabel().equals("Back")) {
            callback.commandAction(BACK, (Displayable)this.remotedeviceui);
        } else if (d == this.remotedeviceui && c.getLabel().equals("Select")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            RemoteDevice remoteDevice = (RemoteDevice)devices.elementAt(selectedDevice);
            services.removeAllElements();
            try {
                this.agent.searchServices(null, this.serviceUUIDs, remoteDevice, (DiscoveryListener)new Listener());
                display.callSerially((Runnable)new Worker(3));
            }
            catch (BluetoothStateException ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        devices = new Vector();
        deviceClasses = new Vector();
        services = new Vector();
        selectedDevice = -1;
    }

    class Worker
    implements Runnable {
        int cmd = 0;

        public Worker(int cmd) {
            this.cmd = cmd;
        }

        public void run() {
            switch (this.cmd) {
                case 1: {
                    callback.commandAction(COMPLETED, (Displayable)BLUElet.this.remotedeviceui);
                    break;
                }
                case 2: {
                    callback.commandAction(COMPLETED, (Displayable)BLUElet.this.remotedeviceui);
                    break;
                }
                case 3: {
                    callback.commandAction(SELECTED, (Displayable)BLUElet.this.remotedeviceui);
                    break;
                }
            }
        }
    }

    class Listener
    implements DiscoveryListener {
        Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            BLUElet.log("A remote Bluetooth device is discovered:");
            Util.printRemoteDevice(remoteDevice, deviceClass);
            devices.addElement(remoteDevice);
            deviceClasses.addElement(deviceClass);
        }

        public void inquiryCompleted(int complete) {
            BLUElet.log("device discovery is completed with return code:" + complete);
            BLUElet.log("" + devices.size() + " devices are discovered");
            BLUElet.this.deviceReturnCode = complete;
            if (devices.size() == 0) {
                Alert alert = new Alert("Bluetooth", "No Bluetooth device found", null, AlertType.INFO);
                alert.setTimeout(3000);
                BLUElet.this.remotedeviceui.showui();
                display.setCurrent(alert, (Displayable)BLUElet.this.remotedeviceui);
            } else {
                BLUElet.this.remotedeviceui.showui();
                display.setCurrent((Displayable)BLUElet.this.remotedeviceui);
            }
        }

        public void servicesDiscovered(int transId, ServiceRecord[] records) {
            BLUElet.log("Remote Bluetooth services is discovered:");
            for (int i = 0; i < records.length; ++i) {
                ServiceRecord record = records[i];
                Util.printServiceRecord(record);
                services.addElement(record);
            }
        }

        public void serviceSearchCompleted(int transId, int complete) {
            BLUElet.log("service discovery completed with return code:" + complete);
            BLUElet.log("" + services.size() + " services are discovered");
            BLUElet.this.serviceReturnCode = complete;
            display.callSerially((Runnable)new Worker(1));
        }
    }
}

