/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import utilitare.FCTicker;

public class FCTextBox {
    public String boxText;
    public String boxTitle;
    public String boxCommLeft;
    public String boxCommMiddle;
    public String boxCommRight;
    public Font textFont;
    public int lineSpacing;
    public int posX;
    public int posY;
    public int bWidth;
    public int bHeight;
    public boolean multiLine;
    public boolean hasBorder;
    public boolean isScrollable;
    public int textColor;
    public int borderColor;
    public int backColor;
    public Image backImage;
    public int textMode;
    public int borderType;
    public int scrollOffset = 0;
    public int scrollOffsetBar = 0;
    public int maxScrollOffset = 0;
    private Vector tWords = new Vector();
    private Vector tLines = new Vector();
    private Vector jLines = new Vector();
    private int lineHeight = 1;
    private int spacingHeight = 1;
    private int noBoxLines = 0;
    private FCTicker titleTicker;

    public FCTextBox(String boxtext, String boxtitle, String boxcommLeft, String boxcommMiddle, String boxcommRight, Font textfont, int linespacing, int posx, int posy, int bwidth, int bheight, boolean hasborder, boolean isscrollable, int textcolor, int bordercolor, int backcolor, Image backimage, int textmode, int bordertype) {
        this.textFont = textfont;
        this.lineSpacing = linespacing;
        this.posX = posx + this.textFont.charWidth('A');
        this.posY = posy + this.textFont.getHeight();
        this.bWidth = bwidth - 2 * this.textFont.charWidth('A');
        this.bHeight = bheight - 3 * this.textFont.getHeight();
        this.hasBorder = hasborder;
        this.isScrollable = isscrollable;
        this.textColor = textcolor;
        this.borderColor = bordercolor;
        this.backColor = backcolor;
        this.backImage = backimage;
        this.textMode = textmode;
        this.borderType = bordertype;
        this.setText(boxtext);
        this.boxTitle = boxtitle;
        this.boxCommLeft = boxcommLeft;
        this.boxCommMiddle = boxcommMiddle;
        this.boxCommRight = boxcommRight;
        this.titleTicker = new FCTicker(this.boxTitle, this.textFont, posx + 3 * this.textFont.charWidth('A'), posy, bwidth - 6 * this.textFont.charWidth('A'), 0xFFFFFF, 0, this.backImage, 0);
    }

    public void draw(Graphics g) {
        int cX = g.getClipX();
        int cY = g.getClipY();
        int cWid = g.getClipWidth();
        int cHei = g.getClipHeight();
        this.drawBox(g);
        this.drawMultiline(g);
        this.titleTicker.draw(g);
        g.setClip(cX, cY, cWid, cHei);
    }

    public void scrollDown() {
        if (this.isScrollable && this.scrollOffset - 1 >= 0) {
            --this.scrollOffset;
            this.computeScrollOff();
        }
    }

    public void scrollUp() {
        if (this.isScrollable && this.scrollOffset + 1 <= this.maxScrollOffset) {
            ++this.scrollOffset;
            this.computeScrollOff();
        }
    }

    public void setText(String boxtext) {
        this.boxText = boxtext;
        this.tWords.removeAllElements();
        this.tWords = this.splitStringVector(this.boxText, " ", true);
        this.tLines.removeAllElements();
        int tmpncuv = this.tWords.size();
        for (int ii = 0; ii < tmpncuv; ++ii) {
            if (this.textFont.stringWidth((String)this.tWords.elementAt(ii)) <= this.bWidth - 4) continue;
            this.tWords.removeElementAt(ii);
        }
        String tLine = "";
        for (int ii = 0; ii < this.tWords.size(); ++ii) {
            if (((String)this.tWords.elementAt(ii)).indexOf("&fcnl;") >= 0) {
                this.tLines.addElement(tLine);
                tLine = "";
                continue;
            }
            if (this.textFont.stringWidth(tLine + (String)this.tWords.elementAt(ii)) < this.bWidth - 4) {
                tLine = tLine + (String)this.tWords.elementAt(ii) + " ";
                continue;
            }
            this.tLines.addElement(tLine);
            tLine = (String)this.tWords.elementAt(ii) + " ";
        }
        if (tLine != "") {
            this.tLines.addElement(tLine);
        }
        this.justifyText();
        this.lineHeight = this.textFont.getHeight();
        this.spacingHeight = this.lineSpacing * this.lineHeight / 100;
        this.noBoxLines = (this.bHeight - 2) / (this.lineHeight + this.spacingHeight);
        if (this.noBoxLines > this.tLines.size()) {
            this.noBoxLines = this.tLines.size();
            this.isScrollable = false;
        }
        this.scrollOffset = 0;
        this.maxScrollOffset = this.tLines.size() - this.noBoxLines;
        this.computeScrollOff();
    }

    private void computeScrollOff() {
        if (this.isScrollable) {
            float py = (float)this.scrollOffset / (float)this.maxScrollOffset;
            this.scrollOffsetBar = (int)(py * (float)this.bHeight);
        }
    }

    private void justifyText() {
        int lineDiff;
        int ii;
        int spaceWidth;
        int tWid;
        this.jLines.removeAllElements();
        if (this.textMode == 0) {
            for (int ii2 = 0; ii2 < this.tLines.size(); ++ii2) {
                this.jLines.addElement((String)this.tLines.elementAt(ii2));
            }
        }
        if (this.textMode == 1) {
            tWid = this.bWidth - 2;
            spaceWidth = this.textFont.charWidth(' ');
            for (ii = 0; ii < this.tLines.size(); ++ii) {
                lineDiff = (tWid - this.textFont.stringWidth((String)this.tLines.elementAt(ii))) / spaceWidth;
                String[] ltWords = this.splitString((String)this.tLines.elementAt(ii), " ", true);
                int xx = 0;
                while (xx < ltWords.length) {
                    int n = xx++;
                    ltWords[n] = ltWords[n] + " ";
                }
                int cntXX = 0;
                for (int yy = lineDiff; yy > 0; --yy) {
                    int n = cntXX++;
                    ltWords[n] = ltWords[n] + " ";
                    if (cntXX != ltWords.length) continue;
                    cntXX = 0;
                }
                String jLine = "";
                for (int jj = 0; jj < ltWords.length; ++jj) {
                    jLine = jLine + ltWords[jj];
                }
                this.jLines.addElement(jLine);
            }
        }
        if (this.textMode == 2) {
            tWid = this.bWidth - 2;
            spaceWidth = this.textFont.charWidth(' ');
            for (ii = 0; ii < this.tLines.size(); ++ii) {
                lineDiff = (tWid - this.textFont.stringWidth((String)this.tLines.elementAt(ii))) / spaceWidth;
                String jLine = "";
                for (int yy = 0; yy < lineDiff; ++yy) {
                    jLine = jLine + " ";
                }
                jLine = jLine + this.tLines.elementAt(ii);
                this.jLines.addElement(jLine);
            }
        }
    }

    private void drawBox(Graphics g) {
        int px = this.posX - this.textFont.charWidth('A');
        int py = this.posY - this.textFont.getHeight();
        int bw = this.bWidth + 2 * this.textFont.charWidth('A');
        int bh = this.bHeight + 3 * this.textFont.getHeight();
        g.clipRect(px, py, bw, bh);
        g.setColor(this.backColor);
        g.fillRect(px, py, bw, bh);
        if (this.backImage != null) {
            int nx = bw / this.backImage.getWidth() + 1;
            int ny = bh / this.backImage.getHeight() + 1;
            for (int ii = 0; ii < nx; ++ii) {
                for (int jj = 0; jj < ny; ++jj) {
                    g.drawImage(this.backImage, ii * this.backImage.getWidth(), jj * this.backImage.getHeight(), 0);
                }
            }
        }
        int midd = px + bw / 2;
        g.setColor(this.textColor);
        g.drawString(this.boxCommLeft, px + 1, py + bh - 1, 36);
        g.drawString(this.boxCommMiddle, midd, py + bh - 1, 33);
        g.drawString(this.boxCommRight, px + bw - 1, py + bh - 1, 40);
        if (this.hasBorder && this.borderType == 0) {
            int ppx = px + (this.posX - px) / 2;
            int ppy = py + (this.posY - py) / 2;
            int bbw = this.posX + this.bWidth + (this.posX - px) / 2;
            int bbh2 = this.posY + this.bHeight + this.textFont.getHeight() / 2;
            g.setColor(this.borderColor);
            int l1 = this.posX + 2 * this.textFont.charWidth('A');
            int l2 = this.posX + this.bWidth - 2 * this.textFont.charWidth('A');
            g.drawLine(ppx, ppy, l1, ppy);
            g.drawLine(l2, ppy, bbw, ppy);
            g.drawLine(bbw, ppy, bbw, bbh2);
            g.drawLine(bbw, bbh2, ppx, bbh2);
            g.drawLine(ppx, bbh2, ppx, ppy);
        }
    }

    private void drawMultiline(Graphics g) {
        if (!this.isScrollable) {
            this.scrollOffset = 0;
        }
        g.setClip(this.posX + 1, this.posY + 1, this.bWidth - 2, this.bHeight - 2);
        g.setColor(this.textColor);
        for (int ii = 0; ii < this.noBoxLines; ++ii) {
            g.drawString((String)this.jLines.elementAt(ii + this.scrollOffset), this.posX + 2, this.posY + 2 + this.spacingHeight + ii * (this.spacingHeight + this.lineHeight), 0);
        }
        if (this.isScrollable) {
            int px = this.posX - this.textFont.charWidth('A');
            int py = this.posY - this.textFont.getHeight();
            int bw = this.bWidth + 2 * this.textFont.charWidth('A');
            int bh = this.bHeight + 3 * this.textFont.getHeight();
            g.setClip(px + bw - this.textFont.charWidth('A'), py, this.textFont.charWidth('A'), bh);
            g.setColor(this.borderColor);
            g.fillRect(px + bw - this.textFont.charWidth('A') / 2 - this.textFont.charWidth('A') / 4, this.posY, this.textFont.charWidth('A') / 2, this.bHeight);
            g.fillRect(px + bw - this.textFont.charWidth('A'), this.posY + this.scrollOffsetBar - this.textFont.getHeight() / 2, this.textFont.charWidth('A'), this.textFont.getHeight());
        }
    }

    private String[] splitString(String original, String separator, boolean removeEmpty) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            String part = original.substring(0, index);
            if (removeEmpty) {
                if (part.length() > 0) {
                    nodes.addElement(part);
                }
            } else {
                nodes.addElement(part);
            }
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            for (int loop = 0; loop < nodes.size(); ++loop) {
                result[loop] = (String)nodes.elementAt(loop);
            }
        }
        return result;
    }

    private Vector splitStringVector(String original, String separator, boolean removeEmpty) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            String part = original.substring(0, index);
            if (removeEmpty) {
                if (part.length() > 0) {
                    nodes.addElement(part);
                }
            } else {
                nodes.addElement(part);
            }
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        return nodes;
    }
}

