/*
 * Decompiled with CFR 0.152.
 */
package btchat;

import btchat.BTListener;
import btchat.ChatMain;
import btchat.EndPoint;
import btchat.Util;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class NetLayer
implements Runnable {
    public static final int SIGNAL_HANDSHAKE = 0;
    public static final int SIGNAL_MESSAGE = 1;
    public static final int SIGNAL_TERMINATE = 3;
    public static final int SIGNAL_HANDSHAKE_ACK = 4;
    public static final int SIGNAL_TERMINATE_ACK = 5;
    private static final UUID uuid = new UUID("102030405060708090A0B0C0D0E0F010", false);
    private static final int SERVICE_TELEPHONY = 0x400000;
    LocalDevice localDevice = null;
    DiscoveryAgent agent = null;
    StreamConnectionNotifier server;
    BTListener callback = null;
    boolean done = false;
    String localName = "";
    Vector endPoints = new Vector();
    Vector pendingEndPoints = new Vector();
    Hashtable serviceRecordToEndPoint = new Hashtable();
    Object lock = new Object();
    Timer timer = new Timer();

    public void init(String string, BTListener bTListener) {
        NetLayer.log("invoke init()");
        try {
            this.localName = string;
            this.callback = bTListener;
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.setDiscoverable(10390323);
            this.agent = this.localDevice.getDiscoveryAgent();
            Util.printLocalDevice(this.localDevice);
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (BluetoothStateException bluetoothStateException) {
            bluetoothStateException.printStackTrace();
            NetLayer.log(((Object)((Object)bluetoothStateException)).getClass().getName() + " " + bluetoothStateException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetLayer.log(iOException.getClass().getName() + " " + iOException.getMessage());
        }
    }

    public void disconnect() {
        NetLayer.log("invoke disconnect()");
        this.done = true;
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n = 0;
        while (n < this.endPoints.size()) {
            EndPoint endPoint = (EndPoint)this.endPoints.elementAt(n);
            endPoint.putString(3, "end");
            endPoint.sender.stop();
            endPoint.reader.stop();
            ++n;
        }
    }

    public void query() {
        try {
            NetLayer.log("invoke query()");
            this.agent.startInquiry(10390323, (DiscoveryListener)new Listener());
        }
        catch (BluetoothStateException bluetoothStateException) {
            bluetoothStateException.printStackTrace();
            NetLayer.log(((Object)((Object)bluetoothStateException)).getClass().getName() + " " + bluetoothStateException.getMessage());
        }
    }

    public EndPoint findEndPointByRemoteDevice(RemoteDevice remoteDevice) {
        int n = 0;
        while (n < this.endPoints.size()) {
            EndPoint endPoint = (EndPoint)this.endPoints.elementAt(n);
            if (endPoint.remoteDev.equals((Object)remoteDevice)) {
                return endPoint;
            }
            ++n;
        }
        return null;
    }

    public EndPoint findEndPointByTransId(int n) {
        int n2 = 0;
        while (n2 < this.pendingEndPoints.size()) {
            EndPoint endPoint = (EndPoint)this.pendingEndPoints.elementAt(n2);
            if (endPoint.transId == n) {
                return endPoint;
            }
            ++n2;
        }
        return null;
    }

    public void sendString(String string) {
        NetLayer.log("invoke sendString string=" + string);
        int n = 0;
        while (n < this.endPoints.size()) {
            EndPoint endPoint = (EndPoint)this.endPoints.elementAt(n);
            endPoint.putString(1, string);
            ++n;
        }
    }

    public void cleanupRemoteEndPoint(EndPoint endPoint) {
        NetLayer.log("invoke cleanupRemoteEndPoint()");
        endPoint.reader.stop();
        endPoint.sender.stop();
        this.endPoints.removeElement(endPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServiceRecord serviceRecord;
        StreamConnection streamConnection = null;
        try {
            this.server = (StreamConnectionNotifier)Connector.open((String)("btspp://localhost:" + uuid.toString() + ";name=BlueChatApp"));
            serviceRecord = this.localDevice.getRecord((Connection)this.server);
            serviceRecord.setAttributeValue(8, new DataElement(8, 255L));
            Util.printServiceRecord(serviceRecord);
            serviceRecord.setDeviceServiceClasses(0x400000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            NetLayer.log(exception.getClass().getName() + " " + exception.getMessage());
        }
        while (!this.done) {
            try {
                NetLayer.log("local service waiting for client connection");
                ChatMain.gui_log("", "Ready to accept connection. Wait...");
                streamConnection = this.server.acceptAndOpen();
                NetLayer.log("local service accept a new client connection");
                serviceRecord = RemoteDevice.getRemoteDevice((Connection)streamConnection);
                EndPoint endPoint = this.findEndPointByRemoteDevice((RemoteDevice)serviceRecord);
                if (endPoint != null) {
                    NetLayer.log("client connection end point already exist.. ignore this connection");
                    continue;
                }
                endPoint = new EndPoint(this, (RemoteDevice)serviceRecord, streamConnection);
                Thread thread = new Thread(endPoint.sender);
                thread.start();
                Thread thread2 = new Thread(endPoint.reader);
                thread2.start();
                this.endPoints.addElement(endPoint);
                NetLayer.log("a new active EndPoint is established. name=" + endPoint.remoteName);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                NetLayer.log(iOException.getClass().getName() + " " + iOException.getMessage());
                if (streamConnection == null) continue;
                try {
                    streamConnection.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    public static void log(String string) {
        System.out.println("NetLayer: " + string);
        if (ChatMain.isDebug) {
            ChatMain.gui_log("N", string);
        }
    }

    class DoServiceDiscovery
    extends TimerTask {
        DoServiceDiscovery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = 0;
            while (n < NetLayer.this.pendingEndPoints.size()) {
                EndPoint endPoint = (EndPoint)NetLayer.this.pendingEndPoints.elementAt(n);
                try {
                    NetLayer.log("search service on device " + endPoint.remoteName);
                    endPoint.transId = NetLayer.this.agent.searchServices(null, new UUID[]{uuid}, endPoint.remoteDev, (DiscoveryListener)new Listener());
                    Object object = NetLayer.this.lock;
                    synchronized (object) {
                        try {
                            NetLayer.this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (BluetoothStateException bluetoothStateException) {
                    bluetoothStateException.printStackTrace();
                    NetLayer.log(((Object)((Object)bluetoothStateException)).getClass().getName() + " " + bluetoothStateException.getMessage());
                }
                ++n;
            }
            NetLayer.this.pendingEndPoints.removeAllElements();
            ChatMain.gui_log("", "You can start chatting now");
        }
    }

    class Listener
    implements DiscoveryListener {
        Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            try {
                NetLayer.log("invoke deviceDiscovered name=" + remoteDevice.getFriendlyName(false));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                EndPoint endPoint = new EndPoint(NetLayer.this, remoteDevice, null);
                NetLayer.this.pendingEndPoints.addElement(endPoint);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                NetLayer.log(exception.getClass().getName() + " " + exception.getMessage());
            }
        }

        public void inquiryCompleted(int n) {
            NetLayer.log("invoke inqueryCompleted");
            NetLayer.this.timer.schedule((TimerTask)new DoServiceDiscovery(), 100L);
        }

        public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
            NetLayer.log("invoke servicesDiscovered:" + n + "," + serviceRecordArray.length);
            try {
                int n2 = 0;
                while (n2 < serviceRecordArray.length) {
                    Util.printServiceRecord(serviceRecordArray[n2]);
                    EndPoint endPoint = NetLayer.this.findEndPointByTransId(n);
                    NetLayer.this.serviceRecordToEndPoint.put(serviceRecordArray[n2], endPoint);
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                NetLayer.log(exception.getClass().getName());
                NetLayer.log(exception.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceSearchCompleted(int n, int n2) {
            Object object;
            NetLayer.log("invoke serviceSearchCompleted: " + n);
            if (n2 == 1) {
                NetLayer.log("SERVICE_SEARCH_COMPLETED");
            } else if (n2 == 2) {
                NetLayer.log("SERVICE_SEARCH_TERMINATED");
            } else if (n2 == 3) {
                NetLayer.log("SERVICE_SEARCH_ERROR");
            } else if (n2 == 4) {
                NetLayer.log("SERVICE_SEARCH_NO_RECORDS");
            } else if (n2 == 6) {
                NetLayer.log("SERVICE_SEARCH_DEVICE_NOT_REACHABLE");
            }
            Enumeration enumeration = NetLayer.this.serviceRecordToEndPoint.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    object = (ServiceRecord)enumeration.nextElement();
                    String string = object.getConnectionURL(0, false);
                    NetLayer.log("BlueChat service url=" + string);
                    StreamConnection streamConnection = (StreamConnection)Connector.open((String)string);
                    EndPoint endPoint = (EndPoint)NetLayer.this.serviceRecordToEndPoint.get(object);
                    if (endPoint != null) {
                        endPoint.con = streamConnection;
                        Thread thread = new Thread(endPoint.sender);
                        thread.start();
                        Thread thread2 = new Thread(endPoint.reader);
                        thread2.start();
                        NetLayer.this.endPoints.addElement(endPoint);
                        NetLayer.log("a new active EndPoint is established. name=" + endPoint.remoteName);
                        endPoint.putString(0, NetLayer.this.localName);
                        continue;
                    }
                    NetLayer.log("cannot find pending EndPoint when a service is discovered. ignore this service...");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    NetLayer.log(exception.getClass().getName() + " " + exception.getMessage());
                }
            }
            NetLayer.this.serviceRecordToEndPoint.clear();
            object = NetLayer.this.lock;
            synchronized (object) {
                NetLayer.this.lock.notifyAll();
            }
        }
    }
}

