/*
 * Decompiled with CFR 0.152.
 */
package btchat;

import btchat.BTListener;
import btchat.ChatPacket;
import btchat.NetLayer;
import btchat.Reader;
import btchat.Sender;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.StreamConnection;

public class EndPoint {
    RemoteDevice remoteDev;
    DeviceClass remoteClass;
    String remoteUrl;
    StreamConnection con;
    int transId = -1;
    Sender sender;
    Reader reader;
    String localName;
    String remoteName;
    BTListener callback;
    NetLayer btnet;
    Vector msgs = new Vector();

    public EndPoint(NetLayer netLayer, RemoteDevice remoteDevice, StreamConnection streamConnection) {
        this.btnet = netLayer;
        this.remoteDev = remoteDevice;
        try {
            this.remoteName = remoteDevice.getFriendlyName(false);
        }
        catch (IOException iOException) {
            this.remoteName = "Unknown";
        }
        this.localName = netLayer.localName;
        this.callback = netLayer.callback;
        this.con = streamConnection;
        this.sender = new Sender();
        this.sender.endpt = this;
        this.reader = new Reader();
        this.reader.endpt = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putString(int n, String string) {
        EndPoint.log("invoke putString " + n + " " + string);
        this.msgs.addElement(new ChatPacket(n, string));
        Sender sender = this.sender;
        synchronized (sender) {
            this.sender.notify();
        }
    }

    public synchronized ChatPacket getString() {
        if (this.msgs.size() > 0) {
            ChatPacket chatPacket = (ChatPacket)this.msgs.firstElement();
            this.msgs.removeElementAt(0);
            return chatPacket;
        }
        return null;
    }

    public synchronized boolean peekString() {
        return this.msgs.size() > 0;
    }

    private static void log(String string) {
        System.out.println("EndPoint: " + string);
    }
}

