/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.pandas;

import at.emini.physics2D.Body;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.TraceEffect;
import com.ximad.pvn.game.ninjas.Ninja;
import com.ximad.pvn.game.pandas.Panda;
import com.ximad.pvn.utils.ArrayList;

public class PandaMini
extends Panda {
    float lastPandaMiniX = 0.0f;
    float lastPandaMiniY = 0.0f;
    float currentPandaMiniX = 0.0f;
    float currentPandaMiniY = 0.0f;

    public void OnCollision(PhysicalGameObject obj, float force) {
        if (this == MyWorld.playerPanda && !this.isDying) {
            MyWorld.playerPanda = null;
            MyWorld.onFly = false;
            this.isDying = true;
        } else if (!this.isDying) {
            MyWorld.onFly = false;
            this.isDying = true;
        }
        if (obj.typeDinamicalObjects == 101) {
            Box2d.stopAngularVelocity(this.box2dId);
        }
    }

    public void ability() {
    }

    public static Body createPanda(int x, int y) {
        PandaMini panda = new PandaMini();
        panda.typeDinamicalObjects = 102;
        panda.isCircle = true;
        panda.isBullet = true;
        panda.restitution = 0;
        panda.friction = 9;
        panda.radius = 10;
        panda.density = 2;
        ArrayList shape = new ArrayList();
        shape.add(new Point(x, y));
        panda.setShape(shape, false, true);
        panda.frames = Textures.pandaGhostMini;
        panda.nFrames = 8;
        MyWorld.physicalGameObjects.add(panda);
        panda.mass = Box2d.getMass(panda.box2dId);
        panda.box2dId.setParent(panda);
        panda.box2dId.setInteracting(false);
        TraceEffect.createSpecialTrace(panda);
        return panda.box2dId;
    }

    public static Body createMainPanda(int x, int y) {
        PandaMini panda = new PandaMini();
        panda.typeDinamicalObjects = 102;
        panda.isCircle = true;
        panda.isBullet = true;
        panda.restitution = 0;
        panda.friction = 9;
        panda.radius = 10;
        panda.density = 2;
        ArrayList shape = new ArrayList();
        shape.add(new Point(x, y));
        panda.setShape(shape, false, true);
        panda.frames = Textures.pandaGhostMini;
        panda.nFrames = 8;
        MyWorld.physicalGameObjects.add(panda);
        panda.mass = Box2d.getMass(panda.box2dId);
        MyWorld.playerPanda = panda;
        if (x < MyWorld.center) {
            MyWorld.camera.setTargetById(panda);
        }
        Camera.setTarget(panda);
        panda.box2dId.setParent(panda);
        panda.box2dId.setInteracting(false);
        TraceEffect.createSpecialTrace(panda);
        return panda.box2dId;
    }

    private void checkNinjasContacts() {
        int x0 = this.box2dId.positionFX().xAsInt();
        int y0 = this.box2dId.positionFX().yAsInt();
        Object[] ninja = new Ninja[Ninja.ninjas.size()];
        Ninja.ninjas.copyInto(ninja);
        for (int i = 0; i < ninja.length; ++i) {
            int y;
            int dy;
            int x = ((Ninja)ninja[i]).box2dId.positionFX().xAsInt();
            int dx = x - x0;
            if (dx * dx + (dy = (y = ((Ninja)ninja[i]).box2dId.positionFX().yAsInt()) - y0) * dy >= 784) continue;
            ((Ninja)ninja[i]).OnCollision(this, 100.0f);
        }
        if (y0 > MyWorld.floor) {
            this.isDying = true;
            MyWorld.onFly = false;
        }
    }

    public void update(long dt) {
        this.checkNinjasContacts();
        this.checkDeadPanda(dt);
        if (MyWorld.onPlay && this.isFlyAnimationPlaying) {
            this.setFlyAnimationSequence();
            this.isFlyAnimationPlaying = false;
        }
        this.checkDistance();
    }
}

