/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.ParticleExplosion;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.obstacles.Obstacle;
import javax.microedition.lcdui.Graphics;

public class SpecialEffect
extends GameObject {
    int nexttick = 0;
    int cframe = 0;
    protected boolean show = true;

    public static void createPandaExplosion(PhysicalGameObject obj) {
        SpecialEffect effect = new SpecialEffect();
        effect.radius = Textures.explotion[0].getWidth() / 2;
        effect.position.x = Box2d.getCenterX(obj.box2dId) - effect.radius;
        effect.position.y = Box2d.getCenterY(obj.box2dId) - effect.radius;
        effect.nFrames = 10;
        effect.frames = Textures.explotion;
        effect.isAnimationPlaying = true;
        effect.setDefaultAnimationSequence();
        effect.repeatAnimation = false;
        effect.frameLength = 70;
        MyWorld.gameObjects.add(effect);
    }

    public static void createPandaExplosion(int x, int y) {
        SpecialEffect effect = new SpecialEffect();
        effect.radius = Textures.explotion[0].getWidth() / 2;
        effect.position.x = x - effect.radius;
        effect.position.y = y - effect.radius;
        effect.nFrames = 10;
        effect.frames = Textures.explotion;
        effect.isAnimationPlaying = true;
        effect.setDefaultAnimationSequence();
        effect.repeatAnimation = false;
        effect.frameLength = 70;
        MyWorld.gameObjects.add(effect);
    }

    public static void createSmoke(PhysicalGameObject obj) {
        SpecialEffect effect = new SpecialEffect();
        effect.position.x = Box2d.getCenterX(obj.box2dId) - Textures.smoke[0].getWidth() / 2;
        effect.position.y = (int)((float)Box2d.getCenterY(obj.box2dId) - (float)Textures.smoke[0].getWidth() / 1.2f);
        effect.nFrames = 11;
        effect.frames = Textures.smoke;
        effect.isAnimationPlaying = true;
        effect.setDefaultAnimationSequence();
        effect.repeatAnimation = false;
        effect.frameLength = 150;
        MyWorld.gameObjects.add(effect);
    }

    public static void createSmoke2(PhysicalGameObject obj) {
        SpecialEffect effect = new SpecialEffect();
        effect.position.x = Box2d.getCenterX(obj.box2dId) - Textures.smoke2[0].getWidth() / 2;
        effect.position.y = (int)((float)Box2d.getCenterY(obj.box2dId) - (float)Textures.smoke2[0].getWidth() / 1.2f);
        effect.nFrames = 11;
        effect.frames = Textures.smoke2;
        effect.isAnimationPlaying = true;
        effect.setDefaultAnimationSequence();
        effect.repeatAnimation = false;
        effect.frameLength = 150;
        MyWorld.gameObjects.add(effect);
    }

    public static void createDestroyObstacle(Obstacle obj) {
        ParticleExplosion.createParticleExplosion(obj);
    }

    public void draw(Graphics g) {
        if (this.nFrames > 0 && this.show) {
            this.frames[this.getCurrentFrame()].draw(g, this.position.x - Camera.position, this.position.y);
        }
    }

    public void update(long dt) {
        if (!this.show) {
            return;
        }
        this.nexttick = (int)((long)this.nexttick + dt);
        if (this.nexttick > this.frameLength) {
            if (!this.isAnimationPlaying) {
                this.setDefaultAnimationSequence();
            }
            if (this.cframe < this.animationSequence.size()) {
                this.defaultFrame = (Integer)this.animationSequence.get(this.cframe);
                ++this.cframe;
            } else {
                MyWorld.gameObjects.remove(this);
            }
            this.nexttick = 0;
        }
    }
}

