/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Contact;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;

public class Body {
    protected FXVector positionFX = new FXVector();
    protected FXVector velocityFX = new FXVector();
    protected FXVector virtualVelocityFX = new FXVector();
    protected int rotation2FX = 0;
    protected int angularVelocity2FX = 0;
    protected int virtualAngularVelocity2FX = 0;
    private FXMatrix j = FXMatrix.createRotationMatrix(0);
    private boolean k = true;
    boolean a = true;
    boolean b = true;
    boolean c = true;
    protected Shape shape;
    private FXVector[] l;
    FXVector[] d;
    private boolean m = false;
    private FXVector[] n;
    private boolean o = false;
    int e = 0;
    int f = 0;
    int g = 0;
    int h = 0;
    int i = 0;
    private int p = 0;
    private Contact[] q = new Contact[8];
    private boolean r = false;
    protected int id = -1;
    protected UserData userData = null;
    private static FXVector s = new FXVector();
    private static FXMatrix t = new FXMatrix();

    public Body(int n, int n2, Shape shape, boolean bl) {
        this.positionFX = new FXVector(n << 12, n2 << 12);
        this.shape = shape;
        this.initShapeInternals();
        this.a = bl;
        this.r = !bl;
    }

    public Body(FXVector fXVector, Shape shape, boolean bl) {
        this.positionFX = new FXVector(fXVector);
        this.shape = shape;
        this.initShapeInternals();
        this.a = bl;
        this.r = !bl;
    }

    public Body(Body body) {
        this.shape = body.shape;
        this.initShapeInternals();
        this.positionFX = new FXVector(body.positionFX);
        this.velocityFX = new FXVector(body.velocityFX);
        this.setRotation2FX(body.rotation2FX);
        this.angularVelocity2FX = body.angularVelocity2FX;
        this.i = body.i;
        this.a = body.a;
        this.k = body.k;
        this.c = body.c;
        this.b = body.b;
        if (body.userData != null) {
            this.userData = body.userData.copy();
        }
    }

    private Body() {
    }

    public Body copy() {
        return new Body(this);
    }

    public boolean equals(Body body) {
        return body.id == this.id && this.id != -1;
    }

    protected void initShapeInternals() {
        int n;
        this.l = new FXVector[this.shape.corners.length];
        this.d = new FXVector[this.shape.corners.length];
        for (n = 0; n < this.l.length; ++n) {
            this.l[n] = new FXVector();
            this.d[n] = new FXVector();
        }
        this.n = new FXVector[this.shape.b / 2];
        for (n = 0; n < this.n.length; ++n) {
            this.n[n] = new FXVector();
        }
        this.m = false;
        this.o = false;
    }

    public int getId() {
        return this.id;
    }

    public boolean isDynamic() {
        return this.a;
    }

    public boolean isResting() {
        return this.r;
    }

    public boolean canRotate() {
        return this.k;
    }

    public void setRotatable(boolean bl) {
        this.k = bl;
    }

    public boolean isInteracting() {
        return this.b;
    }

    public void setInteracting(boolean bl) {
        this.b = bl;
    }

    public boolean isAffectedByGravity() {
        return this.c;
    }

    public void setGravityAffected(boolean bl) {
        this.c = bl;
    }

    public void addCollisionLayer(int n) {
        this.i |= 1 << n;
    }

    public void removeCollisionLayer(int n) {
        this.i &= ~(1 << n);
    }

    public final long getInvMass2FX() {
        if (this.a) {
            return this.shape.g;
        }
        return 0L;
    }

    public final long getInvInertia2FX() {
        if (this.a) {
            return this.shape.i;
        }
        return 0L;
    }

    public void translate(FXVector fXVector) {
        this.positionFX.xFX += fXVector.xFX;
        this.positionFX.yFX += fXVector.yFX;
        this.m = false;
        this.o = false;
        this.calculateAABB(World.a);
    }

    public void forceUpdate() {
        this.m = false;
        this.o = false;
        this.calculateAABB(World.a);
    }

    public final FXVector getAbsoluePoint(FXVector fXVector) {
        fXVector = this.j.mult(fXVector);
        fXVector.xFX += this.positionFX.xFX;
        fXVector.yFX += this.positionFX.yFX;
        return fXVector;
    }

    public final void getAbsoluePoint(FXVector fXVector, FXVector fXVector2) {
        this.j.mult(fXVector, fXVector2);
        fXVector2.xFX += this.positionFX.xFX;
        fXVector2.yFX += this.positionFX.yFX;
    }

    public final FXVector getRelativePoint(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.subtract(this.positionFX);
        FXMatrix fXMatrix = FXMatrix.createRotationMatrix(this.rotation2FX);
        fXMatrix.invert();
        return fXMatrix.mult(fXVector);
    }

    public final FXVector getVelocity(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.crossScalar2FX(this.angularVelocity2FX);
        fXVector.xFX += this.velocityFX.xFX;
        fXVector.yFX += this.velocityFX.yFX;
        return fXVector;
    }

    protected final FXVector getVirtualVelocity(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.crossScalar2FX(this.virtualAngularVelocity2FX);
        fXVector.xFX += this.virtualVelocityFX.xFX;
        fXVector.yFX += this.virtualVelocityFX.yFX;
        return fXVector;
    }

    public final void getVelocity(FXVector fXVector, FXVector fXVector2) {
        fXVector2.xFX = fXVector.xFX;
        fXVector2.yFX = fXVector.yFX;
        fXVector2.crossScalar2FX(this.angularVelocity2FX);
        fXVector2.xFX += this.velocityFX.xFX;
        fXVector2.yFX += this.velocityFX.yFX;
    }

    protected final void getVirtualVelocity(FXVector fXVector, FXVector fXVector2) {
        fXVector2.xFX = fXVector.xFX;
        fXVector2.yFX = fXVector.yFX;
        fXVector2.crossScalar2FX(this.virtualAngularVelocity2FX);
        fXVector2.xFX += this.virtualVelocityFX.xFX;
        fXVector2.yFX += this.virtualVelocityFX.yFX;
    }

    public Shape shape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.initShapeInternals();
    }

    public final FXVector[] getVertices() {
        if (!this.m) {
            this.shape.getVerticesFX(this.positionFX, this.j, this.l);
            this.m = true;
        }
        return this.l;
    }

    public final FXVector[] getAxes() {
        if (!this.o) {
            if (!this.m) {
                this.getVertices();
            }
            for (int i = 0; i < this.n.length && this.shape.a[i << 1] >= 0; ++i) {
                this.n[i].assignDiff(this.l[this.shape.a[i << 1]], this.l[this.shape.a[(i << 1) + 1]]);
                this.n[i].normalize();
                this.n[i].turnRight();
            }
            this.o = true;
        }
        return this.n;
    }

    public int rotation2FX() {
        return this.rotation2FX;
    }

    public int angularVelocity2FX() {
        return this.angularVelocity2FX;
    }

    public FXMatrix getRotationMatrix() {
        return this.j;
    }

    public FXVector positionFX() {
        return this.positionFX;
    }

    public FXVector velocityFX() {
        return this.velocityFX;
    }

    public int rotationVelocity2FX() {
        return this.angularVelocity2FX;
    }

    public void setRotation2FX(int n) {
        this.rotation2FX = FXUtil.wrapAngleFX(n);
        this.j.setRotationMatrix(this.rotation2FX);
        this.m = false;
        this.o = false;
        this.r = false;
    }

    public void setRotationDeg(int n) {
        this.rotation2FX = (int)((long)n * 52707178L / 180L);
        while (this.rotation2FX < 0) {
            this.rotation2FX += 105414356;
        }
        while (this.rotation2FX > 105414356) {
            this.rotation2FX -= 105414356;
        }
        this.j.setRotationMatrix(this.rotation2FX);
        this.m = false;
        this.o = false;
    }

    public void setPositionFX(FXVector fXVector) {
        this.positionFX = fXVector;
    }

    public void angularVelocity2FX(int n) {
        this.angularVelocity2FX = n;
    }

    public void applyAcceleration(FXVector fXVector) {
        if (this.a && !this.r) {
            this.velocityFX.add(fXVector, World.a);
        }
    }

    public void applyForce(FXVector fXVector) {
        if (this.a && !this.r) {
            this.velocityFX.xFX += (int)(this.shape.g * (long)World.a >> (int)(12L * (long)fXVector.xFX) >> 24);
            this.velocityFX.yFX += (int)(this.shape.g * (long)World.a >> (int)(12L * (long)fXVector.yFX) >> 24);
        }
    }

    public final void applyMomentumAt(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.angularVelocity2FX -= (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.shape.i >> 12);
            }
            this.velocityFX.xFX += (int)(this.shape.g * (long)fXVector.xFX >> 24);
            this.velocityFX.yFX += (int)(this.shape.g * (long)fXVector.yFX >> 24);
        }
    }

    final void a(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.angularVelocity2FX += (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.shape.i >> 12);
            }
            this.velocityFX.xFX += (int)(-this.shape.g * (long)fXVector.xFX >> 24);
            this.velocityFX.yFX += (int)(-this.shape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyVirtualMomentumAt(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.virtualAngularVelocity2FX -= (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.shape.i >> 12);
            }
            this.virtualVelocityFX.xFX += (int)(this.shape.g * (long)fXVector.xFX >> 24);
            this.virtualVelocityFX.yFX += (int)(this.shape.g * (long)fXVector.yFX >> 24);
        }
    }

    final void b(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.virtualAngularVelocity2FX += (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.shape.i >> 12);
            }
            this.virtualVelocityFX.xFX += (int)(-this.shape.g * (long)fXVector.xFX >> 24);
            this.virtualVelocityFX.yFX += (int)(-this.shape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyMomentum(FXVector fXVector) {
        if (this.a && !this.r) {
            this.velocityFX.xFX += (int)(this.shape.g * (long)fXVector.xFX >> 24);
            this.velocityFX.yFX += (int)(this.shape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyTorque(int n) {
        if (this.a && this.k && !this.r) {
            this.angularVelocity2FX -= (int)(this.shape.i * (long)n >> 12);
        }
    }

    public final void integrateVelocity(int n) {
        if (!this.a || this.r) {
            return;
        }
        this.positionFX.add(this.velocityFX, n);
        this.setRotation2FX(this.rotation2FX - (int)((long)this.angularVelocity2FX * (long)n >> 12));
    }

    public final void integrateVirtualVelocity(int n) {
        if (!this.a || this.r) {
            return;
        }
        this.positionFX.add(this.virtualVelocityFX, n);
        this.setRotation2FX(this.rotation2FX - (int)((long)this.virtualAngularVelocity2FX * (long)n >> 12));
        this.virtualAngularVelocity2FX = 0;
        this.virtualVelocityFX.assignFX(0, 0);
    }

    protected final void calculateAABB(int n) {
        Object object = this.getVertices();
        this.e = this.f = object[0].xFX;
        this.g = this.h = object[0].yFX;
        if (this.shape instanceof MultiShape) {
            object = (MultiShape)this.shape;
            for (int i = 0; i < object.shapes.length; ++i) {
                this.a(object.shapes[i], object.vertexStartIndices[i], n);
            }
            return;
        }
        this.a(this.shape, 0, n);
    }

    private final void a(Shape shape, int n, int n2) {
        FXVector[] fXVectorArray = this.getVertices();
        if (shape.corners.length > 1) {
            int n3 = FXUtil.wrapAngleFX(this.rotation2FX - (int)((long)this.angularVelocity2FX * (long)n2 >> 12));
            t.setRotationMatrix(n3);
            FXVector[] fXVectorArray2 = shape.corners;
            FXVector fXVector = s;
            s.xFX = this.positionFX.xFX;
            fXVector.yFX = this.positionFX.yFX;
            fXVector.add(this.velocityFX, n2);
            for (n2 = 0; n2 < shape.corners.length; ++n2) {
                t.mult(fXVectorArray2[n2], this.d[n + n2]);
                this.d[n + n2].xFX += fXVector.xFX;
                this.d[n + n2].yFX += fXVector.yFX;
                this.d[n + n2].subtract(fXVectorArray[n + n2]);
            }
            n2 = n + shape.corners.length;
            for (int i = n; i < n2; ++i) {
                if (this.e > fXVectorArray[i].xFX) {
                    this.e = fXVectorArray[i].xFX;
                }
                if (this.f < fXVectorArray[i].xFX) {
                    this.f = fXVectorArray[i].xFX;
                }
                if (this.g > fXVectorArray[i].yFX) {
                    this.g = fXVectorArray[i].yFX;
                }
                if (this.h < fXVectorArray[i].yFX) {
                    this.h = fXVectorArray[i].yFX;
                }
                if (this.e > fXVectorArray[i].xFX + this.d[i].xFX) {
                    this.e = fXVectorArray[i].xFX + this.d[i].xFX;
                }
                if (this.f < fXVectorArray[i].xFX + this.d[i].xFX) {
                    this.f = fXVectorArray[i].xFX + this.d[i].xFX;
                }
                if (this.g > fXVectorArray[i].yFX + this.d[i].yFX) {
                    this.g = fXVectorArray[i].yFX + this.d[i].yFX;
                }
                if (this.h >= fXVectorArray[i].yFX + this.d[i].yFX) continue;
                this.h = fXVectorArray[i].yFX + this.d[i].yFX;
            }
            return;
        }
        int n4 = (int)((long)this.velocityFX.xFX * (long)n2) >> 12;
        int n5 = (int)((long)this.velocityFX.yFX * (long)n2) >> 12;
        if (this.e > this.positionFX.xFX - shape.c) {
            this.e = this.positionFX.xFX - shape.c;
        }
        if (this.f < this.positionFX.xFX + shape.c) {
            this.f = this.positionFX.xFX + shape.c;
        }
        if (this.g > this.positionFX.yFX - shape.c) {
            this.g = this.positionFX.yFX - shape.c;
        }
        if (this.h < this.positionFX.yFX + shape.c) {
            this.h = this.positionFX.yFX + shape.c;
        }
        if (this.e > this.positionFX.xFX - shape.c + n4) {
            this.e = this.positionFX.xFX - shape.c + n4;
        }
        if (this.f < this.positionFX.xFX + shape.c + n4) {
            this.f = this.positionFX.xFX + shape.c + n4;
        }
        if (this.g > this.positionFX.yFX - shape.c + n5) {
            this.g = this.positionFX.yFX - shape.c + n5;
        }
        if (this.h < this.positionFX.yFX + shape.c + n5) {
            this.h = this.positionFX.yFX + shape.c + n5;
        }
        this.d[n].xFX = this.velocityFX.xFX;
        this.d[n].yFX = this.velocityFX.yFX;
        this.d[n].multFX(n2);
    }

    protected final void updateVelocity(int n, int n2) {
        if (n < 4096) {
            this.velocityFX.multFX(n);
        }
        if (n2 < 4096) {
            this.angularVelocity2FX = (int)((long)this.angularVelocity2FX * (long)n2) >> 12;
        }
    }

    protected void resetContacts() {
        for (int i = 0; i < this.p; ++i) {
            if (!this.q[i].c && World.e < World.f.length) {
                World.f[World.e++] = this.q[i];
                this.q[i].c = true;
            }
            this.q[i] = null;
        }
        this.p = 0;
    }

    protected void addContact(Contact contact) {
        if (this.p < 8) {
            this.q[this.p] = contact;
            ++this.p;
        }
    }

    public Contact[] getContacts() {
        return this.q;
    }

    protected Contact getContact(Body body) {
        for (int i = 0; i < this.q.length && this.q[i] != null; ++i) {
            if (this.q[i].b != body && this.q[i].a != body) continue;
            return this.q[i];
        }
        return null;
    }

    protected Contact getContact(int n, Body body, int n2) {
        for (int i = 0; i < this.q.length && this.q[i] != null; ++i) {
            if ((this.q[i].b != body || n2 != 0 || n != 0) && (this.q[i].a != body || n2 != 0 || n != 0)) continue;
            return this.q[i];
        }
        return null;
    }

    public void setDynamic(boolean bl) {
        this.a = bl;
    }

    public int getAABBMinXFX() {
        return this.e;
    }

    public int getAABBMaxXFX() {
        return this.f;
    }

    public int getAABBMinYFX() {
        return this.g;
    }

    public int getAABBMaxYFX() {
        return this.h;
    }

    public int getColissionBitFlag() {
        return this.i;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }
}

