/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class AppSettings {
    private byte[] cache = new byte[0];
    private String key;
    private ByteArrayInputStream bais;
    private DataInputStream is;
    private ByteArrayOutputStream baos;
    private DataOutputStream os;

    public void init(String key) {
        try {
            this.key = key;
            RecordStore rms = RecordStore.openRecordStore((String)key, (boolean)true);
            try {
                RecordEnumeration re = rms.enumerateRecords(null, null, false);
                if (re.hasNextElement()) {
                    this.cache = re.nextRecord();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            rms.closeRecordStore();
            this.bais = new ByteArrayInputStream(this.cache);
            this.is = new DataInputStream(this.bais);
            this.baos = new ByteArrayOutputStream();
            this.os = new DataOutputStream(this.baos);
        }
        catch (Exception rse) {
            System.out.println("!! error in AppSettings.init() : " + rse.getMessage());
        }
    }

    public int readInt(int defaultValue) {
        try {
            return this.is.readInt();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean readBoolean(boolean defaultValue) {
        boolean k;
        try {
            k = this.is.readBoolean();
        }
        catch (Exception e) {
            k = false;
        }
        return k;
    }

    public long readLong(long defaultValue) {
        try {
            return this.is.readLong();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String readUTF(String defaultValue) {
        try {
            return this.is.readUTF();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void writeInt(int data) {
        try {
            this.os.writeInt(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeLong(long data) {
        try {
            this.os.writeLong(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeBoolean(boolean data) {
        try {
            this.os.writeBoolean(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeUTF(String data) {
        try {
            this.os.writeUTF(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
        try {
            RecordStore rms = RecordStore.openRecordStore((String)this.key, (boolean)true);
            try {
                RecordEnumeration re = rms.enumerateRecords(null, null, false);
                while (re.hasNextElement()) {
                    rms.deleteRecord(re.nextRecordId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cache = this.baos.toByteArray();
            rms.addRecord(this.cache, 0, this.cache.length);
            rms.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            System.out.println("!! error in AppSettings.commit : ()" + rse.getMessage());
        }
    }
}

