/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;

public class Spring
implements Constraint {
    private Body a;
    private Body b;
    private FXVector c;
    private FXVector d;
    private int e;
    protected UserData userData = null;
    private long f;
    private long g;
    private FXVector h = new FXVector();
    private int i;
    private FXVector j = new FXVector();
    private FXVector k = new FXVector();
    private long l;
    private int m = 0;
    private static FXVector n = new FXVector();
    private static FXVector o = new FXVector();
    private static FXVector p = new FXVector();
    protected int coefficientFX = 0;

    public Spring(Body body, Body body2, FXVector fXVector, FXVector fXVector2, int n) {
        this.a = body;
        this.b = body2;
        this.c = fXVector;
        this.d = fXVector2;
        if (n < 0) {
            this.calcDistance();
            return;
        }
        this.e = n << 12;
    }

    protected Spring(Spring spring, Body[] bodyArray) {
        if (bodyArray == null) {
            this.a = spring.a;
            this.b = spring.b;
        } else {
            this.a = bodyArray[spring.a.id];
            this.b = bodyArray[spring.b.id];
        }
        this.c = new FXVector(spring.c);
        this.d = new FXVector(spring.d);
        this.e = spring.e;
        this.coefficientFX = spring.coefficientFX;
        if (spring.userData != null) {
            this.userData = spring.userData.copy();
        }
    }

    public Constraint copy(Body[] bodyArray) {
        return new Spring(this, bodyArray);
    }

    private Spring() {
    }

    protected void calcDistance() {
        if (this.a != null && this.b != null) {
            this.a.getAbsoluePoint(this.c, o);
            this.b.getAbsoluePoint(this.d, p);
            FXVector fXVector = new FXVector(p);
            fXVector.subtract(o);
            this.e = fXVector.lengthFX();
        }
    }

    public void setCoefficient(int n) {
        this.coefficientFX = n * 4096;
    }

    public void setCoefficientFX(int n) {
        this.coefficientFX = n;
    }

    public int getCoefficientFX() {
        return this.coefficientFX;
    }

    public void setCollisionLayer(int n) {
        this.a.addCollisionLayer(n);
        this.b.addCollisionLayer(n);
    }

    public FXVector getPoint1() {
        return this.a.getAbsoluePoint(this.c);
    }

    public void getPoint1(FXVector fXVector) {
        this.a.getAbsoluePoint(this.c, fXVector);
    }

    public FXVector getPoint2() {
        return this.b.getAbsoluePoint(this.d);
    }

    public void getPoint2(FXVector fXVector) {
        this.b.getAbsoluePoint(this.d, fXVector);
    }

    public FXVector getRawPoint1() {
        return this.c;
    }

    public FXVector getRawPoint2() {
        return this.d;
    }

    public Body getBody1() {
        return this.a;
    }

    public Body getBody2() {
        return this.b;
    }

    public void precalculate() {
        this.a.getAbsoluePoint(this.c, o);
        this.b.getAbsoluePoint(this.d, p);
        this.h.assignDiff(p, o);
        this.i = this.h.lengthFX();
        if (this.i == 0) {
            return;
        }
        this.a.getRotationMatrix().mult(this.c, this.j);
        this.b.getRotationMatrix().mult(this.d, this.k);
        this.h.divideByFX(this.i);
        this.f = -((long)this.h.xFX * (long)this.j.yFX - (long)this.h.yFX * (long)this.j.xFX >> 12);
        this.g = -((long)this.h.xFX * (long)this.k.yFX - (long)this.h.yFX * (long)this.k.xFX >> 12);
        int n = (int)(this.a.getInvInertia2FX() * (this.f * this.f >> 12) >> 12);
        int n2 = (int)(this.b.getInvInertia2FX() * (this.g * this.g >> 12) >> 12);
        this.l = this.a.getInvMass2FX() + (long)n + this.b.getInvMass2FX() + (long)n2;
        if (this.coefficientFX > 0) {
            n = -((int)(((long)this.coefficientFX * (long)(this.e - this.i) << 12) / World.b >> 12));
            Spring.n.xFX = this.h.xFX;
            Spring.n.yFX = this.h.yFX;
            Spring.n.multFX(n);
            this.a.applyMomentumAt(Spring.n, this.j);
            Spring.n.mult(-1);
            this.b.applyMomentumAt(Spring.n, this.k);
        }
    }

    public void applyMomentum() {
        if (this.coefficientFX > 0 || this.l == 0L) {
            return;
        }
        long l = ((long)this.a.velocityFX.xFX * (long)this.h.xFX + (long)this.a.velocityFX.yFX * (long)this.h.yFX >> 12) - ((long)this.a.angularVelocity2FX * this.f >> 24) - ((long)this.b.velocityFX.xFX * (long)this.h.xFX + (long)this.b.velocityFX.yFX * (long)this.h.yFX >> 12) + ((long)this.b.angularVelocity2FX * this.g >> 24);
        int n = -((int)(((l += (1024L * (long)(this.e - this.i) >> 12) * World.b >> 12) << 24) / this.l));
        Spring.n.xFX = this.h.xFX;
        Spring.n.yFX = this.h.yFX;
        Spring.n.multFX(n);
        this.a.applyMomentumAt(Spring.n, this.j);
        Spring.n.mult(-1);
        this.b.applyMomentumAt(Spring.n, this.k);
        this.m += n;
    }

    public void postStep() {
    }

    public int getDistance() {
        return this.e >> 12;
    }

    public int getDistanceFX() {
        return this.e;
    }

    public void setDistanceFX(int n) {
        if (n < 0) {
            this.calcDistance();
            return;
        }
        this.e = n;
    }

    public int getImpulseFX() {
        return this.m;
    }

    public boolean concernsBody(Body body) {
        return this.a == body || this.b == body;
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Spring && ((Spring)constraint).a.equals(this.a) && ((Spring)constraint).b.equals(this.b) && ((Spring)constraint).c.xFX == this.c.xFX && ((Spring)constraint).c.yFX == this.c.yFX && ((Spring)constraint).d.xFX == this.d.xFX && ((Spring)constraint).d.yFX == this.d.yFX;
    }

    protected void setBody1(Body body) {
        this.a = body;
    }

    protected void setBody2(Body body) {
        this.b = body;
    }

    protected void setAbsolutePoint1(FXVector fXVector) {
        this.c = this.a.getRelativePoint(fXVector);
    }

    protected void setAbsolutePoint2(FXVector fXVector) {
        this.d = this.b.getRelativePoint(fXVector);
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }
}

