/*
 * Decompiled with CFR 0.152.
 */
package library.fs;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.file.FileConnection;
import library.fs.FilePtr;
import library.fs.FileSystem;

class FilePtrPdap
extends FilePtr {
    FileConnection fconn;
    InputStream is;
    OutputStream os;

    public FilePtrPdap(FileSystem fsys) {
        super(fsys);
    }

    public void Write(byte[] data, int pos, int len) throws IOException {
        if (this.os == null) {
            throw new IOException("Write() : invalid file mode");
        }
        this.os.write(data, pos, len);
    }

    public int Read(byte[] data, int pos, int len) throws IOException {
        if (this.is == null) {
            throw new IOException("Read() : invalid file mode");
        }
        return this.is.read(data, pos, len);
    }

    public int Read(byte[] data) throws IOException {
        if (this.is == null) {
            throw new IOException("Read() : invalid file mode");
        }
        return this.is.read(data);
    }

    public void Close() throws Exception {
        if (this.is != null) {
            this.is.close();
        } else if (this.os != null) {
            this.os.close();
        }
        this.fconn.close();
    }

    public DataInputStream GetDataInputStream() throws IOException {
        if (this.is == null) {
            throw new IOException("GetDataInputStream(): can't read");
        }
        return new DataInputStream(this.is);
    }

    public DataOutputStream GetDataOutputStream() throws IOException {
        if (this.os == null) {
            throw new IOException("GetDataOutputStream(): can't write");
        }
        return new DataOutputStream(this.os);
    }
}

