/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FileBrowsingCanvas
extends Canvas
implements FileActionInvoker,
Runnable {
    private static int stringIndex = 0;
    public static final int TXT_CLOSE = stringIndex++;
    public static final int TXT_VIEW = stringIndex++;
    public static final int TXT_SELECT = stringIndex++;
    public static final int TXT_BACK = stringIndex++;
    public static final int TXT_VIEW_IMAGE = stringIndex++;
    private static final char[][] systemText = new char[][]{"PRESS ANY KEY TO GO BACK".toCharArray(), "View".toCharArray(), "Select".toCharArray(), "Back".toCharArray(), "View Image".toCharArray()};
    private final int WIDTH;
    private final int HEIGHT;
    private static String ROOT = "/";
    private static String UP = "..";
    private int dirIndex = 0;
    private String currentDir = "/";
    private Vector dirList = new Vector();
    private int dirSize = 0;
    private int lastDirIndex = 0;
    private Image folderImage;
    private Image fileImage;
    private Image downArrowImage;
    private Image upArrowImage;
    public static final int TYPE_IMAGE_BROWSER = 0;
    private boolean stopped = false;
    private int browserType;
    private Font small_Font = Font.getFont((int)0, (int)0, (int)8);
    private Font medium_Font = Font.getFont((int)0, (int)0, (int)0);
    private int font_medium_Height;
    private int font_small_Height;
    private int font_medium_Width;
    private int font_small_Width;
    private int text_button_Width;
    private int visibleTopIndex;
    private int visibleBottomIndex;
    private int visibleBottomIndex_START;
    private Thread thread = null;
    private boolean showingImage = false;
    private Image image = null;
    private boolean dirIndexIsImage = false;
    protected FileAction fileAction = null;
    protected BinaryClockMidlet bcmidlet = null;
    private Displayable next;

    public FileBrowsingCanvas(BinaryClockMidlet binaryClockMidlet, Displayable displayable, int n) {
        this.setFullScreenMode(true);
        this.bcmidlet = binaryClockMidlet;
        this.next = displayable;
        this.browserType = n;
        this.fileAction = new FileAction(this);
        this.WIDTH = this.getWidth();
        this.HEIGHT = this.getHeight();
        this.setProperties();
        this.loadProgramImages();
        this.thread = new Thread(this);
        this.thread.start();
        new Thread(new Runnable(){

            public void run() {
                FileBrowsingCanvas.this.fileAction.getDirContent(FileBrowsingCanvas.this.currentDir);
            }
        }).start();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.WIDTH, this.HEIGHT);
        graphics.setColor(0);
        graphics.setFont(this.medium_Font);
        graphics.drawString("Image browser", 0, 0, 0);
        int n = this.visibleBottomIndex < this.dirSize ? this.visibleBottomIndex : this.dirSize;
        int n2 = 0;
        if (this.showingImage) {
            graphics.setColor(83, 148, 166);
            graphics.fillRect(0, 0, this.WIDTH, this.HEIGHT);
            graphics.setColor(0);
            graphics.setClip(10, 10, this.WIDTH - 20, this.HEIGHT - 20);
            graphics.drawImage(this.image, this.WIDTH / 2, this.HEIGHT / 2, 3);
            graphics.setClip(0, 0, this.WIDTH, this.HEIGHT);
            graphics.drawChars(systemText[TXT_CLOSE], 0, systemText[TXT_CLOSE].length, this.WIDTH, this.HEIGHT, 33);
        } else {
            for (int i = this.visibleTopIndex; i < n; ++i) {
                if (this.dirIndex == i) {
                    graphics.setColor(83, 148, 166);
                    graphics.drawRoundRect(0, this.font_medium_Height + (n2 + 1) * this.font_small_Height, this.WIDTH, this.font_small_Height, 4, 2);
                }
                if (i < this.lastDirIndex) {
                    graphics.drawImage(this.folderImage, 0, this.font_medium_Height + (n2 + 1) * this.font_small_Height, 0);
                } else {
                    graphics.drawImage(this.fileImage, 0, this.font_medium_Height + (n2 + 1) * this.font_small_Height, 0);
                }
                graphics.drawString((String)this.dirList.elementAt(i), 16, this.font_medium_Height + (n2 + 1) * this.font_small_Height, 0);
                graphics.setColor(0);
                ++n2;
            }
            graphics.setColor(83, 148, 166);
            if (this.visibleBottomIndex < this.dirSize) {
                graphics.drawImage(this.downArrowImage, this.WIDTH - 30, this.HEIGHT - this.font_medium_Height * 2 - 10, 0);
            }
            if (this.visibleTopIndex > 0) {
                graphics.drawImage(this.upArrowImage, this.WIDTH - 30, 0 + this.font_medium_Height, 0);
            }
            graphics.drawLine(0, this.HEIGHT - this.font_medium_Height * 2, this.WIDTH, this.HEIGHT - this.font_medium_Height * 2);
            graphics.drawChars(systemText[TXT_BACK], 0, systemText[TXT_BACK].length, 0, this.HEIGHT, 36);
            if (this.dirIndex < this.lastDirIndex) {
                graphics.drawChars(systemText[TXT_VIEW], 0, systemText[TXT_VIEW].length, 0, this.HEIGHT - this.font_medium_Height, 36);
            } else if (this.dirIndexIsImage) {
                graphics.drawChars(systemText[TXT_VIEW_IMAGE], 0, systemText[TXT_VIEW_IMAGE].length, 0, this.HEIGHT - this.font_medium_Height, 36);
                graphics.drawChars(systemText[TXT_SELECT], 0, systemText[TXT_SELECT].length, this.WIDTH, this.HEIGHT - this.font_medium_Height, 40);
            }
        }
        graphics.setColor(0, 0, 0);
    }

    public void keyPressed(int n) {
        if (this.showingImage) {
            this.showingImage = false;
            return;
        }
        switch (n) {
            case -1: {
                if (this.dirIndex == 0) {
                    return;
                }
                if (this.visibleTopIndex == 0) {
                    --this.dirIndex;
                    this.dirIndexIsImage = this.isImage((String)this.dirList.elementAt(this.dirIndex));
                    break;
                }
                --this.dirIndex;
                --this.visibleTopIndex;
                --this.visibleBottomIndex;
                this.dirIndexIsImage = this.isImage((String)this.dirList.elementAt(this.dirIndex));
                break;
            }
            case -2: {
                if (this.dirIndex >= this.dirList.size() - 1) {
                    return;
                }
                if (this.visibleBottomIndex > this.dirIndex + 1) {
                    ++this.dirIndex;
                    this.dirIndexIsImage = this.isImage((String)this.dirList.elementAt(this.dirIndex));
                    break;
                }
                ++this.dirIndex;
                ++this.visibleBottomIndex;
                ++this.visibleTopIndex;
                this.dirIndexIsImage = this.isImage((String)this.dirList.elementAt(this.dirIndex));
                break;
            }
            case -3: {
                break;
            }
            case -4: {
                break;
            }
            case -5: {
                if (this.dirIndexIsImage) {
                    this.loadImage();
                    break;
                }
                if (this.dirIndex >= this.lastDirIndex) break;
                this.traverse();
                break;
            }
            case -6: {
                if (this.dirIndexIsImage) {
                    this.loadImage();
                    break;
                }
                if (this.dirIndex >= this.lastDirIndex) break;
                this.traverse();
                break;
            }
            case -7: {
                if (!this.dirIndexIsImage) break;
                final String string = "file://" + this.currentDir + (String)this.dirList.elementAt(this.dirIndex);
                new Thread(new Runnable(){

                    public void run() {
                        FileBrowsingCanvas.this.bcmidlet.set_bg_image(string);
                    }
                }).start();
                this.stopped = true;
                BinaryClockMidlet.display.setCurrent(this.next);
                break;
            }
            case -11: {
                this.stopped = true;
                BinaryClockMidlet.display.setCurrent(this.next);
            }
        }
    }

    public void updateDirList(Enumeration enumeration, boolean bl) {
        if (enumeration == null) {
            return;
        }
        this.dirList.removeAllElements();
        this.lastDirIndex = 0;
        this.visibleTopIndex = 0;
        this.visibleBottomIndex = this.visibleBottomIndex_START;
        this.dirIndex = 0;
        if (!bl) {
            this.dirList.addElement("..");
            ++this.lastDirIndex;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.endsWith("/")) {
                this.dirList.insertElementAt(string, this.lastDirIndex);
                ++this.lastDirIndex;
                continue;
            }
            this.dirList.addElement(string);
        }
        this.dirSize = this.dirList.size();
        this.dirIndexIsImage = false;
    }

    private void traverse() {
        String string = (String)this.dirList.elementAt(this.dirIndex);
        if (string.equals("..")) {
            int n = this.currentDir.lastIndexOf(47, this.currentDir.length() - 2);
            this.currentDir = n != -1 ? this.currentDir.substring(0, n + 1) : "/";
            new Thread(new Runnable(){

                public void run() {
                    FileBrowsingCanvas.this.fileAction.getDirContent(FileBrowsingCanvas.this.currentDir);
                }
            }).start();
        } else if (this.dirIndex < this.lastDirIndex) {
            this.currentDir = this.currentDir + string;
            new Thread(new Runnable(){

                public void run() {
                    FileBrowsingCanvas.this.fileAction.getDirContent(FileBrowsingCanvas.this.currentDir);
                }
            }).start();
        }
    }

    public void run() {
        while (!this.stopped) {
            this.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    private boolean isImage(String string) {
        int n = string.length() - 4;
        if (n < 1) {
            return false;
        }
        String string2 = string.substring(n);
        if (string2.equalsIgnoreCase(".jpg")) {
            return true;
        }
        if (string2.equalsIgnoreCase(".gif")) {
            return true;
        }
        if (string2.equalsIgnoreCase(".png")) {
            return true;
        }
        return string2.equalsIgnoreCase(".bmp");
    }

    private void loadImage() {
        final String string = "file://" + this.currentDir + (String)this.dirList.elementAt(this.dirIndex);
        new Thread(new Runnable(){

            public void run() {
                FileBrowsingCanvas.this.fileAction.getImage(string);
            }
        }).start();
    }

    public void ImageReceived(Image image) {
        if (image == null) {
            return;
        }
        this.image = image;
        this.showingImage = true;
    }

    private void setProperties() {
        this.font_medium_Height = this.medium_Font.getHeight();
        this.font_small_Height = this.small_Font.getHeight();
        this.font_medium_Width = this.medium_Font.charWidth('w');
        this.font_small_Width = this.small_Font.charWidth('w');
        this.text_button_Width = this.font_medium_Width * 4;
        this.visibleTopIndex = 0;
        this.visibleBottomIndex = this.visibleBottomIndex_START = (this.HEIGHT - 4 * this.font_medium_Height) / this.font_small_Height;
        this.currentDir = "/";
    }

    private void loadProgramImages() {
        try {
            this.folderImage = Image.createImage((String)"/folder.png");
            this.fileImage = Image.createImage((String)"/file.png");
            this.downArrowImage = Image.createImage((String)"/downArrow.png");
            this.upArrowImage = Image.createImage((String)"/upArrow.png");
        }
        catch (Exception exception) {
            System.out.println("LoadProgramImages:" + exception.toString());
        }
    }
}

