/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Calendar;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;

public class ClockCanvas
extends GameCanvas
implements Runnable {
    MidletB parent;

    public ClockCanvas(MidletB p) {
        super(true);
        this.parent = p;
        this.setFullScreenMode(true);
    }

    public void start() {
        Thread runner = new Thread(this);
        runner.start();
    }

    public void run() {
        int iKey;
        byte[] byteArray;
        RecordStore rStore = null;
        boolean keepTicking = true;
        boolean showFigures = true;
        boolean showAnalogue = false;
        boolean showDigital = false;
        boolean showBinary = true;
        Graphics g = this.getGraphics();
        Calendar cal = Calendar.getInstance();
        String useDaylight = "GMT";
        int buttonDelay = 0;
        Image backImage = null;
        Image ledOn = null;
        Image splash = null;
        Image downArrow = null;
        Image rightArrow = null;
        Image arr = null;
        double radius = this.getWidth() / 2 - 5;
        if (this.getHeight() < this.getWidth()) {
            radius = this.getHeight() / 2 - 5;
        }
        radius -= (double)g.getFont().getHeight();
        int clockX = this.getWidth() / 2;
        int clockY = this.getHeight() / 2;
        int arrowX = 1;
        int minutes = 0;
        int hours = 0;
        int hoursForBinClock = 0;
        int seconds = 0;
        try {
            rStore = RecordStore.openRecordStore((String)"myRecordStore", (boolean)true);
            byteArray = rStore.getRecord(1);
            rStore.closeRecordStore();
            if (byteArray[0] == 0) {
                useDaylight = "GMT";
            }
            if (byteArray[0] == 1) {
                useDaylight = "DAY";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (useDaylight.equalsIgnoreCase("GMT")) {
            // empty if block
        }
        if (useDaylight != null && useDaylight.equalsIgnoreCase("DAY")) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 255, 255);
            int fontHeight = g.getFont().getHeight();
            g.drawString("BINARY CLOCK IS SET", 0, 0, 0);
            g.drawString("TO ADD AN HOUR TO", 0, fontHeight, 0);
            g.drawString("THE TIME FOR DAYLIGHT", 0, fontHeight += g.getFont().getHeight(), 0);
            g.drawString("SAVINGS.", 0, fontHeight += g.getFont().getHeight(), 0);
            fontHeight += g.getFont().getHeight();
            this.flushGraphics();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            backImage = Image.createImage((String)"/ck.png");
            ledOn = Image.createImage((String)"/n.png");
            splash = Image.createImage((String)"/splash.png");
            downArrow = Image.createImage((String)"/down.png");
            rightArrow = Image.createImage((String)"/right.png");
            arr = Image.createImage((String)"/arrow2.png");
        }
        catch (IOException ex) {
            System.out.println("NOLED");
        }
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        boolean started = false;
        while (!started) {
            iKey = this.getKeyStates();
            if ((iKey & 4) != 0 && arrowX > 1) {
                arrowX -= 44;
            }
            if ((iKey & 0x20) != 0 && arrowX < 132) {
                arrowX += 44;
            }
            if ((iKey & 0x100) != 0) {
                if (arrowX == 1) {
                    showAnalogue = false;
                    showBinary = true;
                    started = true;
                }
                if (arrowX == 45) {
                    showAnalogue = true;
                    showBinary = false;
                    started = true;
                }
                if (arrowX == 89) {
                    boolean needToClose = false;
                    try {
                        needToClose = this.parent.platformRequest("http://andysoftware.param.mobi/");
                    }
                    catch (ConnectionNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    if (needToClose) {
                        this.parent.destroyApp(false);
                        this.parent = null;
                    }
                }
                if (arrowX == 133) {
                    this.parent.destroyApp(false);
                    this.parent = null;
                }
            }
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(splash, 0, 0, 0);
            g.drawImage(arr, arrowX, 31, 0);
            this.flushGraphics();
            try {
                Thread.sleep(150L);
            }
            catch (Exception ex) {}
        }
        while (keepTicking) {
            String workString;
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 255, 255);
            iKey = this.getKeyStates();
            if (iKey == 0) {
                buttonDelay = 0;
            }
            if ((iKey & 2) != 0 && ++buttonDelay > 7) {
                try {
                    buttonDelay = 0;
                    try {
                        rStore = RecordStore.openRecordStore((String)"myRecordStore", (boolean)true);
                    }
                    catch (Exception e) {
                        System.out.println("foooook " + e);
                    }
                    useDaylight = "DAY";
                    byteArray = new byte[]{1};
                    if (rStore.getNumRecords() == 0) {
                        rStore.addRecord(byteArray, 0, byteArray.length);
                    } else {
                        rStore.setRecord(1, byteArray, 0, byteArray.length);
                    }
                }
                catch (Exception e) {
                    System.out.println("foooook " + e);
                }
            }
            if ((iKey & 0x40) != 0 && ++buttonDelay > 7) {
                try {
                    buttonDelay = 0;
                    try {
                        rStore = RecordStore.openRecordStore((String)"myRecordStore", (boolean)true);
                    }
                    catch (Exception e) {
                        System.out.println(" " + e);
                    }
                    useDaylight = "GMT";
                    byteArray = new byte[]{0};
                    if (rStore.getNumRecords() == 0) {
                        rStore.addRecord(byteArray, 0, byteArray.length);
                    } else {
                        rStore.setRecord(1, byteArray, 0, byteArray.length);
                    }
                }
                catch (Exception e) {
                    System.out.println(" " + e);
                }
            }
            if ((iKey & 4) != 0 && ++buttonDelay > 4) {
                buttonDelay = 0;
                if (showAnalogue) {
                    showAnalogue = false;
                    showBinary = true;
                } else {
                    showAnalogue = true;
                    showBinary = false;
                }
            }
            if ((iKey & 0x20) != 0 && ++buttonDelay > 4) {
                buttonDelay = 0;
                if (showAnalogue) {
                    showAnalogue = false;
                    showBinary = true;
                } else {
                    showAnalogue = true;
                    showBinary = false;
                }
            }
            if ((iKey & 0x100) != 0 && ++buttonDelay > 4) {
                int textX = 0;
                int textY = 0;
                boolean keepReading = true;
                boolean pauseOnce = true;
                buttonDelay = 0;
                while (keepReading) {
                    g.setColor(0, 0, 0);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(255, 255, 255);
                    int fontHeight = g.getFont().getHeight();
                    g.drawString("Press FIRE to go back to the clock.", 0 - textX, 0 - textY, 0);
                    g.drawString("Hold L and R to switch between", 0 - textX, fontHeight - textY, 0);
                    g.drawString("binary and analogue clocks.", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("In the summer, depending on", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("your phone's manufacturer, you", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("may need to manually add an hour", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("to the time. This can be done by", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("holding the Up button for a few", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("seconds. Holding the Down button", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("will return the clock to standard", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("time. This setting will be saved", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("for the next time you use the", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("clock. The letters 'DST' will be", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("displayed at the top of the screen.", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("......", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("Working out the time in binary:", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("Add together the numbers above each", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("lit LED. For example, if 8 and 2 are", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("lit on the hours row and 32,4 and 1", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("are lit on the minutes row, the time", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("will be: 10:37.", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("To exit, hold down your phones Back", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("or Red Phone button.", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("Visit www.andysoftware.co.uk for", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("more free applications and games", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.drawString("for the phone and desktop.", 0 - textX, (fontHeight += g.getFont().getHeight()) - textY, 0);
                    g.setColor(0, 0, 0);
                    g.fillRect(0, this.getHeight() - 38, this.getWidth(), this.getHeight());
                    if (!pauseOnce) {
                        g.drawImage(downArrow, this.getWidth() / 2 - 32, this.getHeight() - 34, 0);
                    }
                    this.flushGraphics();
                    if (pauseOnce) {
                        iKey = 0;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        iKey = 0;
                    }
                    if (((iKey = this.getKeyStates()) & 2) != 0 && textY > 0) {
                        textY -= 4;
                    }
                    if ((iKey & 0x40) != 0) {
                        textY += 4;
                    }
                    if ((iKey & 4) != 0 && textX > 0) {
                        textX -= 4;
                    }
                    if ((iKey & 0x20) != 0) {
                        textX += 4;
                    }
                    if (!pauseOnce && (iKey & 0x100) != 0) {
                        keepReading = false;
                        g.setColor(0, 0, 0);
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        this.flushGraphics();
                    }
                    pauseOnce = false;
                    try {
                        Thread.sleep(150L);
                    }
                    catch (Exception ex) {}
                }
            }
            hours = Calendar.getInstance().get(11);
            hoursForBinClock = Calendar.getInstance().get(10);
            if (useDaylight.equalsIgnoreCase("DAY")) {
                if (++hours == 24) {
                    hours = 0;
                }
                ++hoursForBinClock;
            }
            if (hoursForBinClock == 0) {
                hoursForBinClock = 12;
            }
            minutes = Calendar.getInstance().get(12);
            seconds = Calendar.getInstance().get(13);
            int day = Calendar.getInstance().get(5);
            String dayString = "" + day;
            if (dayString.length() == 1) {
                dayString = "0" + dayString;
            }
            if (showAnalogue) {
                double minLinesY2;
                double minLinesX2;
                double minLinesY;
                double minLinesX;
                int i;
                double secondX = (double)clockX + (radius - 5.0) * Math.cos(Math.toRadians((double)(seconds - 15) * 360.0 / 60.0));
                double secondY = (double)clockY + (radius - 5.0) * Math.sin(Math.toRadians((double)(seconds - 15) * 360.0 / 60.0));
                double minuteX = (double)clockX + (radius - 15.0) * Math.cos(Math.toRadians((double)(minutes - 15) * 360.0 / 60.0));
                double minuteY = (double)clockY + (radius - 15.0) * Math.sin(Math.toRadians((double)(minutes - 15) * 360.0 / 60.0));
                hours *= 5;
                if (minutes > 0) {
                    hours += minutes / 12;
                }
                double hourX = (double)clockX + radius / 2.0 * Math.cos(Math.toRadians((double)(hours - 15) * 360.0 / 60.0));
                double hourY = (double)clockY + radius / 2.0 * Math.sin(Math.toRadians((double)(hours - 15) * 360.0 / 60.0));
                g.setColor(200, 200, 200);
                g.setColor(255, 255, 255);
                g.fillRect(clockX + 20, clockY - g.getFont().getHeight() / 2, g.getFont().getHeight() + 8, g.getFont().getHeight() + 4);
                g.setColor(0, 0, 0);
                g.drawString("" + dayString, clockX + 24, clockY - g.getFont().getHeight() / 2, 0);
                for (i = 0; i < 60; ++i) {
                    g.setColor(255, 255, 255);
                    minLinesX = (double)clockX + (radius - 3.0) * Math.cos(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    minLinesY = (double)clockY + (radius - 3.0) * Math.sin(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    minLinesX2 = (double)clockX + (radius - 8.0) * Math.cos(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    minLinesY2 = (double)clockY + (radius - 8.0) * Math.sin(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    g.drawLine((int)minLinesX2, (int)minLinesY2, (int)minLinesX, (int)minLinesY);
                }
                for (i = 0; i < 60; i += 5) {
                    g.setColor(255, 255, 255);
                    minLinesX = (double)clockX + (radius - 3.0) * Math.cos(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    minLinesY = (double)clockY + (radius - 3.0) * Math.sin(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    minLinesX2 = (double)clockX + (radius - 12.0) * Math.cos(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    minLinesY2 = (double)clockY + (radius - 12.0) * Math.sin(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                    g.drawLine((int)minLinesX2, (int)minLinesY2, (int)minLinesX, (int)minLinesY);
                }
                if (showFigures) {
                    for (i = 0; i < 60; i += 5) {
                        g.setColor(255, 255, 255);
                        minLinesX = (double)(clockX - 3) + (radius + (double)(g.getFont().getHeight() - 4)) * Math.cos(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                        minLinesY = (double)(clockY - 7) + (radius + (double)(g.getFont().getHeight() - 4)) * Math.sin(Math.toRadians((double)(i - 15) * 360.0 / 60.0));
                        if (i < 5) {
                            g.drawString("12", (int)minLinesX - 2, (int)minLinesY, 0);
                            continue;
                        }
                        g.drawString("" + i / 5, (int)minLinesX, (int)minLinesY, 0);
                    }
                }
                g.setColor(255, 190, 190);
                g.drawLine(clockX, clockY, (int)secondX, (int)secondY);
                g.setColor(190, 255, 190);
                g.drawLine(clockX, clockY, (int)minuteX, (int)minuteY);
                g.setColor(190, 190, 255);
                g.drawLine(clockX, clockY, (int)hourX, (int)hourY);
                if (useDaylight.equalsIgnoreCase("DAY")) {
                    g.setColor(255, 255, 255);
                    g.drawString("DST", 0, 0, 0);
                }
                this.flushGraphics();
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!showBinary) continue;
            g.setColor(1091664);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 255, 255);
            g.drawImage(backImage, 0, 0, 0);
            String secondsBin = Integer.toBinaryString(seconds);
            int workInt1 = secondsBin.length() - 1;
            int workInt2 = secondsBin.length();
            int drawPosition = 0;
            while (workInt2 > 0) {
                workString = secondsBin.substring(workInt1, workInt2);
                if (workString.endsWith("1")) {
                    if (drawPosition == 0) {
                        g.drawImage(ledOn, 90, 121, 0);
                    }
                    if (drawPosition == 1) {
                        g.drawImage(ledOn, 74, 121, 0);
                    }
                    if (drawPosition == 2) {
                        g.drawImage(ledOn, 58, 121, 0);
                    }
                    if (drawPosition == 3) {
                        g.drawImage(ledOn, 42, 121, 0);
                    }
                    if (drawPosition == 4) {
                        g.drawImage(ledOn, 26, 121, 0);
                    }
                    if (drawPosition == 5) {
                        g.drawImage(ledOn, 10, 121, 0);
                    }
                }
                --workInt1;
                --workInt2;
                ++drawPosition;
            }
            String minutesBin = Integer.toBinaryString(minutes);
            workInt1 = minutesBin.length() - 1;
            workInt2 = minutesBin.length();
            drawPosition = 0;
            while (workInt2 > 0) {
                workString = minutesBin.substring(workInt1, workInt2);
                if (workString.endsWith("1")) {
                    if (drawPosition == 0) {
                        g.drawImage(ledOn, 91, 73, 0);
                    }
                    if (drawPosition == 1) {
                        g.drawImage(ledOn, 75, 73, 0);
                    }
                    if (drawPosition == 2) {
                        g.drawImage(ledOn, 59, 73, 0);
                    }
                    if (drawPosition == 3) {
                        g.drawImage(ledOn, 43, 73, 0);
                    }
                    if (drawPosition == 4) {
                        g.drawImage(ledOn, 27, 73, 0);
                    }
                    if (drawPosition == 5) {
                        g.drawImage(ledOn, 11, 73, 0);
                    }
                }
                --workInt1;
                --workInt2;
                ++drawPosition;
            }
            String hoursBin = Integer.toBinaryString(hoursForBinClock);
            workInt1 = hoursBin.length() - 1;
            workInt2 = hoursBin.length();
            drawPosition = 0;
            while (workInt2 > 0) {
                workString = hoursBin.substring(workInt1, workInt2);
                if (workString.endsWith("1")) {
                    if (drawPosition == 0) {
                        g.drawImage(ledOn, 84, 24, 0);
                    }
                    if (drawPosition == 1) {
                        g.drawImage(ledOn, 62, 24, 0);
                    }
                    if (drawPosition == 2) {
                        g.drawImage(ledOn, 40, 24, 0);
                    }
                    if (drawPosition == 3) {
                        g.drawImage(ledOn, 18, 24, 0);
                    }
                    if (drawPosition == 4) {
                        g.drawImage(ledOn, 27, 73, 0);
                    }
                    if (drawPosition == 5) {
                        g.drawImage(ledOn, 11, 73, 0);
                    }
                }
                --workInt1;
                --workInt2;
                ++drawPosition;
            }
            if (useDaylight.equalsIgnoreCase("DAY")) {
                g.setColor(0, 0, 0);
                g.drawString("DST", 130, 0, 0);
            }
            this.flushGraphics();
            try {
                Thread.sleep(200L);
            }
            catch (Exception ex) {}
        }
        g = null;
        this.parent.destroyApp(false);
        this.parent = null;
    }
}

