/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;

public class DMBCalc {
    public Calendar c1;
    public Calendar c2;
    public String DateName;
    private DMBRms DMBSettings;
    public int[] SettingsA;
    public String[] dates;
    private static final int[] cumulDaysToMonth = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

    DMBCalc(DMBRms dMBRms) {
        this.DMBSettings = dMBRms;
        this.c1 = Calendar.getInstance();
        Date date = new Date();
        this.c1.setTime(date);
        this.c1.set(2, this.c1.get(2));
        this.SettingsA = new int[3];
        this.SettingsA = this.DMBSettings.SettingsA;
        this.dates = this.DMBSettings.dates;
        this.c2 = Calendar.getInstance();
        this.SetCurrDMB();
        this.GetCurrDMB();
    }

    public String[] DateFromString(String string) {
        String string2 = string;
        String[] stringArray = new String[]{string2.substring(0, 2), string2.substring(3, 5), string2.substring(6, 10), string2.substring(12, string2.length() - 1)};
        return stringArray;
    }

    public Date GetCurrDMB() {
        this.c2.set(2, this.c2.get(2));
        Date date = this.c2.getTime();
        return date;
    }

    public void SetCurrDMB() {
        String[] stringArray = this.DateFromString(this.dates[this.SettingsA[2]]);
        this.c2.set(5, Integer.parseInt(stringArray[0]));
        this.c2.set(2, Integer.parseInt(stringArray[1]) - 1);
        this.c2.set(1, Integer.parseInt(stringArray[2]));
        this.c2.set(11, 0);
        this.c2.set(12, 0);
        this.c2.set(13, 0);
        this.c2.set(14, 0);
        this.DateName = stringArray[3];
        this.DMBSettings.Clear();
        this.DMBSettings.init();
        this.DMBSettings.SaveSettings(this.SettingsA, this.dates);
        this.DMBSettings.Shutdown();
    }

    public void SetColor(int n) {
        this.SettingsA[0] = n;
        this.DMBSettings.Clear();
        this.DMBSettings.init();
        this.DMBSettings.SaveSettings(this.SettingsA, this.dates);
        this.DMBSettings.Shutdown();
    }

    private String AddZ(int n) {
        String string = n < 10 ? "0" + n : "" + n;
        return string;
    }

    public void UpdateTime() {
        Date date = new Date();
        this.c1.setTime(date);
    }

    public String GetCTime() {
        String string = this.AddZ(this.c1.get(11)) + ":" + this.AddZ(this.c1.get(12)) + ":" + this.AddZ(this.c1.get(13)) + " " + this.AddZ(this.c1.get(5)) + "-" + this.AddZ(this.c1.get(2) + 1) + "-" + this.c1.get(1);
        return string;
    }

    public String GetDMBTime() {
        String string = this.AddZ(this.c2.get(11)) + ":" + this.AddZ(this.c2.get(12)) + ":" + this.AddZ(this.c2.get(13)) + " " + this.AddZ(this.c2.get(5)) + "-" + this.AddZ(this.c2.get(2) + 1) + "-" + this.c2.get(1);
        return string;
    }

    public long GetDiffS() {
        long l = this.c1.getTime().getTime();
        long l2 = this.c2.getTime().getTime();
        long l3 = l2 - l;
        return l3;
    }

    public static boolean isLeapYear(int n) {
        return n % 400 == 0 || n % 100 != 0 && n % 4 == 0;
    }

    static int numLeapsToYear(int n) {
        int n2 = (n - 1) / 4;
        int n3 = (n - 1) / 100;
        int n4 = (n - 1) / 400;
        return n2 - n3 + n4;
    }

    public static int daysSinceEpoch(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = cumulDaysToMonth[n2] + calendar.get(5);
        if (n2 > 1 && DMBCalc.isLeapYear(n)) {
            ++n3;
        }
        int n4 = 365 * n + DMBCalc.numLeapsToYear(n);
        return n4 + n3;
    }

    public static int monthsSinceEpoch(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = 12 * n + DMBCalc.numLeapsToYear(n);
        return n3 + n2;
    }

    public int GetDiffD() {
        return DMBCalc.daysSinceEpoch(this.c2) - DMBCalc.daysSinceEpoch(this.c1);
    }

    public int GetDiffM() {
        int n;
        int n2 = this.GetDiffD();
        if (n2 < (n = DMBCalc.monthsSinceEpoch(this.c2) - DMBCalc.monthsSinceEpoch(this.c1)) * 30) {
            --n;
        }
        return n;
    }
}

