/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.Line2D;
import org.thenesis.planetino2.bsp2D.Point2D;
import org.thenesis.planetino2.math3D.Vector3D;

public class BSPLine
extends Line2D.Float {
    public static final int BACK = -1;
    public static final int COLLINEAR = 0;
    public static final int FRONT = 1;
    public static final int SPANNING = 2;
    public float nx;
    public float ny;
    public float top;
    public float bottom;

    public BSPLine() {
    }

    public BSPLine(BSPPolygon poly) {
        this.setTo(poly);
    }

    public BSPLine(float x1, float y1, float x2, float y2) {
        this.setLine(x1, y1, x2, y2);
    }

    public void setTo(BSPPolygon poly) {
        if (!poly.isWall()) {
            throw new IllegalArgumentException("BSPPolygon not a wall");
        }
        this.top = Float.MIN_VALUE;
        this.bottom = Float.MAX_VALUE;
        float distance = -1.0f;
        for (int i = 0; i < poly.getNumVertices(); ++i) {
            Vector3D v1 = poly.getVertex(i);
            this.top = Math.max(this.top, v1.y);
            this.bottom = Math.min(this.bottom, v1.y);
            for (int j = 0; j < poly.getNumVertices(); ++j) {
                Vector3D v2 = poly.getVertex(j);
                float newDist = (float)Point2D.distanceSq(v1.x, v1.z, v2.x, v2.z);
                if (!(newDist > distance)) continue;
                distance = newDist;
                this.x1 = v1.x;
                this.y1 = v1.z;
                this.x2 = v2.x;
                this.y2 = v2.z;
            }
        }
        this.nx = poly.getNormal().x;
        this.ny = poly.getNormal().z;
    }

    public void calcNormal() {
        this.nx = this.y2 - this.y1;
        this.ny = this.x1 - this.x2;
    }

    public void normalize() {
        float length = (float)Math.sqrt(this.nx * this.nx + this.ny * this.ny);
        this.nx /= length;
        this.ny /= length;
    }

    public void setLine(float x1, float y1, float x2, float y2) {
        super.setLine(x1, y1, x2, y2);
        this.calcNormal();
    }

    public void setLine(double x1, double y1, double x2, double y2) {
        super.setLine(x1, y1, x2, y2);
        this.calcNormal();
    }

    public void flip() {
        float tx = this.x1;
        float ty = this.y1;
        this.x1 = this.x2;
        this.y1 = this.y2;
        this.x2 = tx;
        this.y2 = ty;
        this.nx = -this.nx;
        this.ny = -this.ny;
    }

    public void setHeight(float top, float bottom) {
        this.top = top;
        this.bottom = bottom;
    }

    public boolean equals(BSPLine line) {
        return this.x1 == line.x1 && this.x2 == line.x2 && this.y1 == line.y1 && this.y2 == line.y2;
    }

    public boolean equalsIgnoreOrder(BSPLine line) {
        return this.equals(line) || this.x1 == line.x2 && this.x2 == line.x1 && this.y1 == line.y2 && this.y2 == line.y1;
    }

    public String toString() {
        return "(" + this.x1 + ", " + this.y1 + ")->" + "(" + this.x2 + "," + this.y2 + ")" + " bottom: " + this.bottom + " top: " + this.top;
    }

    public int getSideThick(float x, float y) {
        int backSide;
        int frontSide = this.getSideThin(x - this.nx / 2.0f, y - this.ny / 2.0f);
        if (frontSide == 1) {
            return 1;
        }
        if (frontSide == -1 && (backSide = this.getSideThin(x + this.nx / 2.0f, y + this.ny / 2.0f)) == -1) {
            return -1;
        }
        return 0;
    }

    public int getSideThin(float x, float y) {
        float side = (x - this.x1) * this.nx + (y - this.y1) * this.ny;
        return side < 0.0f ? -1 : (side > 0.0f ? 1 : 0);
    }

    public int getSide(Line2D.Float segment) {
        int p2Side;
        if (this == segment) {
            return 0;
        }
        int p1Side = this.getSideThick(segment.x1, segment.y1);
        if (p1Side == (p2Side = this.getSideThick(segment.x2, segment.y2))) {
            return p1Side;
        }
        if (p1Side == 0) {
            return p2Side;
        }
        if (p2Side == 0) {
            return p1Side;
        }
        return 2;
    }

    public int getSide(BSPPolygon poly) {
        boolean onFront = false;
        boolean onBack = false;
        for (int i = 0; i < poly.getNumVertices(); ++i) {
            Vector3D v = poly.getVertex(i);
            int side = this.getSideThick(v.x, v.z);
            if (side == 1) {
                onFront = true;
                continue;
            }
            if (side != -1) continue;
            onBack = true;
        }
        if (onFront && onBack) {
            return 2;
        }
        if (onFront) {
            return 1;
        }
        if (onBack) {
            return -1;
        }
        return 0;
    }

    public float getIntersection(Line2D.Float line) {
        float denominator = (line.y2 - line.y1) * (this.x2 - this.x1) - (line.x2 - line.x1) * (this.y2 - this.y1);
        if (denominator == 0.0f) {
            return -1.0f;
        }
        float numerator = (line.x2 - line.x1) * (this.y1 - line.y1) - (line.y2 - line.y1) * (this.x1 - line.x1);
        return numerator / denominator;
    }

    public Point2D.Float getIntersectionPoint(Line2D.Float line) {
        return this.getIntersectionPoint(line, null);
    }

    public Point2D.Float getIntersectionPoint(Line2D.Float line, Point2D.Float intersection) {
        if (intersection == null) {
            intersection = new Point2D.Float();
        }
        float fraction = this.getIntersection(line);
        intersection.setLocation(this.x1 + fraction * (this.x2 - this.x1), this.y1 + fraction * (this.y2 - this.y1));
        return intersection;
    }
}

